//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#include "link.h"
#include <iostream>

#define  TRIES 1

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

Link::Link(void) :  DLE(16) ,ETX(3), ACK(6), NAK(21) { clear(); };

void Link::clear(void) {  for(int i=0;i<DATA_SIZE;i++) data[i]=0; };


/// tries to get an garmin packet
/** returns -1 if failed and 1 if a valid packet came in 
*/
int Link::getPacket(Packet & gld)
{
   gld.clear();

   for(int i=0; i<TRIES; i++)
   {
      if(getRawPacket()>0) 
      {
         gld.pid=data[1];
         gld.length=data[2];
         for(int i=0; i<data[2];i++)
            gld.data[i]=data[i+3];
         if(validateChecksum()) {
            sendACK(gld.pid);
            return 1; }
         else { sendNAK(gld.pid);}
      }
   }
   return -1;
};

// **************************************************************************
int Link::getRawPacket(void)
{
//   cout << "------------------------------------" << endl;
   g_byte c;
   int counter=0;
   clear();

   do // read something until DLE  the start of an new package comes along
   {
     if(readByte(c)<1) return 0;
   } while(c!=DLE);

   // this is the PID byte, no DLE stuffing here 
   data[counter]=c;
   counter++;

   while(readByte(c)==1)
   {   
      if(c==DLE) // data Link escape read an other Byte!
      {
         readByte(c);
         if(c==ETX) { //  DLE+ETX -> end of Packet :) 
            data[counter]=DLE;
            counter++;
            data[counter]=ETX;
            return counter; }
//       else an other DLE , do nothing 
      }
      data[counter]=c; counter++;
   }
   return -1;
};

// *******************************************************************************
int Link::sendPacket(Packet gld)
{
   clear();
   for(int i=0; i<TRIES; i++)
   {
      data[0]=DLE;
      data[1]=gld.pid;
      data[2]=gld.length;
      for(int i=0; i<data[2];i++)
         data[i+3]=gld.data[i];
      if(sendRawPacket()>=0)
      {
         clear();
         getRawPacket();
         if(data[1]==ACK && data[3]==gld.pid)
            return 1;
      }
   }
   return -1;
};

// ****************************************************************************
int Link::sendRawPacket(void)
{
   setChecksum();
   writeByte(DLE);
   writeByte(data[1]); // the PID byte, no DLE stuffing here
   for(int i=2;i<=data[2]+3;i++)
   {
      writeByte(data[i]);
      if(data[i]==DLE) writeByte(DLE);
   }
   writeByte(DLE);
   writeByte(ETX);
   
   // should be made better !
   return 1;
};


// *****************************************************************************
void Link::sendNAK(g_byte pid)
{
   clear();
   data[1]=NAK;
   data[2]=2;
   data[3]=pid;

   sendRawPacket();
}

void Link::sendACK(g_byte pid)
{
   clear();
   data[1]=ACK;
   data[2]=2;
   data[3]=pid;

   sendRawPacket();
}
// *****************************************************************************
bool Link::validateChecksum(void)
{
   g_byte csc = calculateChecksum();

   if(csc==data[3+data[2]]) return 1; 
   else { cerr << "wrong checksum" << endl; return 0; }
}


void Link::setChecksum(void)
{
   g_byte csc = calculateChecksum();
   data[3+data[2]] = csc;
}

g_byte Link::calculateChecksum(void)
{
   g_byte csc=0;
   for(int i=1; i<=2+data[2]; i++)
      csc+=data[i];
   csc=~csc; 
   csc++;

   return csc;
}

}
