//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#include "date_time_type.h"

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

string Date_Time_Type::os(void)
{
   string s;

	s = "type=\"gpstime\" ";

	s += "second=\""+toString(second)+"\" ";
	s += "minute=\""+toString(minute)+"\" ";
	s += "hour=\""+toString(hour)+"\"     ";
	s += "day=\""+toString(day)+"\"  ";
	s += "month=\""+toString(month)+"\"  ";
	s += "year=\""+toString(year)+"\"  ";

   s+="\n";
   return s;
}

void Date_Time_Type::os(ostream os)
{
   os << this->os();
}



Date_Time_Type::Date_Time_Type(void)
{
   clear();
}

void Date_Time_Type::clear(void)
{
	second=0;
	minute=0;
	hour=0;
	day=1;
	month=1;
	year=1970;
}


void Date_Time_Type::set(Packet pk)
{
	cerr << " this should not have happened " <<  endl;
}

Packet Date_Time_Type::makePacket(void)
{
	cerr << " this should not have happened " <<  endl;
	Packet pk;
	return pk;
}

void Date_Time_Type::operator<<(string s)
{
   clear();
   set(s);
}

void Date_Time_Type::set(string s)
{
   clear();
   setLine(s);

	second = GPDLineTool::s2i(readValue("second"));
	minute = GPDLineTool::s2i(readValue("minute"));
	hour = GPDLineTool::s2i(readValue("hour"));
	day = GPDLineTool::s2i(readValue("day"));
	month = GPDLineTool::s2i(readValue("month"));
	year = GPDLineTool::s2i(readValue("year"));
}

}
