//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#include "d300_trk_point_type.h"

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

void  D300_Trk_Point_Type::set(Packet pk)
{
   g_long lat;                                          // byte    0-3   
   g_long lon;                                          //           4-7
   g_longword time; /* time */                         //       8-11
   g_boolean new_trk; /* new track segment? */          //       1

   lat=ltoh32(*(g_long*)(&pk.data[0]));
   lon=ltoh32(*(g_long*)(&pk.data[4]));
   time=ltoh32(*(g_longword*)(&pk.data[8]));
   new_trk=*(g_boolean*)(&pk.data[12]);

   latitude = Pos_Type::s2d(lat);
   longitude = Pos_Type::s2d(lon);
   altitude = UNDEF_FLOAT;
   unixtime = time + TIMEOFFSET;
   new_segment = new_trk;
}

Packet  D300_Trk_Point_Type::makePacket(void)
{
   Packet pk;
	g_long lat = Pos_Type::d2s(latitude);                     //      0-3   
   g_long lon = Pos_Type::d2s(longitude);                    //      4-7
   g_longword time = unixtime - TIMEOFFSET;                //      8-11
   g_boolean new_trk = new_trk;                            //      12

   *(g_long*)(&pk.data[0])=htol32(g_long(lat));
   *(g_long*)(&pk.data[4])=htol32(g_long(lon));
   *(g_longword*)(&pk.data[8])=htol32(g_longword(time));
   *(g_boolean*)(&pk.data[12])=(g_boolean(new_trk));
	
   pk.length=13;
	pk.pid=Pid_Trk_Data;

   return pk;

}

}
