// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.12.3
// source: google/ads/googleads/v2/resources/account_budget.proto

package resources

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v2/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// An account-level budget. It contains information about the budget itself,
// as well as the most recently approved changes to the budget and proposed
// changes that are pending approval. The proposed changes that are pending
// approval, if any, are found in 'pending_proposal'.  Effective details about
// the budget are found in fields prefixed 'approved_', 'adjusted_' and those
// without a prefix.  Since some effective details may differ from what the user
// had originally requested (e.g. spending limit), these differences are
// juxtaposed via 'proposed_', 'approved_', and possibly 'adjusted_' fields.
//
// This resource is mutated using AccountBudgetProposal and cannot be mutated
// directly. A budget may have at most one pending proposal at any given time.
// It is read through pending_proposal.
//
// Once approved, a budget may be subject to adjustments, such as credit
// adjustments.  Adjustments create differences between the 'approved' and
// 'adjusted' fields, which would otherwise be identical.
type AccountBudget struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the account-level budget.
	// AccountBudget resource names have the form:
	//
	// `customers/{customer_id}/accountBudgets/{account_budget_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Output only. The ID of the account-level budget.
	Id *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// Output only. The resource name of the billing setup associated with this account-level
	// budget.  BillingSetup resource names have the form:
	//
	// `customers/{customer_id}/billingSetups/{billing_setup_id}`
	BillingSetup *wrapperspb.StringValue `protobuf:"bytes,3,opt,name=billing_setup,json=billingSetup,proto3" json:"billing_setup,omitempty"`
	// Output only. The status of this account-level budget.
	Status enums.AccountBudgetStatusEnum_AccountBudgetStatus `protobuf:"varint,4,opt,name=status,proto3,enum=google.ads.googleads.v2.enums.AccountBudgetStatusEnum_AccountBudgetStatus" json:"status,omitempty"`
	// Output only. The name of the account-level budget.
	Name *wrapperspb.StringValue `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The proposed start time of the account-level budget in
	// yyyy-MM-dd HH:mm:ss format.  If a start time type of NOW was proposed,
	// this is the time of request.
	ProposedStartDateTime *wrapperspb.StringValue `protobuf:"bytes,6,opt,name=proposed_start_date_time,json=proposedStartDateTime,proto3" json:"proposed_start_date_time,omitempty"`
	// Output only. The approved start time of the account-level budget in yyyy-MM-dd HH:mm:ss
	// format.
	//
	// For example, if a new budget is approved after the proposed start time,
	// the approved start time is the time of approval.
	ApprovedStartDateTime *wrapperspb.StringValue `protobuf:"bytes,7,opt,name=approved_start_date_time,json=approvedStartDateTime,proto3" json:"approved_start_date_time,omitempty"`
	// Output only. The total adjustments amount.
	//
	// An example of an adjustment is courtesy credits.
	TotalAdjustmentsMicros *wrapperspb.Int64Value `protobuf:"bytes,18,opt,name=total_adjustments_micros,json=totalAdjustmentsMicros,proto3" json:"total_adjustments_micros,omitempty"`
	// Output only. The value of Ads that have been served, in micros.
	//
	// This includes overdelivery costs, in which case a credit might be
	// automatically applied to the budget (see total_adjustments_micros).
	AmountServedMicros *wrapperspb.Int64Value `protobuf:"bytes,19,opt,name=amount_served_micros,json=amountServedMicros,proto3" json:"amount_served_micros,omitempty"`
	// Output only. A purchase order number is a value that helps users reference this budget
	// in their monthly invoices.
	PurchaseOrderNumber *wrapperspb.StringValue `protobuf:"bytes,20,opt,name=purchase_order_number,json=purchaseOrderNumber,proto3" json:"purchase_order_number,omitempty"`
	// Output only. Notes associated with the budget.
	Notes *wrapperspb.StringValue `protobuf:"bytes,21,opt,name=notes,proto3" json:"notes,omitempty"`
	// Output only. The pending proposal to modify this budget, if applicable.
	PendingProposal *AccountBudget_PendingAccountBudgetProposal `protobuf:"bytes,22,opt,name=pending_proposal,json=pendingProposal,proto3" json:"pending_proposal,omitempty"`
	// The proposed end time of the account-level budget.
	//
	// Types that are assignable to ProposedEndTime:
	//	*AccountBudget_ProposedEndDateTime
	//	*AccountBudget_ProposedEndTimeType
	ProposedEndTime isAccountBudget_ProposedEndTime `protobuf_oneof:"proposed_end_time"`
	// The approved end time of the account-level budget.
	//
	// For example, if a budget's end time is updated and the proposal is approved
	// after the proposed end time, the approved end time is the time of approval.
	//
	// Types that are assignable to ApprovedEndTime:
	//	*AccountBudget_ApprovedEndDateTime
	//	*AccountBudget_ApprovedEndTimeType
	ApprovedEndTime isAccountBudget_ApprovedEndTime `protobuf_oneof:"approved_end_time"`
	// The proposed spending limit.
	//
	// Types that are assignable to ProposedSpendingLimit:
	//	*AccountBudget_ProposedSpendingLimitMicros
	//	*AccountBudget_ProposedSpendingLimitType
	ProposedSpendingLimit isAccountBudget_ProposedSpendingLimit `protobuf_oneof:"proposed_spending_limit"`
	// The approved spending limit.
	//
	// For example, if the amount already spent by the account exceeds the
	// proposed spending limit at the time the proposal is approved, the approved
	// spending limit is set to the amount already spent.
	//
	// Types that are assignable to ApprovedSpendingLimit:
	//	*AccountBudget_ApprovedSpendingLimitMicros
	//	*AccountBudget_ApprovedSpendingLimitType
	ApprovedSpendingLimit isAccountBudget_ApprovedSpendingLimit `protobuf_oneof:"approved_spending_limit"`
	// The spending limit after adjustments have been applied.  Adjustments are
	// stored in total_adjustments_micros.
	//
	// This value has the final say on how much the account is allowed to spend.
	//
	// Types that are assignable to AdjustedSpendingLimit:
	//	*AccountBudget_AdjustedSpendingLimitMicros
	//	*AccountBudget_AdjustedSpendingLimitType
	AdjustedSpendingLimit isAccountBudget_AdjustedSpendingLimit `protobuf_oneof:"adjusted_spending_limit"`
}

func (x *AccountBudget) Reset() {
	*x = AccountBudget{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v2_resources_account_budget_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccountBudget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccountBudget) ProtoMessage() {}

func (x *AccountBudget) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v2_resources_account_budget_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccountBudget.ProtoReflect.Descriptor instead.
func (*AccountBudget) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v2_resources_account_budget_proto_rawDescGZIP(), []int{0}
}

func (x *AccountBudget) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *AccountBudget) GetId() *wrapperspb.Int64Value {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *AccountBudget) GetBillingSetup() *wrapperspb.StringValue {
	if x != nil {
		return x.BillingSetup
	}
	return nil
}

func (x *AccountBudget) GetStatus() enums.AccountBudgetStatusEnum_AccountBudgetStatus {
	if x != nil {
		return x.Status
	}
	return enums.AccountBudgetStatusEnum_UNSPECIFIED
}

func (x *AccountBudget) GetName() *wrapperspb.StringValue {
	if x != nil {
		return x.Name
	}
	return nil
}

func (x *AccountBudget) GetProposedStartDateTime() *wrapperspb.StringValue {
	if x != nil {
		return x.ProposedStartDateTime
	}
	return nil
}

func (x *AccountBudget) GetApprovedStartDateTime() *wrapperspb.StringValue {
	if x != nil {
		return x.ApprovedStartDateTime
	}
	return nil
}

func (x *AccountBudget) GetTotalAdjustmentsMicros() *wrapperspb.Int64Value {
	if x != nil {
		return x.TotalAdjustmentsMicros
	}
	return nil
}

func (x *AccountBudget) GetAmountServedMicros() *wrapperspb.Int64Value {
	if x != nil {
		return x.AmountServedMicros
	}
	return nil
}

func (x *AccountBudget) GetPurchaseOrderNumber() *wrapperspb.StringValue {
	if x != nil {
		return x.PurchaseOrderNumber
	}
	return nil
}

func (x *AccountBudget) GetNotes() *wrapperspb.StringValue {
	if x != nil {
		return x.Notes
	}
	return nil
}

func (x *AccountBudget) GetPendingProposal() *AccountBudget_PendingAccountBudgetProposal {
	if x != nil {
		return x.PendingProposal
	}
	return nil
}

func (m *AccountBudget) GetProposedEndTime() isAccountBudget_ProposedEndTime {
	if m != nil {
		return m.ProposedEndTime
	}
	return nil
}

func (x *AccountBudget) GetProposedEndDateTime() *wrapperspb.StringValue {
	if x, ok := x.GetProposedEndTime().(*AccountBudget_ProposedEndDateTime); ok {
		return x.ProposedEndDateTime
	}
	return nil
}

func (x *AccountBudget) GetProposedEndTimeType() enums.TimeTypeEnum_TimeType {
	if x, ok := x.GetProposedEndTime().(*AccountBudget_ProposedEndTimeType); ok {
		return x.ProposedEndTimeType
	}
	return enums.TimeTypeEnum_UNSPECIFIED
}

func (m *AccountBudget) GetApprovedEndTime() isAccountBudget_ApprovedEndTime {
	if m != nil {
		return m.ApprovedEndTime
	}
	return nil
}

func (x *AccountBudget) GetApprovedEndDateTime() *wrapperspb.StringValue {
	if x, ok := x.GetApprovedEndTime().(*AccountBudget_ApprovedEndDateTime); ok {
		return x.ApprovedEndDateTime
	}
	return nil
}

func (x *AccountBudget) GetApprovedEndTimeType() enums.TimeTypeEnum_TimeType {
	if x, ok := x.GetApprovedEndTime().(*AccountBudget_ApprovedEndTimeType); ok {
		return x.ApprovedEndTimeType
	}
	return enums.TimeTypeEnum_UNSPECIFIED
}

func (m *AccountBudget) GetProposedSpendingLimit() isAccountBudget_ProposedSpendingLimit {
	if m != nil {
		return m.ProposedSpendingLimit
	}
	return nil
}

func (x *AccountBudget) GetProposedSpendingLimitMicros() *wrapperspb.Int64Value {
	if x, ok := x.GetProposedSpendingLimit().(*AccountBudget_ProposedSpendingLimitMicros); ok {
		return x.ProposedSpendingLimitMicros
	}
	return nil
}

func (x *AccountBudget) GetProposedSpendingLimitType() enums.SpendingLimitTypeEnum_SpendingLimitType {
	if x, ok := x.GetProposedSpendingLimit().(*AccountBudget_ProposedSpendingLimitType); ok {
		return x.ProposedSpendingLimitType
	}
	return enums.SpendingLimitTypeEnum_UNSPECIFIED
}

func (m *AccountBudget) GetApprovedSpendingLimit() isAccountBudget_ApprovedSpendingLimit {
	if m != nil {
		return m.ApprovedSpendingLimit
	}
	return nil
}

func (x *AccountBudget) GetApprovedSpendingLimitMicros() *wrapperspb.Int64Value {
	if x, ok := x.GetApprovedSpendingLimit().(*AccountBudget_ApprovedSpendingLimitMicros); ok {
		return x.ApprovedSpendingLimitMicros
	}
	return nil
}

func (x *AccountBudget) GetApprovedSpendingLimitType() enums.SpendingLimitTypeEnum_SpendingLimitType {
	if x, ok := x.GetApprovedSpendingLimit().(*AccountBudget_ApprovedSpendingLimitType); ok {
		return x.ApprovedSpendingLimitType
	}
	return enums.SpendingLimitTypeEnum_UNSPECIFIED
}

func (m *AccountBudget) GetAdjustedSpendingLimit() isAccountBudget_AdjustedSpendingLimit {
	if m != nil {
		return m.AdjustedSpendingLimit
	}
	return nil
}

func (x *AccountBudget) GetAdjustedSpendingLimitMicros() *wrapperspb.Int64Value {
	if x, ok := x.GetAdjustedSpendingLimit().(*AccountBudget_AdjustedSpendingLimitMicros); ok {
		return x.AdjustedSpendingLimitMicros
	}
	return nil
}

func (x *AccountBudget) GetAdjustedSpendingLimitType() enums.SpendingLimitTypeEnum_SpendingLimitType {
	if x, ok := x.GetAdjustedSpendingLimit().(*AccountBudget_AdjustedSpendingLimitType); ok {
		return x.AdjustedSpendingLimitType
	}
	return enums.SpendingLimitTypeEnum_UNSPECIFIED
}

type isAccountBudget_ProposedEndTime interface {
	isAccountBudget_ProposedEndTime()
}

type AccountBudget_ProposedEndDateTime struct {
	// Output only. The proposed end time in yyyy-MM-dd HH:mm:ss format.
	ProposedEndDateTime *wrapperspb.StringValue `protobuf:"bytes,8,opt,name=proposed_end_date_time,json=proposedEndDateTime,proto3,oneof"`
}

type AccountBudget_ProposedEndTimeType struct {
	// Output only. The proposed end time as a well-defined type, e.g. FOREVER.
	ProposedEndTimeType enums.TimeTypeEnum_TimeType `protobuf:"varint,9,opt,name=proposed_end_time_type,json=proposedEndTimeType,proto3,enum=google.ads.googleads.v2.enums.TimeTypeEnum_TimeType,oneof"`
}

func (*AccountBudget_ProposedEndDateTime) isAccountBudget_ProposedEndTime() {}

func (*AccountBudget_ProposedEndTimeType) isAccountBudget_ProposedEndTime() {}

type isAccountBudget_ApprovedEndTime interface {
	isAccountBudget_ApprovedEndTime()
}

type AccountBudget_ApprovedEndDateTime struct {
	// Output only. The approved end time in yyyy-MM-dd HH:mm:ss format.
	ApprovedEndDateTime *wrapperspb.StringValue `protobuf:"bytes,10,opt,name=approved_end_date_time,json=approvedEndDateTime,proto3,oneof"`
}

type AccountBudget_ApprovedEndTimeType struct {
	// Output only. The approved end time as a well-defined type, e.g. FOREVER.
	ApprovedEndTimeType enums.TimeTypeEnum_TimeType `protobuf:"varint,11,opt,name=approved_end_time_type,json=approvedEndTimeType,proto3,enum=google.ads.googleads.v2.enums.TimeTypeEnum_TimeType,oneof"`
}

func (*AccountBudget_ApprovedEndDateTime) isAccountBudget_ApprovedEndTime() {}

func (*AccountBudget_ApprovedEndTimeType) isAccountBudget_ApprovedEndTime() {}

type isAccountBudget_ProposedSpendingLimit interface {
	isAccountBudget_ProposedSpendingLimit()
}

type AccountBudget_ProposedSpendingLimitMicros struct {
	// Output only. The proposed spending limit in micros.  One million is equivalent to
	// one unit.
	ProposedSpendingLimitMicros *wrapperspb.Int64Value `protobuf:"bytes,12,opt,name=proposed_spending_limit_micros,json=proposedSpendingLimitMicros,proto3,oneof"`
}

type AccountBudget_ProposedSpendingLimitType struct {
	// Output only. The proposed spending limit as a well-defined type, e.g. INFINITE.
	ProposedSpendingLimitType enums.SpendingLimitTypeEnum_SpendingLimitType `protobuf:"varint,13,opt,name=proposed_spending_limit_type,json=proposedSpendingLimitType,proto3,enum=google.ads.googleads.v2.enums.SpendingLimitTypeEnum_SpendingLimitType,oneof"`
}

func (*AccountBudget_ProposedSpendingLimitMicros) isAccountBudget_ProposedSpendingLimit() {}

func (*AccountBudget_ProposedSpendingLimitType) isAccountBudget_ProposedSpendingLimit() {}

type isAccountBudget_ApprovedSpendingLimit interface {
	isAccountBudget_ApprovedSpendingLimit()
}

type AccountBudget_ApprovedSpendingLimitMicros struct {
	// Output only. The approved spending limit in micros.  One million is equivalent to
	// one unit.  This will only be populated if the proposed spending limit
	// is finite, and will always be greater than or equal to the
	// proposed spending limit.
	ApprovedSpendingLimitMicros *wrapperspb.Int64Value `protobuf:"bytes,14,opt,name=approved_spending_limit_micros,json=approvedSpendingLimitMicros,proto3,oneof"`
}

type AccountBudget_ApprovedSpendingLimitType struct {
	// Output only. The approved spending limit as a well-defined type, e.g. INFINITE.  This
	// will only be populated if the approved spending limit is INFINITE.
	ApprovedSpendingLimitType enums.SpendingLimitTypeEnum_SpendingLimitType `protobuf:"varint,15,opt,name=approved_spending_limit_type,json=approvedSpendingLimitType,proto3,enum=google.ads.googleads.v2.enums.SpendingLimitTypeEnum_SpendingLimitType,oneof"`
}

func (*AccountBudget_ApprovedSpendingLimitMicros) isAccountBudget_ApprovedSpendingLimit() {}

func (*AccountBudget_ApprovedSpendingLimitType) isAccountBudget_ApprovedSpendingLimit() {}

type isAccountBudget_AdjustedSpendingLimit interface {
	isAccountBudget_AdjustedSpendingLimit()
}

type AccountBudget_AdjustedSpendingLimitMicros struct {
	// Output only. The adjusted spending limit in micros.  One million is equivalent to
	// one unit.
	//
	// If the approved spending limit is finite, the adjusted
	// spending limit may vary depending on the types of adjustments applied
	// to this budget, if applicable.
	//
	// The different kinds of adjustments are described here:
	// https://support.google.com/google-ads/answer/1704323
	//
	// For example, a debit adjustment reduces how much the account is
	// allowed to spend.
	AdjustedSpendingLimitMicros *wrapperspb.Int64Value `protobuf:"bytes,16,opt,name=adjusted_spending_limit_micros,json=adjustedSpendingLimitMicros,proto3,oneof"`
}

type AccountBudget_AdjustedSpendingLimitType struct {
	// Output only. The adjusted spending limit as a well-defined type, e.g. INFINITE.
	// This will only be populated if the adjusted spending limit is INFINITE,
	// which is guaranteed to be true if the approved spending limit is
	// INFINITE.
	AdjustedSpendingLimitType enums.SpendingLimitTypeEnum_SpendingLimitType `protobuf:"varint,17,opt,name=adjusted_spending_limit_type,json=adjustedSpendingLimitType,proto3,enum=google.ads.googleads.v2.enums.SpendingLimitTypeEnum_SpendingLimitType,oneof"`
}

func (*AccountBudget_AdjustedSpendingLimitMicros) isAccountBudget_AdjustedSpendingLimit() {}

func (*AccountBudget_AdjustedSpendingLimitType) isAccountBudget_AdjustedSpendingLimit() {}

// A pending proposal associated with the enclosing account-level budget,
// if applicable.
type AccountBudget_PendingAccountBudgetProposal struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the proposal.
	// AccountBudgetProposal resource names have the form:
	//
	// `customers/{customer_id}/accountBudgetProposals/{account_budget_proposal_id}`
	AccountBudgetProposal *wrapperspb.StringValue `protobuf:"bytes,1,opt,name=account_budget_proposal,json=accountBudgetProposal,proto3" json:"account_budget_proposal,omitempty"`
	// Output only. The type of this proposal, e.g. END to end the budget associated
	// with this proposal.
	ProposalType enums.AccountBudgetProposalTypeEnum_AccountBudgetProposalType `protobuf:"varint,2,opt,name=proposal_type,json=proposalType,proto3,enum=google.ads.googleads.v2.enums.AccountBudgetProposalTypeEnum_AccountBudgetProposalType" json:"proposal_type,omitempty"`
	// Output only. The name to assign to the account-level budget.
	Name *wrapperspb.StringValue `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The start time in yyyy-MM-dd HH:mm:ss format.
	StartDateTime *wrapperspb.StringValue `protobuf:"bytes,4,opt,name=start_date_time,json=startDateTime,proto3" json:"start_date_time,omitempty"`
	// Output only. A purchase order number is a value that helps users reference this budget
	// in their monthly invoices.
	PurchaseOrderNumber *wrapperspb.StringValue `protobuf:"bytes,9,opt,name=purchase_order_number,json=purchaseOrderNumber,proto3" json:"purchase_order_number,omitempty"`
	// Output only. Notes associated with this budget.
	Notes *wrapperspb.StringValue `protobuf:"bytes,10,opt,name=notes,proto3" json:"notes,omitempty"`
	// Output only. The time when this account-level budget proposal was created.
	// Formatted as yyyy-MM-dd HH:mm:ss.
	CreationDateTime *wrapperspb.StringValue `protobuf:"bytes,11,opt,name=creation_date_time,json=creationDateTime,proto3" json:"creation_date_time,omitempty"`
	// The end time of the account-level budget.
	//
	// Types that are assignable to EndTime:
	//	*AccountBudget_PendingAccountBudgetProposal_EndDateTime
	//	*AccountBudget_PendingAccountBudgetProposal_EndTimeType
	EndTime isAccountBudget_PendingAccountBudgetProposal_EndTime `protobuf_oneof:"end_time"`
	// The spending limit.
	//
	// Types that are assignable to SpendingLimit:
	//	*AccountBudget_PendingAccountBudgetProposal_SpendingLimitMicros
	//	*AccountBudget_PendingAccountBudgetProposal_SpendingLimitType
	SpendingLimit isAccountBudget_PendingAccountBudgetProposal_SpendingLimit `protobuf_oneof:"spending_limit"`
}

func (x *AccountBudget_PendingAccountBudgetProposal) Reset() {
	*x = AccountBudget_PendingAccountBudgetProposal{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v2_resources_account_budget_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccountBudget_PendingAccountBudgetProposal) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccountBudget_PendingAccountBudgetProposal) ProtoMessage() {}

func (x *AccountBudget_PendingAccountBudgetProposal) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v2_resources_account_budget_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccountBudget_PendingAccountBudgetProposal.ProtoReflect.Descriptor instead.
func (*AccountBudget_PendingAccountBudgetProposal) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v2_resources_account_budget_proto_rawDescGZIP(), []int{0, 0}
}

func (x *AccountBudget_PendingAccountBudgetProposal) GetAccountBudgetProposal() *wrapperspb.StringValue {
	if x != nil {
		return x.AccountBudgetProposal
	}
	return nil
}

func (x *AccountBudget_PendingAccountBudgetProposal) GetProposalType() enums.AccountBudgetProposalTypeEnum_AccountBudgetProposalType {
	if x != nil {
		return x.ProposalType
	}
	return enums.AccountBudgetProposalTypeEnum_UNSPECIFIED
}

func (x *AccountBudget_PendingAccountBudgetProposal) GetName() *wrapperspb.StringValue {
	if x != nil {
		return x.Name
	}
	return nil
}

func (x *AccountBudget_PendingAccountBudgetProposal) GetStartDateTime() *wrapperspb.StringValue {
	if x != nil {
		return x.StartDateTime
	}
	return nil
}

func (x *AccountBudget_PendingAccountBudgetProposal) GetPurchaseOrderNumber() *wrapperspb.StringValue {
	if x != nil {
		return x.PurchaseOrderNumber
	}
	return nil
}

func (x *AccountBudget_PendingAccountBudgetProposal) GetNotes() *wrapperspb.StringValue {
	if x != nil {
		return x.Notes
	}
	return nil
}

func (x *AccountBudget_PendingAccountBudgetProposal) GetCreationDateTime() *wrapperspb.StringValue {
	if x != nil {
		return x.CreationDateTime
	}
	return nil
}

func (m *AccountBudget_PendingAccountBudgetProposal) GetEndTime() isAccountBudget_PendingAccountBudgetProposal_EndTime {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (x *AccountBudget_PendingAccountBudgetProposal) GetEndDateTime() *wrapperspb.StringValue {
	if x, ok := x.GetEndTime().(*AccountBudget_PendingAccountBudgetProposal_EndDateTime); ok {
		return x.EndDateTime
	}
	return nil
}

func (x *AccountBudget_PendingAccountBudgetProposal) GetEndTimeType() enums.TimeTypeEnum_TimeType {
	if x, ok := x.GetEndTime().(*AccountBudget_PendingAccountBudgetProposal_EndTimeType); ok {
		return x.EndTimeType
	}
	return enums.TimeTypeEnum_UNSPECIFIED
}

func (m *AccountBudget_PendingAccountBudgetProposal) GetSpendingLimit() isAccountBudget_PendingAccountBudgetProposal_SpendingLimit {
	if m != nil {
		return m.SpendingLimit
	}
	return nil
}

func (x *AccountBudget_PendingAccountBudgetProposal) GetSpendingLimitMicros() *wrapperspb.Int64Value {
	if x, ok := x.GetSpendingLimit().(*AccountBudget_PendingAccountBudgetProposal_SpendingLimitMicros); ok {
		return x.SpendingLimitMicros
	}
	return nil
}

func (x *AccountBudget_PendingAccountBudgetProposal) GetSpendingLimitType() enums.SpendingLimitTypeEnum_SpendingLimitType {
	if x, ok := x.GetSpendingLimit().(*AccountBudget_PendingAccountBudgetProposal_SpendingLimitType); ok {
		return x.SpendingLimitType
	}
	return enums.SpendingLimitTypeEnum_UNSPECIFIED
}

type isAccountBudget_PendingAccountBudgetProposal_EndTime interface {
	isAccountBudget_PendingAccountBudgetProposal_EndTime()
}

type AccountBudget_PendingAccountBudgetProposal_EndDateTime struct {
	// Output only. The end time in yyyy-MM-dd HH:mm:ss format.
	EndDateTime *wrapperspb.StringValue `protobuf:"bytes,5,opt,name=end_date_time,json=endDateTime,proto3,oneof"`
}

type AccountBudget_PendingAccountBudgetProposal_EndTimeType struct {
	// Output only. The end time as a well-defined type, e.g. FOREVER.
	EndTimeType enums.TimeTypeEnum_TimeType `protobuf:"varint,6,opt,name=end_time_type,json=endTimeType,proto3,enum=google.ads.googleads.v2.enums.TimeTypeEnum_TimeType,oneof"`
}

func (*AccountBudget_PendingAccountBudgetProposal_EndDateTime) isAccountBudget_PendingAccountBudgetProposal_EndTime() {
}

func (*AccountBudget_PendingAccountBudgetProposal_EndTimeType) isAccountBudget_PendingAccountBudgetProposal_EndTime() {
}

type isAccountBudget_PendingAccountBudgetProposal_SpendingLimit interface {
	isAccountBudget_PendingAccountBudgetProposal_SpendingLimit()
}

type AccountBudget_PendingAccountBudgetProposal_SpendingLimitMicros struct {
	// Output only. The spending limit in micros.  One million is equivalent to
	// one unit.
	SpendingLimitMicros *wrapperspb.Int64Value `protobuf:"bytes,7,opt,name=spending_limit_micros,json=spendingLimitMicros,proto3,oneof"`
}

type AccountBudget_PendingAccountBudgetProposal_SpendingLimitType struct {
	// Output only. The spending limit as a well-defined type, e.g. INFINITE.
	SpendingLimitType enums.SpendingLimitTypeEnum_SpendingLimitType `protobuf:"varint,8,opt,name=spending_limit_type,json=spendingLimitType,proto3,enum=google.ads.googleads.v2.enums.SpendingLimitTypeEnum_SpendingLimitType,oneof"`
}

func (*AccountBudget_PendingAccountBudgetProposal_SpendingLimitMicros) isAccountBudget_PendingAccountBudgetProposal_SpendingLimit() {
}

func (*AccountBudget_PendingAccountBudgetProposal_SpendingLimitType) isAccountBudget_PendingAccountBudgetProposal_SpendingLimit() {
}

var File_google_ads_googleads_v2_resources_account_budget_proto protoreflect.FileDescriptor

var file_google_ads_googleads_v2_resources_account_budget_proto_rawDesc = []byte{
	0x0a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x62, 0x75, 0x64, 0x67,
	0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0x40, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73,
	0x61, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x39, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76,
	0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x73, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72,
	0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb8, 0x1b, 0x0a, 0x0d, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x12, 0x53, 0x0a, 0x0d,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x75, 0x64,
	0x67, 0x65, 0x74, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x30, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x02, 0x69, 0x64, 0x12, 0x70, 0x0a, 0x0d, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x73,
	0x65, 0x74, 0x75, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x2d, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x27,
	0x0a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x69, 0x6c, 0x6c, 0x69,
	0x6e, 0x67, 0x53, 0x65, 0x74, 0x75, 0x70, 0x52, 0x0c, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67,
	0x53, 0x65, 0x74, 0x75, 0x70, 0x12, 0x67, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e,
	0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x75, 0x64,
	0x67, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x35,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5a, 0x0a, 0x18, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x65,
	0x64, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x70, 0x72, 0x6f, 0x70,
	0x6f, 0x73, 0x65, 0x64, 0x53, 0x74, 0x61, 0x72, 0x74, 0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x5a, 0x0a, 0x18, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x5f, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64,
	0x53, 0x74, 0x61, 0x72, 0x74, 0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5a, 0x0a,
	0x18, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x16, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x52, 0x0a, 0x14, 0x61, 0x6d, 0x6f,
	0x75, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f,
	0x73, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x61, 0x6d, 0x6f, 0x75, 0x6e,
	0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x64, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x55, 0x0a,
	0x15, 0x70, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f,
	0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x13, 0x70, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x4e, 0x75,
	0x6d, 0x62, 0x65, 0x72, 0x12, 0x37, 0x0a, 0x05, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x18, 0x15, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x12, 0x7d, 0x0a,
	0x10, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61,
	0x6c, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x2e, 0x50, 0x65, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x50, 0x72,
	0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x70, 0x65, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x12, 0x58, 0x0a, 0x16,
	0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48,
	0x00, 0x52, 0x13, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x45, 0x6e, 0x64, 0x44, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x70, 0x0a, 0x16, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73,
	0x65, 0x64, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x45,
	0x6e, 0x75, 0x6d, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x48, 0x00, 0x52, 0x13, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x45, 0x6e, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x58, 0x0a, 0x16, 0x61, 0x70, 0x70, 0x72,
	0x6f, 0x76, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x13, 0x61,
	0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x45, 0x6e, 0x64, 0x44, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x70, 0x0a, 0x16, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x5f, 0x65,
	0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75,
	0x6d, 0x73, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52,
	0x13, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x45, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x67, 0x0a, 0x1e, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x65, 0x64,
	0x5f, 0x73, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f,
	0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49,
	0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x02,
	0x52, 0x1b, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x53, 0x70, 0x65, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x8e, 0x01,
	0x0a, 0x1c, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x5f, 0x73, 0x70, 0x65, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0d,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x65,
	0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x53, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6d,
	0x69, 0x74, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x53, 0x70, 0x65, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x48, 0x02, 0x52, 0x19, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x53, 0x70, 0x65,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x67,
	0x0a, 0x1e, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x5f, 0x73, 0x70, 0x65, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x03, 0x52, 0x1b, 0x61, 0x70, 0x70, 0x72,
	0x6f, 0x76, 0x65, 0x64, 0x53, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6d, 0x69,
	0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x8e, 0x01, 0x0a, 0x1c, 0x61, 0x70, 0x70, 0x72,
	0x6f, 0x76, 0x65, 0x64, 0x5f, 0x73, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x69,
	0x6d, 0x69, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x46,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x53,
	0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x53, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6d,
	0x69, 0x74, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x03, 0x52, 0x19, 0x61,
	0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x53, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4c,
	0x69, 0x6d, 0x69, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x67, 0x0a, 0x1e, 0x61, 0x64, 0x6a, 0x75,
	0x73, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x69,
	0x6d, 0x69, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x48, 0x04, 0x52, 0x1b, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x65, 0x64, 0x53, 0x70,
	0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f,
	0x73, 0x12, 0x8e, 0x01, 0x0a, 0x1c, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x73,
	0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x53, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x53,
	0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x04, 0x52, 0x19, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x65,
	0x64, 0x53, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x1a, 0xb2, 0x08, 0x0a, 0x1c, 0x50, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x6f,
	0x73, 0x61, 0x6c, 0x12, 0x8c, 0x01, 0x0a, 0x17, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f,
	0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x42, 0x36, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x75, 0x64,
	0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x15, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73,
	0x61, 0x6c, 0x12, 0x80, 0x01, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c,
	0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x54, 0x79,
	0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61,
	0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x35, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x0f,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x72, 0x74, 0x44,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x55, 0x0a, 0x15, 0x70, 0x75, 0x72, 0x63, 0x68,
	0x61, 0x73, 0x65, 0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x70, 0x75, 0x72, 0x63, 0x68,
	0x61, 0x73, 0x65, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x37,
	0x0a, 0x05, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x05, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x12, 0x4f, 0x0a, 0x12, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x0d, 0x65, 0x6e, 0x64, 0x5f,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x48, 0x00, 0x52, 0x0b, 0x65, 0x6e, 0x64, 0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x5f, 0x0a, 0x0d, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0b, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x56, 0x0a, 0x15, 0x73, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x6c,
	0x69, 0x6d, 0x69, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x13, 0x73, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4c,
	0x69, 0x6d, 0x69, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x7d, 0x0a, 0x13, 0x73, 0x70,
	0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x53, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x4c, 0x69, 0x6d, 0x69, 0x74, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x53, 0x70,
	0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x54, 0x79, 0x70, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x11, 0x73, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x4c, 0x69, 0x6d, 0x69, 0x74, 0x54, 0x79, 0x70, 0x65, 0x42, 0x0a, 0x0a, 0x08, 0x65, 0x6e, 0x64,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x42, 0x10, 0x0a, 0x0e, 0x73, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x3a, 0x61, 0xea, 0x41, 0x5e, 0x0a, 0x26, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x75,
	0x64, 0x67, 0x65, 0x74, 0x12, 0x34, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f,
	0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x7d, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x7d, 0x42, 0x13, 0x0a, 0x11, 0x70, 0x72,
	0x6f, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x42,
	0x13, 0x0a, 0x11, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x64, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x42, 0x19, 0x0a, 0x17, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x65, 0x64,
	0x5f, 0x73, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x42,
	0x19, 0x0a, 0x17, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x5f, 0x73, 0x70, 0x65, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x42, 0x19, 0x0a, 0x17, 0x61, 0x64,
	0x6a, 0x75, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x42, 0xff, 0x01, 0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x42,
	0x12, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f,
	0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x64, 0x73,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x3b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0xa2, 0x02, 0x03, 0x47, 0x41, 0x41, 0xaa, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x41, 0x64, 0x73, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x2e, 0x56,
	0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0xca, 0x02, 0x21, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x64, 0x73, 0x5c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41,
	0x64, 0x73, 0x5c, 0x56, 0x32, 0x5c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0xea,
	0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x56, 0x32, 0x3a, 0x3a, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ads_googleads_v2_resources_account_budget_proto_rawDescOnce sync.Once
	file_google_ads_googleads_v2_resources_account_budget_proto_rawDescData = file_google_ads_googleads_v2_resources_account_budget_proto_rawDesc
)

func file_google_ads_googleads_v2_resources_account_budget_proto_rawDescGZIP() []byte {
	file_google_ads_googleads_v2_resources_account_budget_proto_rawDescOnce.Do(func() {
		file_google_ads_googleads_v2_resources_account_budget_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ads_googleads_v2_resources_account_budget_proto_rawDescData)
	})
	return file_google_ads_googleads_v2_resources_account_budget_proto_rawDescData
}

var file_google_ads_googleads_v2_resources_account_budget_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_ads_googleads_v2_resources_account_budget_proto_goTypes = []interface{}{
	(*AccountBudget)(nil),                                              // 0: google.ads.googleads.v2.resources.AccountBudget
	(*AccountBudget_PendingAccountBudgetProposal)(nil),                 // 1: google.ads.googleads.v2.resources.AccountBudget.PendingAccountBudgetProposal
	(*wrapperspb.Int64Value)(nil),                                      // 2: google.protobuf.Int64Value
	(*wrapperspb.StringValue)(nil),                                     // 3: google.protobuf.StringValue
	(enums.AccountBudgetStatusEnum_AccountBudgetStatus)(0),             // 4: google.ads.googleads.v2.enums.AccountBudgetStatusEnum.AccountBudgetStatus
	(enums.TimeTypeEnum_TimeType)(0),                                   // 5: google.ads.googleads.v2.enums.TimeTypeEnum.TimeType
	(enums.SpendingLimitTypeEnum_SpendingLimitType)(0),                 // 6: google.ads.googleads.v2.enums.SpendingLimitTypeEnum.SpendingLimitType
	(enums.AccountBudgetProposalTypeEnum_AccountBudgetProposalType)(0), // 7: google.ads.googleads.v2.enums.AccountBudgetProposalTypeEnum.AccountBudgetProposalType
}
var file_google_ads_googleads_v2_resources_account_budget_proto_depIdxs = []int32{
	2,  // 0: google.ads.googleads.v2.resources.AccountBudget.id:type_name -> google.protobuf.Int64Value
	3,  // 1: google.ads.googleads.v2.resources.AccountBudget.billing_setup:type_name -> google.protobuf.StringValue
	4,  // 2: google.ads.googleads.v2.resources.AccountBudget.status:type_name -> google.ads.googleads.v2.enums.AccountBudgetStatusEnum.AccountBudgetStatus
	3,  // 3: google.ads.googleads.v2.resources.AccountBudget.name:type_name -> google.protobuf.StringValue
	3,  // 4: google.ads.googleads.v2.resources.AccountBudget.proposed_start_date_time:type_name -> google.protobuf.StringValue
	3,  // 5: google.ads.googleads.v2.resources.AccountBudget.approved_start_date_time:type_name -> google.protobuf.StringValue
	2,  // 6: google.ads.googleads.v2.resources.AccountBudget.total_adjustments_micros:type_name -> google.protobuf.Int64Value
	2,  // 7: google.ads.googleads.v2.resources.AccountBudget.amount_served_micros:type_name -> google.protobuf.Int64Value
	3,  // 8: google.ads.googleads.v2.resources.AccountBudget.purchase_order_number:type_name -> google.protobuf.StringValue
	3,  // 9: google.ads.googleads.v2.resources.AccountBudget.notes:type_name -> google.protobuf.StringValue
	1,  // 10: google.ads.googleads.v2.resources.AccountBudget.pending_proposal:type_name -> google.ads.googleads.v2.resources.AccountBudget.PendingAccountBudgetProposal
	3,  // 11: google.ads.googleads.v2.resources.AccountBudget.proposed_end_date_time:type_name -> google.protobuf.StringValue
	5,  // 12: google.ads.googleads.v2.resources.AccountBudget.proposed_end_time_type:type_name -> google.ads.googleads.v2.enums.TimeTypeEnum.TimeType
	3,  // 13: google.ads.googleads.v2.resources.AccountBudget.approved_end_date_time:type_name -> google.protobuf.StringValue
	5,  // 14: google.ads.googleads.v2.resources.AccountBudget.approved_end_time_type:type_name -> google.ads.googleads.v2.enums.TimeTypeEnum.TimeType
	2,  // 15: google.ads.googleads.v2.resources.AccountBudget.proposed_spending_limit_micros:type_name -> google.protobuf.Int64Value
	6,  // 16: google.ads.googleads.v2.resources.AccountBudget.proposed_spending_limit_type:type_name -> google.ads.googleads.v2.enums.SpendingLimitTypeEnum.SpendingLimitType
	2,  // 17: google.ads.googleads.v2.resources.AccountBudget.approved_spending_limit_micros:type_name -> google.protobuf.Int64Value
	6,  // 18: google.ads.googleads.v2.resources.AccountBudget.approved_spending_limit_type:type_name -> google.ads.googleads.v2.enums.SpendingLimitTypeEnum.SpendingLimitType
	2,  // 19: google.ads.googleads.v2.resources.AccountBudget.adjusted_spending_limit_micros:type_name -> google.protobuf.Int64Value
	6,  // 20: google.ads.googleads.v2.resources.AccountBudget.adjusted_spending_limit_type:type_name -> google.ads.googleads.v2.enums.SpendingLimitTypeEnum.SpendingLimitType
	3,  // 21: google.ads.googleads.v2.resources.AccountBudget.PendingAccountBudgetProposal.account_budget_proposal:type_name -> google.protobuf.StringValue
	7,  // 22: google.ads.googleads.v2.resources.AccountBudget.PendingAccountBudgetProposal.proposal_type:type_name -> google.ads.googleads.v2.enums.AccountBudgetProposalTypeEnum.AccountBudgetProposalType
	3,  // 23: google.ads.googleads.v2.resources.AccountBudget.PendingAccountBudgetProposal.name:type_name -> google.protobuf.StringValue
	3,  // 24: google.ads.googleads.v2.resources.AccountBudget.PendingAccountBudgetProposal.start_date_time:type_name -> google.protobuf.StringValue
	3,  // 25: google.ads.googleads.v2.resources.AccountBudget.PendingAccountBudgetProposal.purchase_order_number:type_name -> google.protobuf.StringValue
	3,  // 26: google.ads.googleads.v2.resources.AccountBudget.PendingAccountBudgetProposal.notes:type_name -> google.protobuf.StringValue
	3,  // 27: google.ads.googleads.v2.resources.AccountBudget.PendingAccountBudgetProposal.creation_date_time:type_name -> google.protobuf.StringValue
	3,  // 28: google.ads.googleads.v2.resources.AccountBudget.PendingAccountBudgetProposal.end_date_time:type_name -> google.protobuf.StringValue
	5,  // 29: google.ads.googleads.v2.resources.AccountBudget.PendingAccountBudgetProposal.end_time_type:type_name -> google.ads.googleads.v2.enums.TimeTypeEnum.TimeType
	2,  // 30: google.ads.googleads.v2.resources.AccountBudget.PendingAccountBudgetProposal.spending_limit_micros:type_name -> google.protobuf.Int64Value
	6,  // 31: google.ads.googleads.v2.resources.AccountBudget.PendingAccountBudgetProposal.spending_limit_type:type_name -> google.ads.googleads.v2.enums.SpendingLimitTypeEnum.SpendingLimitType
	32, // [32:32] is the sub-list for method output_type
	32, // [32:32] is the sub-list for method input_type
	32, // [32:32] is the sub-list for extension type_name
	32, // [32:32] is the sub-list for extension extendee
	0,  // [0:32] is the sub-list for field type_name
}

func init() { file_google_ads_googleads_v2_resources_account_budget_proto_init() }
func file_google_ads_googleads_v2_resources_account_budget_proto_init() {
	if File_google_ads_googleads_v2_resources_account_budget_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_ads_googleads_v2_resources_account_budget_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccountBudget); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v2_resources_account_budget_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccountBudget_PendingAccountBudgetProposal); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_ads_googleads_v2_resources_account_budget_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*AccountBudget_ProposedEndDateTime)(nil),
		(*AccountBudget_ProposedEndTimeType)(nil),
		(*AccountBudget_ApprovedEndDateTime)(nil),
		(*AccountBudget_ApprovedEndTimeType)(nil),
		(*AccountBudget_ProposedSpendingLimitMicros)(nil),
		(*AccountBudget_ProposedSpendingLimitType)(nil),
		(*AccountBudget_ApprovedSpendingLimitMicros)(nil),
		(*AccountBudget_ApprovedSpendingLimitType)(nil),
		(*AccountBudget_AdjustedSpendingLimitMicros)(nil),
		(*AccountBudget_AdjustedSpendingLimitType)(nil),
	}
	file_google_ads_googleads_v2_resources_account_budget_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*AccountBudget_PendingAccountBudgetProposal_EndDateTime)(nil),
		(*AccountBudget_PendingAccountBudgetProposal_EndTimeType)(nil),
		(*AccountBudget_PendingAccountBudgetProposal_SpendingLimitMicros)(nil),
		(*AccountBudget_PendingAccountBudgetProposal_SpendingLimitType)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ads_googleads_v2_resources_account_budget_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_ads_googleads_v2_resources_account_budget_proto_goTypes,
		DependencyIndexes: file_google_ads_googleads_v2_resources_account_budget_proto_depIdxs,
		MessageInfos:      file_google_ads_googleads_v2_resources_account_budget_proto_msgTypes,
	}.Build()
	File_google_ads_googleads_v2_resources_account_budget_proto = out.File
	file_google_ads_googleads_v2_resources_account_budget_proto_rawDesc = nil
	file_google_ads_googleads_v2_resources_account_budget_proto_goTypes = nil
	file_google_ads_googleads_v2_resources_account_budget_proto_depIdxs = nil
}
