// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package datastore provides access to the Cloud Datastore API.
//
// This package is DEPRECATED. Use package cloud.google.com/go/datastore instead.
//
// For product documentation, see: https://cloud.google.com/datastore/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/datastore/v1beta3"
//	...
//	ctx := context.Background()
//	datastoreService, err := datastore.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	datastoreService, err := datastore.NewService(ctx, option.WithScopes(datastore.DatastoreScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	datastoreService, err := datastore.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	datastoreService, err := datastore.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package datastore // import "google.golang.org/api/datastore/v1beta3"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "datastore:v1beta3"
const apiName = "datastore"
const apiVersion = "v1beta3"
const basePath = "https://datastore.googleapis.com/"
const basePathTemplate = "https://datastore.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://datastore.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"

	// View and manage your Google Cloud Datastore data
	DatastoreScope = "https://www.googleapis.com/auth/datastore"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
		"https://www.googleapis.com/auth/datastore",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	return rs
}

type ProjectsService struct {
	s *Service
}

// Aggregation: Defines an aggregation that produces a single result.
type Aggregation struct {
	// Alias: Optional. Optional name of the property to store the result of the
	// aggregation. If not provided, Datastore will pick a default name following
	// the format `property_`. For example: ``` AGGREGATE COUNT_UP_TO(1) AS
	// count_up_to_1, COUNT_UP_TO(2), COUNT_UP_TO(3) AS count_up_to_3, COUNT(*)
	// OVER ( ... ); ``` becomes: ``` AGGREGATE COUNT_UP_TO(1) AS count_up_to_1,
	// COUNT_UP_TO(2) AS property_1, COUNT_UP_TO(3) AS count_up_to_3, COUNT(*) AS
	// property_2 OVER ( ... ); ``` Requires: * Must be unique across all
	// aggregation aliases. * Conform to entity property name limitations.
	Alias string `json:"alias,omitempty"`
	// Avg: Average aggregator.
	Avg *Avg `json:"avg,omitempty"`
	// Count: Count aggregator.
	Count *Count `json:"count,omitempty"`
	// Sum: Sum aggregator.
	Sum *Sum `json:"sum,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Alias") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Alias") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Aggregation) MarshalJSON() ([]byte, error) {
	type NoMethod Aggregation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AggregationQuery: Datastore query for running an aggregation over a Query.
type AggregationQuery struct {
	// Aggregations: Optional. Series of aggregations to apply over the results of
	// the `nested_query`. Requires: * A minimum of one and maximum of five
	// aggregations per query.
	Aggregations []*Aggregation `json:"aggregations,omitempty"`
	// NestedQuery: Nested query for aggregation
	NestedQuery *Query `json:"nestedQuery,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Aggregations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Aggregations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AggregationQuery) MarshalJSON() ([]byte, error) {
	type NoMethod AggregationQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AggregationResult: The result of a single bucket from a Datastore
// aggregation query. The keys of `aggregate_properties` are the same for all
// results in an aggregation query, unlike entity queries which can have
// different fields present for each result.
type AggregationResult struct {
	// AggregateProperties: The result of the aggregation functions, ex: `COUNT(*)
	// AS total_entities`. The key is the alias assigned to the aggregation
	// function on input and the size of this map equals the number of aggregation
	// functions in the query.
	AggregateProperties map[string]Value `json:"aggregateProperties,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AggregateProperties") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AggregateProperties") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AggregationResult) MarshalJSON() ([]byte, error) {
	type NoMethod AggregationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AggregationResultBatch: A batch of aggregation results produced by an
// aggregation query.
type AggregationResultBatch struct {
	// AggregationResults: The aggregation results for this batch.
	AggregationResults []*AggregationResult `json:"aggregationResults,omitempty"`
	// MoreResults: The state of the query after the current batch. Only COUNT(*)
	// aggregations are supported in the initial launch. Therefore, expected result
	// type is limited to `NO_MORE_RESULTS`.
	//
	// Possible values:
	//   "MORE_RESULTS_TYPE_UNSPECIFIED" - Unspecified. This value is never used.
	//   "NOT_FINISHED" - There may be additional batches to fetch from this query.
	//   "MORE_RESULTS_AFTER_LIMIT" - The query is finished, but there may be more
	// results after the limit.
	//   "MORE_RESULTS_AFTER_CURSOR" - The query is finished, but there may be more
	// results after the end cursor.
	//   "NO_MORE_RESULTS" - The query is finished, and there are no more results.
	MoreResults string `json:"moreResults,omitempty"`
	// ReadTime: Read timestamp this batch was returned from. In a single
	// transaction, subsequent query result batches for the same query can have a
	// greater timestamp. Each batch's read timestamp is valid for all preceding
	// batches.
	ReadTime string `json:"readTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AggregationResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AggregationResults") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AggregationResultBatch) MarshalJSON() ([]byte, error) {
	type NoMethod AggregationResultBatch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AllocateIdsRequest: The request for Datastore.AllocateIds.
type AllocateIdsRequest struct {
	// Keys: Required. A list of keys with incomplete key paths for which to
	// allocate IDs. No key may be reserved/read-only.
	Keys []*Key `json:"keys,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Keys") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Keys") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AllocateIdsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AllocateIdsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AllocateIdsResponse: The response for Datastore.AllocateIds.
type AllocateIdsResponse struct {
	// Keys: The keys specified in the request (in the same order), each with its
	// key path completed with a newly allocated ID.
	Keys []*Key `json:"keys,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Keys") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Keys") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AllocateIdsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AllocateIdsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ArrayValue: An array value.
type ArrayValue struct {
	// Values: Values in the array. The order of values in an array is preserved as
	// long as all values have identical settings for 'exclude_from_indexes'.
	Values []*Value `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ArrayValue) MarshalJSON() ([]byte, error) {
	type NoMethod ArrayValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Avg: Average of the values of the requested property. * Only numeric values
// will be aggregated. All non-numeric values including `NULL` are skipped. *
// If the aggregated values contain `NaN`, returns `NaN`. Infinity math follows
// IEEE-754 standards. * If the aggregated value set is empty, returns `NULL`.
// * Always returns the result as a double.
type Avg struct {
	// Property: The property to aggregate on.
	Property *PropertyReference `json:"property,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Property") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Property") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Avg) MarshalJSON() ([]byte, error) {
	type NoMethod Avg
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BeginTransactionRequest: The request for Datastore.BeginTransaction.
type BeginTransactionRequest struct {
	// TransactionOptions: Options for a new transaction.
	TransactionOptions *TransactionOptions `json:"transactionOptions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TransactionOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TransactionOptions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BeginTransactionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BeginTransactionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BeginTransactionResponse: The response for Datastore.BeginTransaction.
type BeginTransactionResponse struct {
	// Transaction: The transaction identifier (always present).
	Transaction string `json:"transaction,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Transaction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Transaction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BeginTransactionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BeginTransactionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CommitRequest: The request for Datastore.Commit.
type CommitRequest struct {
	// Mode: The type of commit to perform. Defaults to `TRANSACTIONAL`.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Unspecified. This value must not be used.
	//   "TRANSACTIONAL" - Transactional: The mutations are either all applied, or
	// none are applied. Learn about transactions
	// [here](https://cloud.google.com/datastore/docs/concepts/transactions).
	//   "NON_TRANSACTIONAL" - Non-transactional: The mutations may not apply as
	// all or none.
	Mode string `json:"mode,omitempty"`
	// Mutations: The mutations to perform. When mode is `TRANSACTIONAL`, mutations
	// affecting a single entity are applied in order. The following sequences of
	// mutations affecting a single entity are not permitted in a single `Commit`
	// request: - `insert` followed by `insert` - `update` followed by `insert` -
	// `upsert` followed by `insert` - `delete` followed by `update` When mode is
	// `NON_TRANSACTIONAL`, no two mutations may affect a single entity.
	Mutations []*Mutation `json:"mutations,omitempty"`
	// Transaction: The identifier of the transaction associated with the commit. A
	// transaction identifier is returned by a call to Datastore.BeginTransaction.
	Transaction string `json:"transaction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Mode") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Mode") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CommitRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CommitRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CommitResponse: The response for Datastore.Commit.
type CommitResponse struct {
	// CommitTime: The transaction commit timestamp. Not set for non-transactional
	// commits.
	CommitTime string `json:"commitTime,omitempty"`
	// IndexUpdates: The number of index entries updated during the commit, or zero
	// if none were updated.
	IndexUpdates int64 `json:"indexUpdates,omitempty"`
	// MutationResults: The result of performing the mutations. The i-th mutation
	// result corresponds to the i-th mutation in the request.
	MutationResults []*MutationResult `json:"mutationResults,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CommitTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommitTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CommitResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CommitResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CompositeFilter: A filter that merges multiple other filters using the given
// operator.
type CompositeFilter struct {
	// Filters: The list of filters to combine. Requires: * At least one filter is
	// present.
	Filters []*Filter `json:"filters,omitempty"`
	// Op: The operator for combining multiple filters.
	//
	// Possible values:
	//   "OPERATOR_UNSPECIFIED" - Unspecified. This value must not be used.
	//   "AND" - The results are required to satisfy each of the combined filters.
	//   "OR" - Documents are required to satisfy at least one of the combined
	// filters.
	Op string `json:"op,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filters") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filters") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CompositeFilter) MarshalJSON() ([]byte, error) {
	type NoMethod CompositeFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Count: Count of entities that match the query. The `COUNT(*)` aggregation
// function operates on the entire entity so it does not require a field
// reference.
type Count struct {
	// UpTo: Optional. Optional constraint on the maximum number of entities to
	// count. This provides a way to set an upper bound on the number of entities
	// to scan, limiting latency, and cost. Unspecified is interpreted as no bound.
	// If a zero value is provided, a count result of zero should always be
	// expected. High-Level Example: ``` AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT
	// * FROM k ); ``` Requires: * Must be non-negative when present.
	UpTo int64 `json:"upTo,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "UpTo") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UpTo") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Count) MarshalJSON() ([]byte, error) {
	type NoMethod Count
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Entity: A Datastore data object. Must not exceed 1 MiB - 4 bytes.
type Entity struct {
	// Key: The entity's key. An entity must have a key, unless otherwise
	// documented (for example, an entity in `Value.entity_value` may have no key).
	// An entity's kind is its key path's last element's kind, or null if it has no
	// key.
	Key *Key `json:"key,omitempty"`
	// Properties: The entity's properties. The map's keys are property names. A
	// property name matching regex `__.*__` is reserved. A reserved property name
	// is forbidden in certain documented contexts. The map keys, represented as
	// UTF-8, must not exceed 1,500 bytes and cannot be empty.
	Properties map[string]Value `json:"properties,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Entity) MarshalJSON() ([]byte, error) {
	type NoMethod Entity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EntityResult: The result of fetching an entity from Datastore.
type EntityResult struct {
	// CreateTime: The time at which the entity was created. This field is set for
	// `FULL` entity results. If this entity is missing, this field will not be
	// set.
	CreateTime string `json:"createTime,omitempty"`
	// Cursor: A cursor that points to the position after the result entity. Set
	// only when the `EntityResult` is part of a `QueryResultBatch` message.
	Cursor string `json:"cursor,omitempty"`
	// Entity: The resulting entity.
	Entity *Entity `json:"entity,omitempty"`
	// UpdateTime: The time at which the entity was last changed. This field is set
	// for `FULL` entity results. If this entity is missing, this field will not be
	// set.
	UpdateTime string `json:"updateTime,omitempty"`
	// Version: The version of the entity, a strictly positive number that
	// monotonically increases with changes to the entity. This field is set for
	// `FULL` entity results. For missing entities in `LookupResponse`, this is the
	// version of the snapshot that was used to look up the entity, and it is
	// always set except for eventually consistent reads.
	Version int64 `json:"version,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EntityResult) MarshalJSON() ([]byte, error) {
	type NoMethod EntityResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExecutionStats: Execution statistics for the query.
type ExecutionStats struct {
	// DebugStats: Debugging statistics from the execution of the query. Note that
	// the debugging stats are subject to change as Firestore evolves. It could
	// include: { "indexes_entries_scanned": "1000", "documents_scanned": "20",
	// "billing_details" : { "documents_billable": "20", "index_entries_billable":
	// "1000", "min_query_cost": "0" } }
	DebugStats googleapi.RawMessage `json:"debugStats,omitempty"`
	// ExecutionDuration: Total time to execute the query in the backend.
	ExecutionDuration string `json:"executionDuration,omitempty"`
	// ReadOperations: Total billable read operations.
	ReadOperations int64 `json:"readOperations,omitempty,string"`
	// ResultsReturned: Total number of results returned, including documents,
	// projections, aggregation results, keys.
	ResultsReturned int64 `json:"resultsReturned,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "DebugStats") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DebugStats") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExecutionStats) MarshalJSON() ([]byte, error) {
	type NoMethod ExecutionStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExplainMetrics: Explain metrics for the query.
type ExplainMetrics struct {
	// ExecutionStats: Aggregated stats from the execution of the query. Only
	// present when ExplainOptions.analyze is set to true.
	ExecutionStats *ExecutionStats `json:"executionStats,omitempty"`
	// PlanSummary: Planning phase information for the query.
	PlanSummary *PlanSummary `json:"planSummary,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExecutionStats") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExecutionStats") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExplainMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod ExplainMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExplainOptions: Explain options for the query.
type ExplainOptions struct {
	// Analyze: Optional. Whether to execute this query. When false (the default),
	// the query will be planned, returning only metrics from the planning stages.
	// When true, the query will be planned and executed, returning the full query
	// results along with both planning and execution stage metrics.
	Analyze bool `json:"analyze,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Analyze") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Analyze") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExplainOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ExplainOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Filter: A holder for any type of filter.
type Filter struct {
	// CompositeFilter: A composite filter.
	CompositeFilter *CompositeFilter `json:"compositeFilter,omitempty"`
	// PropertyFilter: A filter on a property.
	PropertyFilter *PropertyFilter `json:"propertyFilter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompositeFilter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompositeFilter") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Filter) MarshalJSON() ([]byte, error) {
	type NoMethod Filter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FindNearest: Nearest Neighbors search config. The ordering provided by
// FindNearest supersedes the order_by stage. If multiple documents have the
// same vector distance, the returned document order is not guaranteed to be
// stable between queries.
type FindNearest struct {
	// DistanceMeasure: Required. The Distance Measure to use, required.
	//
	// Possible values:
	//   "DISTANCE_MEASURE_UNSPECIFIED" - Should not be set.
	//   "EUCLIDEAN" - Measures the EUCLIDEAN distance between the vectors. See
	// [Euclidean](https://en.wikipedia.org/wiki/Euclidean_distance) to learn more.
	// The resulting distance decreases the more similar two vectors are.
	//   "COSINE" - COSINE distance compares vectors based on the angle between
	// them, which allows you to measure similarity that isn't based on the vectors
	// magnitude. We recommend using DOT_PRODUCT with unit normalized vectors
	// instead of COSINE distance, which is mathematically equivalent with better
	// performance. See [Cosine
	// Similarity](https://en.wikipedia.org/wiki/Cosine_similarity) to learn more
	// about COSINE similarity and COSINE distance. The resulting COSINE distance
	// decreases the more similar two vectors are.
	//   "DOT_PRODUCT" - Similar to cosine but is affected by the magnitude of the
	// vectors. See [Dot Product](https://en.wikipedia.org/wiki/Dot_product) to
	// learn more. The resulting distance increases the more similar two vectors
	// are.
	DistanceMeasure string `json:"distanceMeasure,omitempty"`
	// DistanceResultProperty: Optional. Optional name of the field to output the
	// result of the vector distance calculation. Must conform to entity property
	// limitations.
	DistanceResultProperty string `json:"distanceResultProperty,omitempty"`
	// DistanceThreshold: Optional. Option to specify a threshold for which no less
	// similar documents will be returned. The behavior of the specified
	// `distance_measure` will affect the meaning of the distance threshold. Since
	// DOT_PRODUCT distances increase when the vectors are more similar, the
	// comparison is inverted. * For EUCLIDEAN, COSINE: WHERE distance <=
	// distance_threshold * For DOT_PRODUCT: WHERE distance >= distance_threshold
	DistanceThreshold float64 `json:"distanceThreshold,omitempty"`
	// Limit: Required. The number of nearest neighbors to return. Must be a
	// positive integer of no more than 100.
	Limit int64 `json:"limit,omitempty"`
	// QueryVector: Required. The query vector that we are searching on. Must be a
	// vector of no more than 2048 dimensions.
	QueryVector *Value `json:"queryVector,omitempty"`
	// VectorProperty: Required. An indexed vector property to search upon. Only
	// documents which contain vectors whose dimensionality match the query_vector
	// can be returned.
	VectorProperty *PropertyReference `json:"vectorProperty,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DistanceMeasure") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DistanceMeasure") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FindNearest) MarshalJSON() ([]byte, error) {
	type NoMethod FindNearest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *FindNearest) UnmarshalJSON(data []byte) error {
	type NoMethod FindNearest
	var s1 struct {
		DistanceThreshold gensupport.JSONFloat64 `json:"distanceThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.DistanceThreshold = float64(s1.DistanceThreshold)
	return nil
}

// GoogleDatastoreAdminV1CommonMetadata: Metadata common to all Datastore Admin
// operations.
type GoogleDatastoreAdminV1CommonMetadata struct {
	// EndTime: The time the operation ended, either successfully or otherwise.
	EndTime string `json:"endTime,omitempty"`
	// Labels: The client-assigned labels which were provided when the operation
	// was created. May also include additional labels.
	Labels map[string]string `json:"labels,omitempty"`
	// OperationType: The type of the operation. Can be used as a filter in
	// ListOperationsRequest.
	//
	// Possible values:
	//   "OPERATION_TYPE_UNSPECIFIED" - Unspecified.
	//   "EXPORT_ENTITIES" - ExportEntities.
	//   "IMPORT_ENTITIES" - ImportEntities.
	//   "CREATE_INDEX" - CreateIndex.
	//   "DELETE_INDEX" - DeleteIndex.
	OperationType string `json:"operationType,omitempty"`
	// StartTime: The time that work began on the operation.
	StartTime string `json:"startTime,omitempty"`
	// State: The current state of the Operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified.
	//   "INITIALIZING" - Request is being prepared for processing.
	//   "PROCESSING" - Request is actively being processed.
	//   "CANCELLING" - Request is in the process of being cancelled after user
	// called google.longrunning.Operations.CancelOperation on the operation.
	//   "FINALIZING" - Request has been processed and is in its finalization
	// stage.
	//   "SUCCESSFUL" - Request has completed successfully.
	//   "FAILED" - Request has finished being processed, but encountered an error.
	//   "CANCELLED" - Request has finished being cancelled after user called
	// google.longrunning.Operations.CancelOperation.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDatastoreAdminV1CommonMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDatastoreAdminV1CommonMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDatastoreAdminV1DatastoreFirestoreMigrationMetadata: Metadata for
// Datastore to Firestore migration operations. The DatastoreFirestoreMigration
// operation is not started by the end-user via an explicit "creation" method.
// This is an intentional deviation from the LRO design pattern. This singleton
// resource can be accessed at:
// "projects/{project_id}/operations/datastore-firestore-migration"
type GoogleDatastoreAdminV1DatastoreFirestoreMigrationMetadata struct {
	// MigrationState: The current state of migration from Cloud Datastore to Cloud
	// Firestore in Datastore mode.
	//
	// Possible values:
	//   "MIGRATION_STATE_UNSPECIFIED" - Unspecified.
	//   "RUNNING" - The migration is running.
	//   "PAUSED" - The migration is paused.
	//   "COMPLETE" - The migration is complete.
	MigrationState string `json:"migrationState,omitempty"`
	// MigrationStep: The current step of migration from Cloud Datastore to Cloud
	// Firestore in Datastore mode.
	//
	// Possible values:
	//   "MIGRATION_STEP_UNSPECIFIED" - Unspecified.
	//   "PREPARE" - Pre-migration: the database is prepared for migration.
	//   "START" - Start of migration.
	//   "APPLY_WRITES_SYNCHRONOUSLY" - Writes are applied synchronously to at
	// least one replica.
	//   "COPY_AND_VERIFY" - Data is copied to Cloud Firestore and then verified to
	// match the data in Cloud Datastore.
	//   "REDIRECT_EVENTUALLY_CONSISTENT_READS" - Eventually-consistent reads are
	// redirected to Cloud Firestore.
	//   "REDIRECT_STRONGLY_CONSISTENT_READS" - Strongly-consistent reads are
	// redirected to Cloud Firestore.
	//   "REDIRECT_WRITES" - Writes are redirected to Cloud Firestore.
	MigrationStep string `json:"migrationStep,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MigrationState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MigrationState") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDatastoreAdminV1DatastoreFirestoreMigrationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDatastoreAdminV1DatastoreFirestoreMigrationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDatastoreAdminV1EntityFilter: Identifies a subset of entities in a
// project. This is specified as combinations of kinds and namespaces (either
// or both of which may be all, as described in the following examples).
// Example usage: Entire project: kinds=[], namespace_ids=[] Kinds Foo and Bar
// in all namespaces: kinds=['Foo', 'Bar'], namespace_ids=[] Kinds Foo and Bar
// only in the default namespace: kinds=['Foo', 'Bar'], namespace_ids=[”]
// Kinds Foo and Bar in both the default and Baz namespaces: kinds=['Foo',
// 'Bar'], namespace_ids=[”, 'Baz'] The entire Baz namespace: kinds=[],
// namespace_ids=['Baz']
type GoogleDatastoreAdminV1EntityFilter struct {
	// Kinds: If empty, then this represents all kinds.
	Kinds []string `json:"kinds,omitempty"`
	// NamespaceIds: An empty list represents all namespaces. This is the preferred
	// usage for projects that don't use namespaces. An empty string element
	// represents the default namespace. This should be used if the project has
	// data in non-default namespaces, but doesn't want to include them. Each
	// namespace in this list must be unique.
	NamespaceIds []string `json:"namespaceIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Kinds") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kinds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDatastoreAdminV1EntityFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDatastoreAdminV1EntityFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDatastoreAdminV1ExportEntitiesMetadata: Metadata for ExportEntities
// operations.
type GoogleDatastoreAdminV1ExportEntitiesMetadata struct {
	// Common: Metadata common to all Datastore Admin operations.
	Common *GoogleDatastoreAdminV1CommonMetadata `json:"common,omitempty"`
	// EntityFilter: Description of which entities are being exported.
	EntityFilter *GoogleDatastoreAdminV1EntityFilter `json:"entityFilter,omitempty"`
	// OutputUrlPrefix: Location for the export metadata and data files. This will
	// be the same value as the
	// google.datastore.admin.v1.ExportEntitiesRequest.output_url_prefix field. The
	// final output location is provided in
	// google.datastore.admin.v1.ExportEntitiesResponse.output_url.
	OutputUrlPrefix string `json:"outputUrlPrefix,omitempty"`
	// ProgressBytes: An estimate of the number of bytes processed.
	ProgressBytes *GoogleDatastoreAdminV1Progress `json:"progressBytes,omitempty"`
	// ProgressEntities: An estimate of the number of entities processed.
	ProgressEntities *GoogleDatastoreAdminV1Progress `json:"progressEntities,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Common") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Common") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDatastoreAdminV1ExportEntitiesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDatastoreAdminV1ExportEntitiesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDatastoreAdminV1ExportEntitiesResponse: The response for
// google.datastore.admin.v1.DatastoreAdmin.ExportEntities.
type GoogleDatastoreAdminV1ExportEntitiesResponse struct {
	// OutputUrl: Location of the output metadata file. This can be used to begin
	// an import into Cloud Datastore (this project or another project). See
	// google.datastore.admin.v1.ImportEntitiesRequest.input_url. Only present if
	// the operation completed successfully.
	OutputUrl string `json:"outputUrl,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OutputUrl") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OutputUrl") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDatastoreAdminV1ExportEntitiesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDatastoreAdminV1ExportEntitiesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDatastoreAdminV1ImportEntitiesMetadata: Metadata for ImportEntities
// operations.
type GoogleDatastoreAdminV1ImportEntitiesMetadata struct {
	// Common: Metadata common to all Datastore Admin operations.
	Common *GoogleDatastoreAdminV1CommonMetadata `json:"common,omitempty"`
	// EntityFilter: Description of which entities are being imported.
	EntityFilter *GoogleDatastoreAdminV1EntityFilter `json:"entityFilter,omitempty"`
	// InputUrl: The location of the import metadata file. This will be the same
	// value as the google.datastore.admin.v1.ExportEntitiesResponse.output_url
	// field.
	InputUrl string `json:"inputUrl,omitempty"`
	// ProgressBytes: An estimate of the number of bytes processed.
	ProgressBytes *GoogleDatastoreAdminV1Progress `json:"progressBytes,omitempty"`
	// ProgressEntities: An estimate of the number of entities processed.
	ProgressEntities *GoogleDatastoreAdminV1Progress `json:"progressEntities,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Common") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Common") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDatastoreAdminV1ImportEntitiesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDatastoreAdminV1ImportEntitiesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDatastoreAdminV1IndexOperationMetadata: Metadata for Index operations.
type GoogleDatastoreAdminV1IndexOperationMetadata struct {
	// Common: Metadata common to all Datastore Admin operations.
	Common *GoogleDatastoreAdminV1CommonMetadata `json:"common,omitempty"`
	// IndexId: The index resource ID that this operation is acting on.
	IndexId string `json:"indexId,omitempty"`
	// ProgressEntities: An estimate of the number of entities processed.
	ProgressEntities *GoogleDatastoreAdminV1Progress `json:"progressEntities,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Common") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Common") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDatastoreAdminV1IndexOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDatastoreAdminV1IndexOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDatastoreAdminV1MigrationProgressEvent: An event signifying the start
// of a new step in a migration from Cloud Datastore to Cloud Firestore in
// Datastore mode
// (https://cloud.google.com/datastore/docs/upgrade-to-firestore).
type GoogleDatastoreAdminV1MigrationProgressEvent struct {
	// PrepareStepDetails: Details for the `PREPARE` step.
	PrepareStepDetails *GoogleDatastoreAdminV1PrepareStepDetails `json:"prepareStepDetails,omitempty"`
	// RedirectWritesStepDetails: Details for the `REDIRECT_WRITES` step.
	RedirectWritesStepDetails *GoogleDatastoreAdminV1RedirectWritesStepDetails `json:"redirectWritesStepDetails,omitempty"`
	// Step: The step that is starting. An event with step set to `START` indicates
	// that the migration has been reverted back to the initial pre-migration
	// state.
	//
	// Possible values:
	//   "MIGRATION_STEP_UNSPECIFIED" - Unspecified.
	//   "PREPARE" - Pre-migration: the database is prepared for migration.
	//   "START" - Start of migration.
	//   "APPLY_WRITES_SYNCHRONOUSLY" - Writes are applied synchronously to at
	// least one replica.
	//   "COPY_AND_VERIFY" - Data is copied to Cloud Firestore and then verified to
	// match the data in Cloud Datastore.
	//   "REDIRECT_EVENTUALLY_CONSISTENT_READS" - Eventually-consistent reads are
	// redirected to Cloud Firestore.
	//   "REDIRECT_STRONGLY_CONSISTENT_READS" - Strongly-consistent reads are
	// redirected to Cloud Firestore.
	//   "REDIRECT_WRITES" - Writes are redirected to Cloud Firestore.
	Step string `json:"step,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PrepareStepDetails") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PrepareStepDetails") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDatastoreAdminV1MigrationProgressEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDatastoreAdminV1MigrationProgressEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDatastoreAdminV1MigrationStateEvent: An event signifying a change in
// state of a migration from Cloud Datastore to Cloud Firestore in Datastore
// mode (https://cloud.google.com/datastore/docs/upgrade-to-firestore).
type GoogleDatastoreAdminV1MigrationStateEvent struct {
	// State: The new state of the migration.
	//
	// Possible values:
	//   "MIGRATION_STATE_UNSPECIFIED" - Unspecified.
	//   "RUNNING" - The migration is running.
	//   "PAUSED" - The migration is paused.
	//   "COMPLETE" - The migration is complete.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "State") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDatastoreAdminV1MigrationStateEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDatastoreAdminV1MigrationStateEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDatastoreAdminV1PrepareStepDetails: Details for the `PREPARE` step.
type GoogleDatastoreAdminV1PrepareStepDetails struct {
	// ConcurrencyMode: The concurrency mode this database will use when it reaches
	// the `REDIRECT_WRITES` step.
	//
	// Possible values:
	//   "CONCURRENCY_MODE_UNSPECIFIED" - Unspecified.
	//   "PESSIMISTIC" - Pessimistic concurrency.
	//   "OPTIMISTIC" - Optimistic concurrency.
	//   "OPTIMISTIC_WITH_ENTITY_GROUPS" - Optimistic concurrency with entity
	// groups.
	ConcurrencyMode string `json:"concurrencyMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConcurrencyMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConcurrencyMode") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDatastoreAdminV1PrepareStepDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDatastoreAdminV1PrepareStepDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDatastoreAdminV1Progress: Measures the progress of a particular
// metric.
type GoogleDatastoreAdminV1Progress struct {
	// WorkCompleted: The amount of work that has been completed. Note that this
	// may be greater than work_estimated.
	WorkCompleted int64 `json:"workCompleted,omitempty,string"`
	// WorkEstimated: An estimate of how much work needs to be performed. May be
	// zero if the work estimate is unavailable.
	WorkEstimated int64 `json:"workEstimated,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "WorkCompleted") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WorkCompleted") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDatastoreAdminV1Progress) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDatastoreAdminV1Progress
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDatastoreAdminV1RedirectWritesStepDetails: Details for the
// `REDIRECT_WRITES` step.
type GoogleDatastoreAdminV1RedirectWritesStepDetails struct {
	// ConcurrencyMode: Ths concurrency mode for this database.
	//
	// Possible values:
	//   "CONCURRENCY_MODE_UNSPECIFIED" - Unspecified.
	//   "PESSIMISTIC" - Pessimistic concurrency.
	//   "OPTIMISTIC" - Optimistic concurrency.
	//   "OPTIMISTIC_WITH_ENTITY_GROUPS" - Optimistic concurrency with entity
	// groups.
	ConcurrencyMode string `json:"concurrencyMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConcurrencyMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConcurrencyMode") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDatastoreAdminV1RedirectWritesStepDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDatastoreAdminV1RedirectWritesStepDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDatastoreAdminV1beta1CommonMetadata: Metadata common to all Datastore
// Admin operations.
type GoogleDatastoreAdminV1beta1CommonMetadata struct {
	// EndTime: The time the operation ended, either successfully or otherwise.
	EndTime string `json:"endTime,omitempty"`
	// Labels: The client-assigned labels which were provided when the operation
	// was created. May also include additional labels.
	Labels map[string]string `json:"labels,omitempty"`
	// OperationType: The type of the operation. Can be used as a filter in
	// ListOperationsRequest.
	//
	// Possible values:
	//   "OPERATION_TYPE_UNSPECIFIED" - Unspecified.
	//   "EXPORT_ENTITIES" - ExportEntities.
	//   "IMPORT_ENTITIES" - ImportEntities.
	OperationType string `json:"operationType,omitempty"`
	// StartTime: The time that work began on the operation.
	StartTime string `json:"startTime,omitempty"`
	// State: The current state of the Operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified.
	//   "INITIALIZING" - Request is being prepared for processing.
	//   "PROCESSING" - Request is actively being processed.
	//   "CANCELLING" - Request is in the process of being cancelled after user
	// called google.longrunning.Operations.CancelOperation on the operation.
	//   "FINALIZING" - Request has been processed and is in its finalization
	// stage.
	//   "SUCCESSFUL" - Request has completed successfully.
	//   "FAILED" - Request has finished being processed, but encountered an error.
	//   "CANCELLED" - Request has finished being cancelled after user called
	// google.longrunning.Operations.CancelOperation.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDatastoreAdminV1beta1CommonMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDatastoreAdminV1beta1CommonMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDatastoreAdminV1beta1EntityFilter: Identifies a subset of entities in
// a project. This is specified as combinations of kinds and namespaces (either
// or both of which may be all, as described in the following examples).
// Example usage: Entire project: kinds=[], namespace_ids=[] Kinds Foo and Bar
// in all namespaces: kinds=['Foo', 'Bar'], namespace_ids=[] Kinds Foo and Bar
// only in the default namespace: kinds=['Foo', 'Bar'], namespace_ids=[”]
// Kinds Foo and Bar in both the default and Baz namespaces: kinds=['Foo',
// 'Bar'], namespace_ids=[”, 'Baz'] The entire Baz namespace: kinds=[],
// namespace_ids=['Baz']
type GoogleDatastoreAdminV1beta1EntityFilter struct {
	// Kinds: If empty, then this represents all kinds.
	Kinds []string `json:"kinds,omitempty"`
	// NamespaceIds: An empty list represents all namespaces. This is the preferred
	// usage for projects that don't use namespaces. An empty string element
	// represents the default namespace. This should be used if the project has
	// data in non-default namespaces, but doesn't want to include them. Each
	// namespace in this list must be unique.
	NamespaceIds []string `json:"namespaceIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Kinds") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kinds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDatastoreAdminV1beta1EntityFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDatastoreAdminV1beta1EntityFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDatastoreAdminV1beta1ExportEntitiesMetadata: Metadata for
// ExportEntities operations.
type GoogleDatastoreAdminV1beta1ExportEntitiesMetadata struct {
	// Common: Metadata common to all Datastore Admin operations.
	Common *GoogleDatastoreAdminV1beta1CommonMetadata `json:"common,omitempty"`
	// EntityFilter: Description of which entities are being exported.
	EntityFilter *GoogleDatastoreAdminV1beta1EntityFilter `json:"entityFilter,omitempty"`
	// OutputUrlPrefix: Location for the export metadata and data files. This will
	// be the same value as the
	// google.datastore.admin.v1beta1.ExportEntitiesRequest.output_url_prefix
	// field. The final output location is provided in
	// google.datastore.admin.v1beta1.ExportEntitiesResponse.output_url.
	OutputUrlPrefix string `json:"outputUrlPrefix,omitempty"`
	// ProgressBytes: An estimate of the number of bytes processed.
	ProgressBytes *GoogleDatastoreAdminV1beta1Progress `json:"progressBytes,omitempty"`
	// ProgressEntities: An estimate of the number of entities processed.
	ProgressEntities *GoogleDatastoreAdminV1beta1Progress `json:"progressEntities,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Common") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Common") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDatastoreAdminV1beta1ExportEntitiesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDatastoreAdminV1beta1ExportEntitiesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDatastoreAdminV1beta1ExportEntitiesResponse: The response for
// google.datastore.admin.v1beta1.DatastoreAdmin.ExportEntities.
type GoogleDatastoreAdminV1beta1ExportEntitiesResponse struct {
	// OutputUrl: Location of the output metadata file. This can be used to begin
	// an import into Cloud Datastore (this project or another project). See
	// google.datastore.admin.v1beta1.ImportEntitiesRequest.input_url. Only present
	// if the operation completed successfully.
	OutputUrl string `json:"outputUrl,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OutputUrl") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OutputUrl") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDatastoreAdminV1beta1ExportEntitiesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDatastoreAdminV1beta1ExportEntitiesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDatastoreAdminV1beta1ImportEntitiesMetadata: Metadata for
// ImportEntities operations.
type GoogleDatastoreAdminV1beta1ImportEntitiesMetadata struct {
	// Common: Metadata common to all Datastore Admin operations.
	Common *GoogleDatastoreAdminV1beta1CommonMetadata `json:"common,omitempty"`
	// EntityFilter: Description of which entities are being imported.
	EntityFilter *GoogleDatastoreAdminV1beta1EntityFilter `json:"entityFilter,omitempty"`
	// InputUrl: The location of the import metadata file. This will be the same
	// value as the
	// google.datastore.admin.v1beta1.ExportEntitiesResponse.output_url field.
	InputUrl string `json:"inputUrl,omitempty"`
	// ProgressBytes: An estimate of the number of bytes processed.
	ProgressBytes *GoogleDatastoreAdminV1beta1Progress `json:"progressBytes,omitempty"`
	// ProgressEntities: An estimate of the number of entities processed.
	ProgressEntities *GoogleDatastoreAdminV1beta1Progress `json:"progressEntities,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Common") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Common") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDatastoreAdminV1beta1ImportEntitiesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDatastoreAdminV1beta1ImportEntitiesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDatastoreAdminV1beta1Progress: Measures the progress of a particular
// metric.
type GoogleDatastoreAdminV1beta1Progress struct {
	// WorkCompleted: The amount of work that has been completed. Note that this
	// may be greater than work_estimated.
	WorkCompleted int64 `json:"workCompleted,omitempty,string"`
	// WorkEstimated: An estimate of how much work needs to be performed. May be
	// zero if the work estimate is unavailable.
	WorkEstimated int64 `json:"workEstimated,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "WorkCompleted") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WorkCompleted") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDatastoreAdminV1beta1Progress) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDatastoreAdminV1beta1Progress
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GqlQuery: A GQL query
// (https://cloud.google.com/datastore/docs/apis/gql/gql_reference).
type GqlQuery struct {
	// AllowLiterals: When false, the query string must not contain any literals
	// and instead must bind all values. For example, `SELECT * FROM Kind WHERE a =
	// 'string literal'` is not allowed, while `SELECT * FROM Kind WHERE a =
	// @value` is.
	AllowLiterals bool `json:"allowLiterals,omitempty"`
	// NamedBindings: For each non-reserved named binding site in the query string,
	// there must be a named parameter with that name, but not necessarily the
	// inverse. Key must match regex `A-Za-z_$*`, must not match regex `__.*__`,
	// and must not be "".
	NamedBindings map[string]GqlQueryParameter `json:"namedBindings,omitempty"`
	// PositionalBindings: Numbered binding site @1 references the first numbered
	// parameter, effectively using 1-based indexing, rather than the usual 0. For
	// each binding site numbered i in `query_string`, there must be an i-th
	// numbered parameter. The inverse must also be true.
	PositionalBindings []*GqlQueryParameter `json:"positionalBindings,omitempty"`
	// QueryString: A string of the format described here
	// (https://cloud.google.com/datastore/docs/apis/gql/gql_reference).
	QueryString string `json:"queryString,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowLiterals") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowLiterals") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GqlQuery) MarshalJSON() ([]byte, error) {
	type NoMethod GqlQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GqlQueryParameter: A binding parameter for a GQL query.
type GqlQueryParameter struct {
	// Cursor: A query cursor. Query cursors are returned in query result batches.
	Cursor string `json:"cursor,omitempty"`
	// Value: A value parameter.
	Value *Value `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cursor") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cursor") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GqlQueryParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GqlQueryParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Key: A unique identifier for an entity. If a key's partition ID or any of
// its path kinds or names are reserved/read-only, the key is
// reserved/read-only. A reserved/read-only key is forbidden in certain
// documented contexts.
type Key struct {
	// PartitionId: Entities are partitioned into subsets, currently identified by
	// a project ID and namespace ID. Queries are scoped to a single partition.
	PartitionId *PartitionId `json:"partitionId,omitempty"`
	// Path: The entity path. An entity path consists of one or more elements
	// composed of a kind and a string or numerical identifier, which identify
	// entities. The first element identifies a _root entity_, the second element
	// identifies a _child_ of the root entity, the third element identifies a
	// child of the second entity, and so forth. The entities identified by all
	// prefixes of the path are called the element's _ancestors_. An entity path is
	// always fully complete: *all* of the entity's ancestors are required to be in
	// the path along with the entity identifier itself. The only exception is that
	// in some documented cases, the identifier in the last path element (for the
	// entity) itself may be omitted. For example, the last path element of the key
	// of `Mutation.insert` may have no identifier. A path can never be empty, and
	// a path can have at most 100 elements.
	Path []*PathElement `json:"path,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PartitionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PartitionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Key) MarshalJSON() ([]byte, error) {
	type NoMethod Key
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// KindExpression: A representation of a kind.
type KindExpression struct {
	// Name: The name of the kind.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s KindExpression) MarshalJSON() ([]byte, error) {
	type NoMethod KindExpression
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LatLng: An object that represents a latitude/longitude pair. This is
// expressed as a pair of doubles to represent degrees latitude and degrees
// longitude. Unless specified otherwise, this object must conform to the WGS84
// standard. Values must be within normalized ranges.
type LatLng struct {
	// Latitude: The latitude in degrees. It must be in the range [-90.0, +90.0].
	Latitude float64 `json:"latitude,omitempty"`
	// Longitude: The longitude in degrees. It must be in the range [-180.0,
	// +180.0].
	Longitude float64 `json:"longitude,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Latitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Latitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LatLng) MarshalJSON() ([]byte, error) {
	type NoMethod LatLng
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *LatLng) UnmarshalJSON(data []byte) error {
	type NoMethod LatLng
	var s1 struct {
		Latitude  gensupport.JSONFloat64 `json:"latitude"`
		Longitude gensupport.JSONFloat64 `json:"longitude"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Latitude = float64(s1.Latitude)
	s.Longitude = float64(s1.Longitude)
	return nil
}

// LookupRequest: The request for Datastore.Lookup.
type LookupRequest struct {
	// Keys: Required. Keys of entities to look up.
	Keys []*Key `json:"keys,omitempty"`
	// PropertyMask: The properties to return. Defaults to returning all
	// properties. If this field is set and an entity has a property not referenced
	// in the mask, it will be absent from LookupResponse.found.entity.properties.
	// The entity's key is always returned.
	PropertyMask *PropertyMask `json:"propertyMask,omitempty"`
	// ReadOptions: The options for this lookup request.
	ReadOptions *ReadOptions `json:"readOptions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Keys") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Keys") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LookupRequest) MarshalJSON() ([]byte, error) {
	type NoMethod LookupRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LookupResponse: The response for Datastore.Lookup.
type LookupResponse struct {
	// Deferred: A list of keys that were not looked up due to resource
	// constraints. The order of results in this field is undefined and has no
	// relation to the order of the keys in the input.
	Deferred []*Key `json:"deferred,omitempty"`
	// Found: Entities found as `ResultType.FULL` entities. The order of results in
	// this field is undefined and has no relation to the order of the keys in the
	// input.
	Found []*EntityResult `json:"found,omitempty"`
	// Missing: Entities not found as `ResultType.KEY_ONLY` entities. The order of
	// results in this field is undefined and has no relation to the order of the
	// keys in the input.
	Missing []*EntityResult `json:"missing,omitempty"`
	// ReadTime: The time at which these entities were read or found missing.
	ReadTime string `json:"readTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Deferred") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Deferred") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LookupResponse) MarshalJSON() ([]byte, error) {
	type NoMethod LookupResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Mutation: A mutation to apply to an entity.
type Mutation struct {
	// BaseVersion: The version of the entity that this mutation is being applied
	// to. If this does not match the current version on the server, the mutation
	// conflicts.
	BaseVersion int64 `json:"baseVersion,omitempty,string"`
	// ConflictResolutionStrategy: The strategy to use when a conflict is detected.
	// Defaults to `SERVER_VALUE`. If this is set, then
	// `conflict_detection_strategy` must also be set.
	//
	// Possible values:
	//   "STRATEGY_UNSPECIFIED" - Unspecified. Defaults to `SERVER_VALUE`.
	//   "SERVER_VALUE" - The server entity is kept.
	//   "FAIL" - The whole commit request fails.
	ConflictResolutionStrategy string `json:"conflictResolutionStrategy,omitempty"`
	// Delete: The key of the entity to delete. The entity may or may not already
	// exist. Must have a complete key path and must not be reserved/read-only.
	Delete *Key `json:"delete,omitempty"`
	// Insert: The entity to insert. The entity must not already exist. The entity
	// key's final path element may be incomplete.
	Insert *Entity `json:"insert,omitempty"`
	// PropertyMask: The properties to write in this mutation. None of the
	// properties in the mask may have a reserved name, except for `__key__`. This
	// field is ignored for `delete`. If the entity already exists, only properties
	// referenced in the mask are updated, others are left untouched. Properties
	// referenced in the mask but not in the entity are deleted.
	PropertyMask *PropertyMask `json:"propertyMask,omitempty"`
	// PropertyTransforms: Optional. The transforms to perform on the entity. This
	// field can be set only when the operation is `insert`, `update`, or `upsert`.
	// If present, the transforms are be applied to the entity regardless of the
	// property mask, in order, after the operation.
	PropertyTransforms []*PropertyTransform `json:"propertyTransforms,omitempty"`
	// Update: The entity to update. The entity must already exist. Must have a
	// complete key path.
	Update *Entity `json:"update,omitempty"`
	// UpdateTime: The update time of the entity that this mutation is being
	// applied to. If this does not match the current update time on the server,
	// the mutation conflicts.
	UpdateTime string `json:"updateTime,omitempty"`
	// Upsert: The entity to upsert. The entity may or may not already exist. The
	// entity key's final path element may be incomplete.
	Upsert *Entity `json:"upsert,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BaseVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaseVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Mutation) MarshalJSON() ([]byte, error) {
	type NoMethod Mutation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MutationResult: The result of applying a mutation.
type MutationResult struct {
	// ConflictDetected: Whether a conflict was detected for this mutation. Always
	// false when a conflict detection strategy field is not set in the mutation.
	ConflictDetected bool `json:"conflictDetected,omitempty"`
	// CreateTime: The create time of the entity. This field will not be set after
	// a 'delete'.
	CreateTime string `json:"createTime,omitempty"`
	// Key: The automatically allocated key. Set only when the mutation allocated a
	// key.
	Key *Key `json:"key,omitempty"`
	// TransformResults: The results of applying each PropertyTransform, in the
	// same order of the request.
	TransformResults []*Value `json:"transformResults,omitempty"`
	// UpdateTime: The update time of the entity on the server after processing the
	// mutation. If the mutation doesn't change anything on the server, then the
	// timestamp will be the update timestamp of the current entity. This field
	// will not be set after a 'delete'.
	UpdateTime string `json:"updateTime,omitempty"`
	// Version: The version of the entity on the server after processing the
	// mutation. If the mutation doesn't change anything on the server, then the
	// version will be the version of the current entity or, if no entity is
	// present, a version that is strictly greater than the version of any previous
	// entity and less than the version of any possible future entity.
	Version int64 `json:"version,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ConflictDetected") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConflictDetected") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MutationResult) MarshalJSON() ([]byte, error) {
	type NoMethod MutationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PartitionId: A partition ID identifies a grouping of entities. The grouping
// is always by project and namespace, however the namespace ID may be empty. A
// partition ID contains several dimensions: project ID and namespace ID.
// Partition dimensions: - May be "". - Must be valid UTF-8 bytes. - Must
// have values that match regex `[A-Za-z\d\.\-_]{1,100}` If the value of any
// dimension matches regex `__.*__`, the partition is reserved/read-only. A
// reserved/read-only partition ID is forbidden in certain documented contexts.
// Foreign partition IDs (in which the project ID does not match the context
// project ID ) are discouraged. Reads and writes of foreign partition IDs may
// fail if the project is not in an active state.
type PartitionId struct {
	// NamespaceId: If not empty, the ID of the namespace to which the entities
	// belong.
	NamespaceId string `json:"namespaceId,omitempty"`
	// ProjectId: The ID of the project to which the entities belong.
	ProjectId string `json:"projectId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NamespaceId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NamespaceId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PartitionId) MarshalJSON() ([]byte, error) {
	type NoMethod PartitionId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PathElement: A (kind, ID/name) pair used to construct a key path. If either
// name or ID is set, the element is complete. If neither is set, the element
// is incomplete.
type PathElement struct {
	// Id: The auto-allocated ID of the entity. Never equal to zero. Values less
	// than zero are discouraged and may not be supported in the future.
	Id int64 `json:"id,omitempty,string"`
	// Kind: The kind of the entity. A kind matching regex `__.*__` is
	// reserved/read-only. A kind must not contain more than 1500 bytes when UTF-8
	// encoded. Cannot be "". Must be valid UTF-8 bytes. Legacy values that are
	// not valid UTF-8 are encoded as `__bytes__` where `` is the base-64 encoding
	// of the bytes.
	Kind string `json:"kind,omitempty"`
	// Name: The name of the entity. A name matching regex `__.*__` is
	// reserved/read-only. A name must not be more than 1500 bytes when UTF-8
	// encoded. Cannot be "". Must be valid UTF-8 bytes. Legacy values that are
	// not valid UTF-8 are encoded as `__bytes__` where `` is the base-64 encoding
	// of the bytes.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PathElement) MarshalJSON() ([]byte, error) {
	type NoMethod PathElement
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PlanSummary: Planning phase information for the query.
type PlanSummary struct {
	// IndexesUsed: The indexes selected for the query. For example: [
	// {"query_scope": "Collection", "properties": "(foo ASC, __name__ ASC)"},
	// {"query_scope": "Collection", "properties": "(bar ASC, __name__ ASC)"} ]
	IndexesUsed []googleapi.RawMessage `json:"indexesUsed,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IndexesUsed") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IndexesUsed") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PlanSummary) MarshalJSON() ([]byte, error) {
	type NoMethod PlanSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Projection: A representation of a property in a projection.
type Projection struct {
	// Property: The property to project.
	Property *PropertyReference `json:"property,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Property") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Property") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Projection) MarshalJSON() ([]byte, error) {
	type NoMethod Projection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PropertyFilter: A filter on a specific property.
type PropertyFilter struct {
	// Op: The operator to filter by.
	//
	// Possible values:
	//   "OPERATOR_UNSPECIFIED" - Unspecified. This value must not be used.
	//   "LESS_THAN" - The given `property` is less than the given `value`.
	// Requires: * That `property` comes first in `order_by`.
	//   "LESS_THAN_OR_EQUAL" - The given `property` is less than or equal to the
	// given `value`. Requires: * That `property` comes first in `order_by`.
	//   "GREATER_THAN" - The given `property` is greater than the given `value`.
	// Requires: * That `property` comes first in `order_by`.
	//   "GREATER_THAN_OR_EQUAL" - The given `property` is greater than or equal to
	// the given `value`. Requires: * That `property` comes first in `order_by`.
	//   "EQUAL" - The given `property` is equal to the given `value`.
	//   "IN" - The given `property` is equal to at least one value in the given
	// array. Requires: * That `value` is a non-empty `ArrayValue`, subject to
	// disjunction limits. * No `NOT_IN` is in the same query.
	//   "NOT_EQUAL" - The given `property` is not equal to the given `value`.
	// Requires: * No other `NOT_EQUAL` or `NOT_IN` is in the same query. * That
	// `property` comes first in the `order_by`.
	//   "HAS_ANCESTOR" - Limit the result set to the given entity and its
	// descendants. Requires: * That `value` is an entity key. * All evaluated
	// disjunctions must have the same `HAS_ANCESTOR` filter.
	//   "NOT_IN" - The value of the `property` is not in the given array.
	// Requires: * That `value` is a non-empty `ArrayValue` with at most 10 values.
	// * No other `OR`, `IN`, `NOT_IN`, `NOT_EQUAL` is in the same query. * That
	// `field` comes first in the `order_by`.
	Op string `json:"op,omitempty"`
	// Property: The property to filter by.
	Property *PropertyReference `json:"property,omitempty"`
	// Value: The value to compare the property to.
	Value *Value `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Op") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Op") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PropertyFilter) MarshalJSON() ([]byte, error) {
	type NoMethod PropertyFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PropertyMask: The set of arbitrarily nested property paths used to restrict
// an operation to only a subset of properties in an entity.
type PropertyMask struct {
	// Paths: The paths to the properties covered by this mask. A path is a list of
	// property names separated by dots (`.`), for example `foo.bar` means the
	// property `bar` inside the entity property `foo` inside the entity associated
	// with this path. If a property name contains a dot `.` or a backslash `\`,
	// then that name must be escaped. A path must not be empty, and may not
	// reference a value inside an array value.
	Paths []string `json:"paths,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Paths") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Paths") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PropertyMask) MarshalJSON() ([]byte, error) {
	type NoMethod PropertyMask
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PropertyOrder: The desired order for a specific property.
type PropertyOrder struct {
	// Direction: The direction to order by. Defaults to `ASCENDING`.
	//
	// Possible values:
	//   "DIRECTION_UNSPECIFIED" - Unspecified. This value must not be used.
	//   "ASCENDING" - Ascending.
	//   "DESCENDING" - Descending.
	Direction string `json:"direction,omitempty"`
	// Property: The property to order by.
	Property *PropertyReference `json:"property,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Direction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Direction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PropertyOrder) MarshalJSON() ([]byte, error) {
	type NoMethod PropertyOrder
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PropertyReference: A reference to a property relative to the kind
// expressions.
type PropertyReference struct {
	// Name: A reference to a property. Requires: * MUST be a dot-delimited (`.`)
	// string of segments, where each segment conforms to entity property name
	// limitations.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PropertyReference) MarshalJSON() ([]byte, error) {
	type NoMethod PropertyReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PropertyTransform: A transformation of an entity property.
type PropertyTransform struct {
	// AppendMissingElements: Appends the given elements in order if they are not
	// already present in the current property value. If the property is not an
	// array, or if the property does not yet exist, it is first set to the empty
	// array. Equivalent numbers of different types (e.g. 3L and 3.0) are
	// considered equal when checking if a value is missing. NaN is equal to NaN,
	// and the null value is equal to the null value. If the input contains
	// multiple equivalent values, only the first will be considered. The
	// corresponding transform result will be the null value.
	AppendMissingElements *ArrayValue `json:"appendMissingElements,omitempty"`
	// Increment: Adds the given value to the property's current value. This must
	// be an integer or a double value. If the property is not an integer or
	// double, or if the property does not yet exist, the transformation will set
	// the property to the given value. If either of the given value or the current
	// property value are doubles, both values will be interpreted as doubles.
	// Double arithmetic and representation of double values follows IEEE 754
	// semantics. If there is positive/negative integer overflow, the property is
	// resolved to the largest magnitude positive/negative integer.
	Increment *Value `json:"increment,omitempty"`
	// Maximum: Sets the property to the maximum of its current value and the given
	// value. This must be an integer or a double value. If the property is not an
	// integer or double, or if the property does not yet exist, the transformation
	// will set the property to the given value. If a maximum operation is applied
	// where the property and the input value are of mixed types (that is - one is
	// an integer and one is a double) the property takes on the type of the larger
	// operand. If the operands are equivalent (e.g. 3 and 3.0), the property does
	// not change. 0, 0.0, and -0.0 are all zero. The maximum of a zero stored
	// value and zero input value is always the stored value. The maximum of any
	// numeric value x and NaN is NaN.
	Maximum *Value `json:"maximum,omitempty"`
	// Minimum: Sets the property to the minimum of its current value and the given
	// value. This must be an integer or a double value. If the property is not an
	// integer or double, or if the property does not yet exist, the transformation
	// will set the property to the input value. If a minimum operation is applied
	// where the property and the input value are of mixed types (that is - one is
	// an integer and one is a double) the property takes on the type of the
	// smaller operand. If the operands are equivalent (e.g. 3 and 3.0), the
	// property does not change. 0, 0.0, and -0.0 are all zero. The minimum of a
	// zero stored value and zero input value is always the stored value. The
	// minimum of any numeric value x and NaN is NaN.
	Minimum *Value `json:"minimum,omitempty"`
	// Property: Optional. The name of the property. Property paths (a list of
	// property names separated by dots (`.`)) may be used to refer to properties
	// inside entity values. For example `foo.bar` means the property `bar` inside
	// the entity property `foo`. If a property name contains a dot `.` or a
	// backlslash `\`, then that name must be escaped.
	Property string `json:"property,omitempty"`
	// RemoveAllFromArray: Removes all of the given elements from the array in the
	// property. If the property is not an array, or if the property does not yet
	// exist, it is set to the empty array. Equivalent numbers of different types
	// (e.g. 3L and 3.0) are considered equal when deciding whether an element
	// should be removed. NaN is equal to NaN, and the null value is equal to the
	// null value. This will remove all equivalent values if there are duplicates.
	// The corresponding transform result will be the null value.
	RemoveAllFromArray *ArrayValue `json:"removeAllFromArray,omitempty"`
	// SetToServerValue: Sets the property to the given server value.
	//
	// Possible values:
	//   "SERVER_VALUE_UNSPECIFIED" - Unspecified. This value must not be used.
	//   "REQUEST_TIME" - The time at which the server processed the request, with
	// millisecond precision. If used on multiple properties (same or different
	// entities) in a transaction, all the properties will get the same server
	// timestamp.
	SetToServerValue string `json:"setToServerValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AppendMissingElements") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppendMissingElements") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PropertyTransform) MarshalJSON() ([]byte, error) {
	type NoMethod PropertyTransform
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Query: A query for entities. The query stages are executed in the following
// order: 1. kind 2. filter 3. projection 4. order + start_cursor + end_cursor
// 5. offset 6. limit 7. find_nearest
type Query struct {
	// DistinctOn: The properties to make distinct. The query results will contain
	// the first result for each distinct combination of values for the given
	// properties (if empty, all results are returned). Requires: * If `order` is
	// specified, the set of distinct on properties must appear before the
	// non-distinct on properties in `order`.
	DistinctOn []*PropertyReference `json:"distinctOn,omitempty"`
	// EndCursor: An ending point for the query results. Query cursors are returned
	// in query result batches and can only be used to limit the same query
	// (https://cloud.google.com/datastore/docs/concepts/queries#cursors_limits_and_offsets).
	EndCursor string `json:"endCursor,omitempty"`
	// Filter: The filter to apply.
	Filter *Filter `json:"filter,omitempty"`
	// FindNearest: Optional. A potential Nearest Neighbors Search. Applies after
	// all other filters and ordering. Finds the closest vector embeddings to the
	// given query vector.
	FindNearest *FindNearest `json:"findNearest,omitempty"`
	// Kind: The kinds to query (if empty, returns entities of all kinds).
	// Currently at most 1 kind may be specified.
	Kind []*KindExpression `json:"kind,omitempty"`
	// Limit: The maximum number of results to return. Applies after all other
	// constraints. Optional. Unspecified is interpreted as no limit. Must be >= 0
	// if specified.
	Limit int64 `json:"limit,omitempty"`
	// Offset: The number of results to skip. Applies before limit, but after all
	// other constraints. Optional. Must be >= 0 if specified.
	Offset int64 `json:"offset,omitempty"`
	// Order: The order to apply to the query results (if empty, order is
	// unspecified).
	Order []*PropertyOrder `json:"order,omitempty"`
	// Projection: The projection to return. Defaults to returning all properties.
	Projection []*Projection `json:"projection,omitempty"`
	// StartCursor: A starting point for the query results. Query cursors are
	// returned in query result batches and can only be used to continue the same
	// query
	// (https://cloud.google.com/datastore/docs/concepts/queries#cursors_limits_and_offsets).
	StartCursor string `json:"startCursor,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DistinctOn") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DistinctOn") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Query) MarshalJSON() ([]byte, error) {
	type NoMethod Query
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// QueryResultBatch: A batch of results produced by a query.
type QueryResultBatch struct {
	// EndCursor: A cursor that points to the position after the last result in the
	// batch.
	EndCursor string `json:"endCursor,omitempty"`
	// EntityResultType: The result type for every entity in `entity_results`.
	//
	// Possible values:
	//   "RESULT_TYPE_UNSPECIFIED" - Unspecified. This value is never used.
	//   "FULL" - The key and properties.
	//   "PROJECTION" - A projected subset of properties. The entity may have no
	// key.
	//   "KEY_ONLY" - Only the key.
	EntityResultType string `json:"entityResultType,omitempty"`
	// EntityResults: The results for this batch.
	EntityResults []*EntityResult `json:"entityResults,omitempty"`
	// MoreResults: The state of the query after the current batch.
	//
	// Possible values:
	//   "MORE_RESULTS_TYPE_UNSPECIFIED" - Unspecified. This value is never used.
	//   "NOT_FINISHED" - There may be additional batches to fetch from this query.
	//   "MORE_RESULTS_AFTER_LIMIT" - The query is finished, but there may be more
	// results after the limit.
	//   "MORE_RESULTS_AFTER_CURSOR" - The query is finished, but there may be more
	// results after the end cursor.
	//   "NO_MORE_RESULTS" - The query is finished, and there are no more results.
	MoreResults string `json:"moreResults,omitempty"`
	// ReadTime: Read timestamp this batch was returned from. This applies to the
	// range of results from the query's `start_cursor` (or the beginning of the
	// query if no cursor was given) to this batch's `end_cursor` (not the query's
	// `end_cursor`). In a single transaction, subsequent query result batches for
	// the same query can have a greater timestamp. Each batch's read timestamp is
	// valid for all preceding batches. This value will not be set for eventually
	// consistent queries in Cloud Datastore.
	ReadTime string `json:"readTime,omitempty"`
	// SkippedCursor: A cursor that points to the position after the last skipped
	// result. Will be set when `skipped_results` != 0.
	SkippedCursor string `json:"skippedCursor,omitempty"`
	// SkippedResults: The number of results skipped, typically because of an
	// offset.
	SkippedResults int64 `json:"skippedResults,omitempty"`
	// SnapshotVersion: The version number of the snapshot this batch was returned
	// from. This applies to the range of results from the query's `start_cursor`
	// (or the beginning of the query if no cursor was given) to this batch's
	// `end_cursor` (not the query's `end_cursor`). In a single transaction,
	// subsequent query result batches for the same query can have a greater
	// snapshot version number. Each batch's snapshot version is valid for all
	// preceding batches. The value will be zero for eventually consistent queries.
	SnapshotVersion int64 `json:"snapshotVersion,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "EndCursor") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndCursor") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s QueryResultBatch) MarshalJSON() ([]byte, error) {
	type NoMethod QueryResultBatch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReadOnly: Options specific to read-only transactions.
type ReadOnly struct {
	// ReadTime: Reads entities at the given time. This must be a microsecond
	// precision timestamp within the past one hour, or if Point-in-Time Recovery
	// is enabled, can additionally be a whole minute timestamp within the past 7
	// days.
	ReadTime string `json:"readTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReadTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReadTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReadOnly) MarshalJSON() ([]byte, error) {
	type NoMethod ReadOnly
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReadOptions: The options shared by read requests.
type ReadOptions struct {
	// ReadConsistency: The non-transactional read consistency to use.
	//
	// Possible values:
	//   "READ_CONSISTENCY_UNSPECIFIED" - Unspecified. This value must not be used.
	//   "STRONG" - Strong consistency.
	//   "EVENTUAL" - Eventual consistency.
	ReadConsistency string `json:"readConsistency,omitempty"`
	// ReadTime: Reads entities as they were at the given time. This value is only
	// supported for Cloud Firestore in Datastore mode. This must be a microsecond
	// precision timestamp within the past one hour, or if Point-in-Time Recovery
	// is enabled, can additionally be a whole minute timestamp within the past 7
	// days.
	ReadTime string `json:"readTime,omitempty"`
	// Transaction: The identifier of the transaction in which to read. A
	// transaction identifier is returned by a call to Datastore.BeginTransaction.
	Transaction string `json:"transaction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReadConsistency") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReadConsistency") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReadOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ReadOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReadWrite: Options specific to read / write transactions.
type ReadWrite struct {
	// PreviousTransaction: The transaction identifier of the transaction being
	// retried.
	PreviousTransaction string `json:"previousTransaction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PreviousTransaction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PreviousTransaction") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReadWrite) MarshalJSON() ([]byte, error) {
	type NoMethod ReadWrite
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReserveIdsRequest: The request for Datastore.ReserveIds.
type ReserveIdsRequest struct {
	// DatabaseId: The ID of the database against which to make the request.
	// '(default)' is not allowed; please use empty string '' to refer the default
	// database.
	DatabaseId string `json:"databaseId,omitempty"`
	// Keys: Required. A list of keys with complete key paths whose numeric IDs
	// should not be auto-allocated.
	Keys []*Key `json:"keys,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatabaseId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatabaseId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReserveIdsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ReserveIdsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReserveIdsResponse: The response for Datastore.ReserveIds.
type ReserveIdsResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// RollbackRequest: The request for Datastore.Rollback.
type RollbackRequest struct {
	// Transaction: Required. The transaction identifier, returned by a call to
	// Datastore.BeginTransaction.
	Transaction string `json:"transaction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Transaction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Transaction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RollbackRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RollbackRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RollbackResponse: The response for Datastore.Rollback. (an empty message).
type RollbackResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// RunAggregationQueryRequest: The request for Datastore.RunAggregationQuery.
type RunAggregationQueryRequest struct {
	// AggregationQuery: The query to run.
	AggregationQuery *AggregationQuery `json:"aggregationQuery,omitempty"`
	// ExplainOptions: Optional. Explain options for the query. If set, additional
	// query statistics will be returned. If not, only query results will be
	// returned.
	ExplainOptions *ExplainOptions `json:"explainOptions,omitempty"`
	// GqlQuery: The GQL query to run. This query must be an aggregation query.
	GqlQuery *GqlQuery `json:"gqlQuery,omitempty"`
	// PartitionId: Entities are partitioned into subsets, identified by a
	// partition ID. Queries are scoped to a single partition. This partition ID is
	// normalized with the standard default context partition ID.
	PartitionId *PartitionId `json:"partitionId,omitempty"`
	// ReadOptions: The options for this query.
	ReadOptions *ReadOptions `json:"readOptions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AggregationQuery") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AggregationQuery") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RunAggregationQueryRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RunAggregationQueryRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RunAggregationQueryResponse: The response for Datastore.RunAggregationQuery.
type RunAggregationQueryResponse struct {
	// Batch: A batch of aggregation results. Always present.
	Batch *AggregationResultBatch `json:"batch,omitempty"`
	// ExplainMetrics: Query explain metrics. This is only present when the
	// RunAggregationQueryRequest.explain_options is provided, and it is sent only
	// once with the last response in the stream.
	ExplainMetrics *ExplainMetrics `json:"explainMetrics,omitempty"`
	// Query: The parsed form of the `GqlQuery` from the request, if it was set.
	Query *AggregationQuery `json:"query,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Batch") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Batch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RunAggregationQueryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod RunAggregationQueryResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RunQueryRequest: The request for Datastore.RunQuery.
type RunQueryRequest struct {
	// ExplainOptions: Optional. Explain options for the query. If set, additional
	// query statistics will be returned. If not, only query results will be
	// returned.
	ExplainOptions *ExplainOptions `json:"explainOptions,omitempty"`
	// GqlQuery: The GQL query to run. This query must be a non-aggregation query.
	GqlQuery *GqlQuery `json:"gqlQuery,omitempty"`
	// PartitionId: Entities are partitioned into subsets, identified by a
	// partition ID. Queries are scoped to a single partition. This partition ID is
	// normalized with the standard default context partition ID.
	PartitionId *PartitionId `json:"partitionId,omitempty"`
	// PropertyMask: The properties to return. This field must not be set for a
	// projection query. See LookupRequest.property_mask.
	PropertyMask *PropertyMask `json:"propertyMask,omitempty"`
	// Query: The query to run.
	Query *Query `json:"query,omitempty"`
	// ReadOptions: The options for this query.
	ReadOptions *ReadOptions `json:"readOptions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExplainOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExplainOptions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RunQueryRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RunQueryRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RunQueryResponse: The response for Datastore.RunQuery.
type RunQueryResponse struct {
	// Batch: A batch of query results (always present).
	Batch *QueryResultBatch `json:"batch,omitempty"`
	// ExplainMetrics: Query explain metrics. This is only present when the
	// RunQueryRequest.explain_options is provided, and it is sent only once with
	// the last response in the stream.
	ExplainMetrics *ExplainMetrics `json:"explainMetrics,omitempty"`
	// Query: The parsed form of the `GqlQuery` from the request, if it was set.
	Query *Query `json:"query,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Batch") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Batch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RunQueryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod RunQueryResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Sum: Sum of the values of the requested property. * Only numeric values will
// be aggregated. All non-numeric values including `NULL` are skipped. * If the
// aggregated values contain `NaN`, returns `NaN`. Infinity math follows
// IEEE-754 standards. * If the aggregated value set is empty, returns 0. *
// Returns a 64-bit integer if all aggregated numbers are integers and the sum
// result does not overflow. Otherwise, the result is returned as a double.
// Note that even if all the aggregated values are integers, the result is
// returned as a double if it cannot fit within a 64-bit signed integer. When
// this occurs, the returned value will lose precision. * When underflow
// occurs, floating-point aggregation is non-deterministic. This means that
// running the same query repeatedly without any changes to the underlying
// values could produce slightly different results each time. In those cases,
// values should be stored as integers over floating-point numbers.
type Sum struct {
	// Property: The property to aggregate on.
	Property *PropertyReference `json:"property,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Property") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Property") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Sum) MarshalJSON() ([]byte, error) {
	type NoMethod Sum
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TransactionOptions: Options for beginning a new transaction. Transactions
// can be created explicitly with calls to Datastore.BeginTransaction or
// implicitly by setting ReadOptions.new_transaction in read requests.
type TransactionOptions struct {
	// ReadOnly: The transaction should only allow reads.
	ReadOnly *ReadOnly `json:"readOnly,omitempty"`
	// ReadWrite: The transaction should allow both reads and writes.
	ReadWrite *ReadWrite `json:"readWrite,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReadOnly") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReadOnly") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TransactionOptions) MarshalJSON() ([]byte, error) {
	type NoMethod TransactionOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Value: A message that can hold any of the supported value types and
// associated metadata.
type Value struct {
	// ArrayValue: An array value. Cannot contain another array value. A `Value`
	// instance that sets field `array_value` must not set fields `meaning` or
	// `exclude_from_indexes`.
	ArrayValue *ArrayValue `json:"arrayValue,omitempty"`
	// BlobValue: A blob value. May have at most 1,000,000 bytes. When
	// `exclude_from_indexes` is false, may have at most 1500 bytes. In JSON
	// requests, must be base64-encoded.
	BlobValue *string `json:"blobValue,omitempty"`
	// BooleanValue: A boolean value.
	BooleanValue *bool `json:"booleanValue,omitempty"`
	// DoubleValue: A double value.
	DoubleValue *float64 `json:"doubleValue,omitempty"`
	// EntityValue: An entity value. - May have no key. - May have a key with an
	// incomplete key path. - May have a reserved/read-only key.
	EntityValue *Entity `json:"entityValue,omitempty"`
	// ExcludeFromIndexes: If the value should be excluded from all indexes
	// including those defined explicitly.
	ExcludeFromIndexes bool `json:"excludeFromIndexes,omitempty"`
	// GeoPointValue: A geo point value representing a point on the surface of
	// Earth.
	GeoPointValue *LatLng `json:"geoPointValue,omitempty"`
	// IntegerValue: An integer value.
	IntegerValue *int64 `json:"integerValue,omitempty,string"`
	// KeyValue: A key value.
	KeyValue *Key `json:"keyValue,omitempty"`
	// Meaning: The `meaning` field should only be populated for backwards
	// compatibility.
	Meaning int64 `json:"meaning,omitempty"`
	// NullValue: A null value.
	//
	// Possible values:
	//   "NULL_VALUE" - Null value.
	NullValue string `json:"nullValue,omitempty"`
	// StringValue: A UTF-8 encoded string value. When `exclude_from_indexes` is
	// false (it is indexed) , may have at most 1500 bytes. Otherwise, may be set
	// to at most 1,000,000 bytes.
	StringValue *string `json:"stringValue,omitempty"`
	// TimestampValue: A timestamp value. When stored in the Datastore, precise
	// only to microseconds; any additional precision is rounded down.
	TimestampValue *string `json:"timestampValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArrayValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArrayValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Value) MarshalJSON() ([]byte, error) {
	type NoMethod Value
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *Value) UnmarshalJSON(data []byte) error {
	type NoMethod Value
	var s1 struct {
		DoubleValue *gensupport.JSONFloat64 `json:"doubleValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	if s1.DoubleValue != nil {
		s.DoubleValue = (*float64)(s1.DoubleValue)
	}
	return nil
}

type ProjectsAllocateIdsCall struct {
	s                  *Service
	projectId          string
	allocateidsrequest *AllocateIdsRequest
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// AllocateIds: Allocates IDs for the given keys, which is useful for
// referencing an entity before it is inserted.
//
// - projectId: The ID of the project against which to make the request.
func (r *ProjectsService) AllocateIds(projectId string, allocateidsrequest *AllocateIdsRequest) *ProjectsAllocateIdsCall {
	c := &ProjectsAllocateIdsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.allocateidsrequest = allocateidsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAllocateIdsCall) Fields(s ...googleapi.Field) *ProjectsAllocateIdsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAllocateIdsCall) Context(ctx context.Context) *ProjectsAllocateIdsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAllocateIdsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAllocateIdsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.allocateidsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/projects/{projectId}:allocateIds")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datastore.projects.allocateIds" call.
// Any non-2xx status code is an error. Response headers are in either
// *AllocateIdsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAllocateIdsCall) Do(opts ...googleapi.CallOption) (*AllocateIdsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AllocateIdsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsBeginTransactionCall struct {
	s                       *Service
	projectId               string
	begintransactionrequest *BeginTransactionRequest
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// BeginTransaction: Begins a new transaction.
//
// - projectId: The ID of the project against which to make the request.
func (r *ProjectsService) BeginTransaction(projectId string, begintransactionrequest *BeginTransactionRequest) *ProjectsBeginTransactionCall {
	c := &ProjectsBeginTransactionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.begintransactionrequest = begintransactionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsBeginTransactionCall) Fields(s ...googleapi.Field) *ProjectsBeginTransactionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsBeginTransactionCall) Context(ctx context.Context) *ProjectsBeginTransactionCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsBeginTransactionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsBeginTransactionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.begintransactionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/projects/{projectId}:beginTransaction")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datastore.projects.beginTransaction" call.
// Any non-2xx status code is an error. Response headers are in either
// *BeginTransactionResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsBeginTransactionCall) Do(opts ...googleapi.CallOption) (*BeginTransactionResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BeginTransactionResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsCommitCall struct {
	s             *Service
	projectId     string
	commitrequest *CommitRequest
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Commit: Commits a transaction, optionally creating, deleting or modifying
// some entities.
//
// - projectId: The ID of the project against which to make the request.
func (r *ProjectsService) Commit(projectId string, commitrequest *CommitRequest) *ProjectsCommitCall {
	c := &ProjectsCommitCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.commitrequest = commitrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsCommitCall) Fields(s ...googleapi.Field) *ProjectsCommitCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsCommitCall) Context(ctx context.Context) *ProjectsCommitCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsCommitCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsCommitCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.commitrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/projects/{projectId}:commit")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datastore.projects.commit" call.
// Any non-2xx status code is an error. Response headers are in either
// *CommitResponse.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsCommitCall) Do(opts ...googleapi.CallOption) (*CommitResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CommitResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsLookupCall struct {
	s             *Service
	projectId     string
	lookuprequest *LookupRequest
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Lookup: Looks up entities by key.
//
// - projectId: The ID of the project against which to make the request.
func (r *ProjectsService) Lookup(projectId string, lookuprequest *LookupRequest) *ProjectsLookupCall {
	c := &ProjectsLookupCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.lookuprequest = lookuprequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLookupCall) Fields(s ...googleapi.Field) *ProjectsLookupCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLookupCall) Context(ctx context.Context) *ProjectsLookupCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLookupCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLookupCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.lookuprequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/projects/{projectId}:lookup")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datastore.projects.lookup" call.
// Any non-2xx status code is an error. Response headers are in either
// *LookupResponse.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLookupCall) Do(opts ...googleapi.CallOption) (*LookupResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LookupResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsReserveIdsCall struct {
	s                 *Service
	projectId         string
	reserveidsrequest *ReserveIdsRequest
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// ReserveIds: Prevents the supplied keys' IDs from being auto-allocated by
// Cloud Datastore.
//
// - projectId: The ID of the project against which to make the request.
func (r *ProjectsService) ReserveIds(projectId string, reserveidsrequest *ReserveIdsRequest) *ProjectsReserveIdsCall {
	c := &ProjectsReserveIdsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.reserveidsrequest = reserveidsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsReserveIdsCall) Fields(s ...googleapi.Field) *ProjectsReserveIdsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsReserveIdsCall) Context(ctx context.Context) *ProjectsReserveIdsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsReserveIdsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsReserveIdsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.reserveidsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/projects/{projectId}:reserveIds")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datastore.projects.reserveIds" call.
// Any non-2xx status code is an error. Response headers are in either
// *ReserveIdsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsReserveIdsCall) Do(opts ...googleapi.CallOption) (*ReserveIdsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ReserveIdsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsRollbackCall struct {
	s               *Service
	projectId       string
	rollbackrequest *RollbackRequest
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Rollback: Rolls back a transaction.
//
// - projectId: The ID of the project against which to make the request.
func (r *ProjectsService) Rollback(projectId string, rollbackrequest *RollbackRequest) *ProjectsRollbackCall {
	c := &ProjectsRollbackCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.rollbackrequest = rollbackrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsRollbackCall) Fields(s ...googleapi.Field) *ProjectsRollbackCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsRollbackCall) Context(ctx context.Context) *ProjectsRollbackCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsRollbackCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsRollbackCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.rollbackrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/projects/{projectId}:rollback")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datastore.projects.rollback" call.
// Any non-2xx status code is an error. Response headers are in either
// *RollbackResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsRollbackCall) Do(opts ...googleapi.CallOption) (*RollbackResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RollbackResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsRunAggregationQueryCall struct {
	s                          *Service
	projectId                  string
	runaggregationqueryrequest *RunAggregationQueryRequest
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// RunAggregationQuery: Runs an aggregation query.
//
// - projectId: The ID of the project against which to make the request.
func (r *ProjectsService) RunAggregationQuery(projectId string, runaggregationqueryrequest *RunAggregationQueryRequest) *ProjectsRunAggregationQueryCall {
	c := &ProjectsRunAggregationQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.runaggregationqueryrequest = runaggregationqueryrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsRunAggregationQueryCall) Fields(s ...googleapi.Field) *ProjectsRunAggregationQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsRunAggregationQueryCall) Context(ctx context.Context) *ProjectsRunAggregationQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsRunAggregationQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsRunAggregationQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.runaggregationqueryrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/projects/{projectId}:runAggregationQuery")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datastore.projects.runAggregationQuery" call.
// Any non-2xx status code is an error. Response headers are in either
// *RunAggregationQueryResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsRunAggregationQueryCall) Do(opts ...googleapi.CallOption) (*RunAggregationQueryResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RunAggregationQueryResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsRunQueryCall struct {
	s               *Service
	projectId       string
	runqueryrequest *RunQueryRequest
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// RunQuery: Queries for entities.
//
// - projectId: The ID of the project against which to make the request.
func (r *ProjectsService) RunQuery(projectId string, runqueryrequest *RunQueryRequest) *ProjectsRunQueryCall {
	c := &ProjectsRunQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.runqueryrequest = runqueryrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsRunQueryCall) Fields(s ...googleapi.Field) *ProjectsRunQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsRunQueryCall) Context(ctx context.Context) *ProjectsRunQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsRunQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsRunQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.runqueryrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta3/projects/{projectId}:runQuery")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datastore.projects.runQuery" call.
// Any non-2xx status code is an error. Response headers are in either
// *RunQueryResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsRunQueryCall) Do(opts ...googleapi.CallOption) (*RunQueryResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RunQueryResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}
