// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package adm

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// GetStageRequest wrapper for the GetStage operation
//
// # See also
//
// Click https://docs.cloud.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/adm/GetStage.go.html to see an example of how to use GetStageRequest.
type GetStageRequest struct {

	// Unique Remediation Run identifier path parameter.
	RemediationRunId *string `mandatory:"true" contributesTo:"path" name:"remediationRunId"`

	// The type of Remediation Run Stage, as a URL path parameter.
	StageType GetStageStageTypeEnum `mandatory:"true" contributesTo:"path" name:"stageType"`

	// The client request ID for tracing.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request GetStageRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request GetStageRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request GetStageRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request GetStageRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request GetStageRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingGetStageStageTypeEnum(string(request.StageType)); !ok && request.StageType != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for StageType: %s. Supported values are: %s.", request.StageType, strings.Join(GetGetStageStageTypeEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// GetStageResponse wrapper for the GetStage operation
type GetStageResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// The RemediationRunStage instance
	RemediationRunStage `presentIn:"body"`

	// Unique Oracle-assigned identifier for the request. If you need to contact
	// Oracle about a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`
}

func (response GetStageResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response GetStageResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// GetStageStageTypeEnum Enum with underlying type: string
type GetStageStageTypeEnum string

// Set of constants representing the allowable values for GetStageStageTypeEnum
const (
	GetStageStageTypeDetect    GetStageStageTypeEnum = "DETECT"
	GetStageStageTypeRecommend GetStageStageTypeEnum = "RECOMMEND"
	GetStageStageTypeVerify    GetStageStageTypeEnum = "VERIFY"
	GetStageStageTypeApply     GetStageStageTypeEnum = "APPLY"
)

var mappingGetStageStageTypeEnum = map[string]GetStageStageTypeEnum{
	"DETECT":    GetStageStageTypeDetect,
	"RECOMMEND": GetStageStageTypeRecommend,
	"VERIFY":    GetStageStageTypeVerify,
	"APPLY":     GetStageStageTypeApply,
}

var mappingGetStageStageTypeEnumLowerCase = map[string]GetStageStageTypeEnum{
	"detect":    GetStageStageTypeDetect,
	"recommend": GetStageStageTypeRecommend,
	"verify":    GetStageStageTypeVerify,
	"apply":     GetStageStageTypeApply,
}

// GetGetStageStageTypeEnumValues Enumerates the set of values for GetStageStageTypeEnum
func GetGetStageStageTypeEnumValues() []GetStageStageTypeEnum {
	values := make([]GetStageStageTypeEnum, 0)
	for _, v := range mappingGetStageStageTypeEnum {
		values = append(values, v)
	}
	return values
}

// GetGetStageStageTypeEnumStringValues Enumerates the set of values in String for GetStageStageTypeEnum
func GetGetStageStageTypeEnumStringValues() []string {
	return []string{
		"DETECT",
		"RECOMMEND",
		"VERIFY",
		"APPLY",
	}
}

// GetMappingGetStageStageTypeEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingGetStageStageTypeEnum(val string) (GetStageStageTypeEnum, bool) {
	enum, ok := mappingGetStageStageTypeEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
