// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// AlertListItemDTO alert list item DTO
//
// swagger:model AlertListItemDTO
type AlertListItemDTO struct {

	// dashboard Id
	DashboardID int64 `json:"dashboardId,omitempty"`

	// dashboard slug
	DashboardSlug string `json:"dashboardSlug,omitempty"`

	// dashboard Uid
	DashboardUID string `json:"dashboardUid,omitempty"`

	// eval data
	EvalData JSON `json:"evalData,omitempty"`

	// eval date
	// Format: date-time
	EvalDate strfmt.DateTime `json:"evalDate,omitempty"`

	// execution error
	ExecutionError string `json:"executionError,omitempty"`

	// id
	ID int64 `json:"id,omitempty"`

	// name
	Name string `json:"name,omitempty"`

	// new state date
	// Format: date-time
	NewStateDate strfmt.DateTime `json:"newStateDate,omitempty"`

	// panel Id
	PanelID int64 `json:"panelId,omitempty"`

	// state
	State AlertStateType `json:"state,omitempty"`

	// url
	URL string `json:"url,omitempty"`
}

// Validate validates this alert list item DTO
func (m *AlertListItemDTO) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateEvalDate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNewStateDate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AlertListItemDTO) validateEvalDate(formats strfmt.Registry) error {
	if swag.IsZero(m.EvalDate) { // not required
		return nil
	}

	if err := validate.FormatOf("evalDate", "body", "date-time", m.EvalDate.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *AlertListItemDTO) validateNewStateDate(formats strfmt.Registry) error {
	if swag.IsZero(m.NewStateDate) { // not required
		return nil
	}

	if err := validate.FormatOf("newStateDate", "body", "date-time", m.NewStateDate.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *AlertListItemDTO) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	if err := m.State.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("state")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("state")
		}
		return err
	}

	return nil
}

// ContextValidate validate this alert list item DTO based on the context it is used
func (m *AlertListItemDTO) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AlertListItemDTO) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if swag.IsZero(m.State) { // not required
		return nil
	}

	if err := m.State.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("state")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("state")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AlertListItemDTO) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AlertListItemDTO) UnmarshalBinary(b []byte) error {
	var res AlertListItemDTO
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
