// Code generated by go-swagger; DO NOT EDIT.

package sync_team_groups

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewRemoveTeamGroupAPIParams creates a new RemoveTeamGroupAPIParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewRemoveTeamGroupAPIParams() *RemoveTeamGroupAPIParams {
	return &RemoveTeamGroupAPIParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewRemoveTeamGroupAPIParamsWithTimeout creates a new RemoveTeamGroupAPIParams object
// with the ability to set a timeout on a request.
func NewRemoveTeamGroupAPIParamsWithTimeout(timeout time.Duration) *RemoveTeamGroupAPIParams {
	return &RemoveTeamGroupAPIParams{
		timeout: timeout,
	}
}

// NewRemoveTeamGroupAPIParamsWithContext creates a new RemoveTeamGroupAPIParams object
// with the ability to set a context for a request.
func NewRemoveTeamGroupAPIParamsWithContext(ctx context.Context) *RemoveTeamGroupAPIParams {
	return &RemoveTeamGroupAPIParams{
		Context: ctx,
	}
}

// NewRemoveTeamGroupAPIParamsWithHTTPClient creates a new RemoveTeamGroupAPIParams object
// with the ability to set a custom HTTPClient for a request.
func NewRemoveTeamGroupAPIParamsWithHTTPClient(client *http.Client) *RemoveTeamGroupAPIParams {
	return &RemoveTeamGroupAPIParams{
		HTTPClient: client,
	}
}

/*
RemoveTeamGroupAPIParams contains all the parameters to send to the API endpoint

	for the remove team group Api operation.

	Typically these are written to a http.Request.
*/
type RemoveTeamGroupAPIParams struct {

	// GroupID.
	GroupID string

	// TeamID.
	//
	// Format: int64
	TeamID int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the remove team group Api params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RemoveTeamGroupAPIParams) WithDefaults() *RemoveTeamGroupAPIParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the remove team group Api params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RemoveTeamGroupAPIParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the remove team group Api params
func (o *RemoveTeamGroupAPIParams) WithTimeout(timeout time.Duration) *RemoveTeamGroupAPIParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the remove team group Api params
func (o *RemoveTeamGroupAPIParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the remove team group Api params
func (o *RemoveTeamGroupAPIParams) WithContext(ctx context.Context) *RemoveTeamGroupAPIParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the remove team group Api params
func (o *RemoveTeamGroupAPIParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the remove team group Api params
func (o *RemoveTeamGroupAPIParams) WithHTTPClient(client *http.Client) *RemoveTeamGroupAPIParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the remove team group Api params
func (o *RemoveTeamGroupAPIParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithGroupID adds the groupID to the remove team group Api params
func (o *RemoveTeamGroupAPIParams) WithGroupID(groupID string) *RemoveTeamGroupAPIParams {
	o.SetGroupID(groupID)
	return o
}

// SetGroupID adds the groupId to the remove team group Api params
func (o *RemoveTeamGroupAPIParams) SetGroupID(groupID string) {
	o.GroupID = groupID
}

// WithTeamID adds the teamID to the remove team group Api params
func (o *RemoveTeamGroupAPIParams) WithTeamID(teamID int64) *RemoveTeamGroupAPIParams {
	o.SetTeamID(teamID)
	return o
}

// SetTeamID adds the teamId to the remove team group Api params
func (o *RemoveTeamGroupAPIParams) SetTeamID(teamID int64) {
	o.TeamID = teamID
}

// WriteToRequest writes these params to a swagger request
func (o *RemoveTeamGroupAPIParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param groupId
	if err := r.SetPathParam("groupId", o.GroupID); err != nil {
		return err
	}

	// path param teamId
	if err := r.SetPathParam("teamId", swag.FormatInt64(o.TeamID)); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
