// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// NewPutMuteTimingParams creates a new PutMuteTimingParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPutMuteTimingParams() *PutMuteTimingParams {
	return &PutMuteTimingParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPutMuteTimingParamsWithTimeout creates a new PutMuteTimingParams object
// with the ability to set a timeout on a request.
func NewPutMuteTimingParamsWithTimeout(timeout time.Duration) *PutMuteTimingParams {
	return &PutMuteTimingParams{
		timeout: timeout,
	}
}

// NewPutMuteTimingParamsWithContext creates a new PutMuteTimingParams object
// with the ability to set a context for a request.
func NewPutMuteTimingParamsWithContext(ctx context.Context) *PutMuteTimingParams {
	return &PutMuteTimingParams{
		Context: ctx,
	}
}

// NewPutMuteTimingParamsWithHTTPClient creates a new PutMuteTimingParams object
// with the ability to set a custom HTTPClient for a request.
func NewPutMuteTimingParamsWithHTTPClient(client *http.Client) *PutMuteTimingParams {
	return &PutMuteTimingParams{
		HTTPClient: client,
	}
}

/*
PutMuteTimingParams contains all the parameters to send to the API endpoint

	for the put mute timing operation.

	Typically these are written to a http.Request.
*/
type PutMuteTimingParams struct {

	// Body.
	Body *models.MuteTimeInterval

	// XDisableProvenance.
	XDisableProvenance *string

	/* Name.

	   Mute timing name
	*/
	Name string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the put mute timing params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PutMuteTimingParams) WithDefaults() *PutMuteTimingParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the put mute timing params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PutMuteTimingParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the put mute timing params
func (o *PutMuteTimingParams) WithTimeout(timeout time.Duration) *PutMuteTimingParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the put mute timing params
func (o *PutMuteTimingParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the put mute timing params
func (o *PutMuteTimingParams) WithContext(ctx context.Context) *PutMuteTimingParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the put mute timing params
func (o *PutMuteTimingParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the put mute timing params
func (o *PutMuteTimingParams) WithHTTPClient(client *http.Client) *PutMuteTimingParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the put mute timing params
func (o *PutMuteTimingParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the put mute timing params
func (o *PutMuteTimingParams) WithBody(body *models.MuteTimeInterval) *PutMuteTimingParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the put mute timing params
func (o *PutMuteTimingParams) SetBody(body *models.MuteTimeInterval) {
	o.Body = body
}

// WithXDisableProvenance adds the xDisableProvenance to the put mute timing params
func (o *PutMuteTimingParams) WithXDisableProvenance(xDisableProvenance *string) *PutMuteTimingParams {
	o.SetXDisableProvenance(xDisableProvenance)
	return o
}

// SetXDisableProvenance adds the xDisableProvenance to the put mute timing params
func (o *PutMuteTimingParams) SetXDisableProvenance(xDisableProvenance *string) {
	o.XDisableProvenance = xDisableProvenance
}

// WithName adds the name to the put mute timing params
func (o *PutMuteTimingParams) WithName(name string) *PutMuteTimingParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the put mute timing params
func (o *PutMuteTimingParams) SetName(name string) {
	o.Name = name
}

// WriteToRequest writes these params to a swagger request
func (o *PutMuteTimingParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if o.XDisableProvenance != nil {

		// header param X-Disable-Provenance
		if err := r.SetHeaderParam("X-Disable-Provenance", *o.XDisableProvenance); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
