// Code generated by go-swagger; DO NOT EDIT.

package datasources

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// UpdateDataSourceByIDReader is a Reader for the UpdateDataSourceByID structure.
type UpdateDataSourceByIDReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateDataSourceByIDReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateDataSourceByIDOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewUpdateDataSourceByIDUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdateDataSourceByIDForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUpdateDataSourceByIDInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PUT /datasources/{id}] updateDataSourceByID", response, response.Code())
	}
}

// NewUpdateDataSourceByIDOK creates a UpdateDataSourceByIDOK with default headers values
func NewUpdateDataSourceByIDOK() *UpdateDataSourceByIDOK {
	return &UpdateDataSourceByIDOK{}
}

/*
UpdateDataSourceByIDOK describes a response with status code 200, with default header values.

(empty)
*/
type UpdateDataSourceByIDOK struct {
	Payload *models.UpdateDataSourceByIDOKBody
}

// IsSuccess returns true when this update data source by Id Ok response has a 2xx status code
func (o *UpdateDataSourceByIDOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update data source by Id Ok response has a 3xx status code
func (o *UpdateDataSourceByIDOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update data source by Id Ok response has a 4xx status code
func (o *UpdateDataSourceByIDOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update data source by Id Ok response has a 5xx status code
func (o *UpdateDataSourceByIDOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update data source by Id Ok response a status code equal to that given
func (o *UpdateDataSourceByIDOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update data source by Id Ok response
func (o *UpdateDataSourceByIDOK) Code() int {
	return 200
}

func (o *UpdateDataSourceByIDOK) Error() string {
	return fmt.Sprintf("[PUT /datasources/{id}][%d] updateDataSourceByIdOk  %+v", 200, o.Payload)
}

func (o *UpdateDataSourceByIDOK) String() string {
	return fmt.Sprintf("[PUT /datasources/{id}][%d] updateDataSourceByIdOk  %+v", 200, o.Payload)
}

func (o *UpdateDataSourceByIDOK) GetPayload() *models.UpdateDataSourceByIDOKBody {
	return o.Payload
}

func (o *UpdateDataSourceByIDOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.UpdateDataSourceByIDOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateDataSourceByIDUnauthorized creates a UpdateDataSourceByIDUnauthorized with default headers values
func NewUpdateDataSourceByIDUnauthorized() *UpdateDataSourceByIDUnauthorized {
	return &UpdateDataSourceByIDUnauthorized{}
}

/*
UpdateDataSourceByIDUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type UpdateDataSourceByIDUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update data source by Id unauthorized response has a 2xx status code
func (o *UpdateDataSourceByIDUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update data source by Id unauthorized response has a 3xx status code
func (o *UpdateDataSourceByIDUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update data source by Id unauthorized response has a 4xx status code
func (o *UpdateDataSourceByIDUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this update data source by Id unauthorized response has a 5xx status code
func (o *UpdateDataSourceByIDUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this update data source by Id unauthorized response a status code equal to that given
func (o *UpdateDataSourceByIDUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the update data source by Id unauthorized response
func (o *UpdateDataSourceByIDUnauthorized) Code() int {
	return 401
}

func (o *UpdateDataSourceByIDUnauthorized) Error() string {
	return fmt.Sprintf("[PUT /datasources/{id}][%d] updateDataSourceByIdUnauthorized  %+v", 401, o.Payload)
}

func (o *UpdateDataSourceByIDUnauthorized) String() string {
	return fmt.Sprintf("[PUT /datasources/{id}][%d] updateDataSourceByIdUnauthorized  %+v", 401, o.Payload)
}

func (o *UpdateDataSourceByIDUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateDataSourceByIDUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateDataSourceByIDForbidden creates a UpdateDataSourceByIDForbidden with default headers values
func NewUpdateDataSourceByIDForbidden() *UpdateDataSourceByIDForbidden {
	return &UpdateDataSourceByIDForbidden{}
}

/*
UpdateDataSourceByIDForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type UpdateDataSourceByIDForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update data source by Id forbidden response has a 2xx status code
func (o *UpdateDataSourceByIDForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update data source by Id forbidden response has a 3xx status code
func (o *UpdateDataSourceByIDForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update data source by Id forbidden response has a 4xx status code
func (o *UpdateDataSourceByIDForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update data source by Id forbidden response has a 5xx status code
func (o *UpdateDataSourceByIDForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update data source by Id forbidden response a status code equal to that given
func (o *UpdateDataSourceByIDForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update data source by Id forbidden response
func (o *UpdateDataSourceByIDForbidden) Code() int {
	return 403
}

func (o *UpdateDataSourceByIDForbidden) Error() string {
	return fmt.Sprintf("[PUT /datasources/{id}][%d] updateDataSourceByIdForbidden  %+v", 403, o.Payload)
}

func (o *UpdateDataSourceByIDForbidden) String() string {
	return fmt.Sprintf("[PUT /datasources/{id}][%d] updateDataSourceByIdForbidden  %+v", 403, o.Payload)
}

func (o *UpdateDataSourceByIDForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateDataSourceByIDForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateDataSourceByIDInternalServerError creates a UpdateDataSourceByIDInternalServerError with default headers values
func NewUpdateDataSourceByIDInternalServerError() *UpdateDataSourceByIDInternalServerError {
	return &UpdateDataSourceByIDInternalServerError{}
}

/*
UpdateDataSourceByIDInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type UpdateDataSourceByIDInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update data source by Id internal server error response has a 2xx status code
func (o *UpdateDataSourceByIDInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update data source by Id internal server error response has a 3xx status code
func (o *UpdateDataSourceByIDInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update data source by Id internal server error response has a 4xx status code
func (o *UpdateDataSourceByIDInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this update data source by Id internal server error response has a 5xx status code
func (o *UpdateDataSourceByIDInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this update data source by Id internal server error response a status code equal to that given
func (o *UpdateDataSourceByIDInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the update data source by Id internal server error response
func (o *UpdateDataSourceByIDInternalServerError) Code() int {
	return 500
}

func (o *UpdateDataSourceByIDInternalServerError) Error() string {
	return fmt.Sprintf("[PUT /datasources/{id}][%d] updateDataSourceByIdInternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateDataSourceByIDInternalServerError) String() string {
	return fmt.Sprintf("[PUT /datasources/{id}][%d] updateDataSourceByIdInternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateDataSourceByIDInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateDataSourceByIDInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
