// Code generated by go-swagger; DO NOT EDIT.

package datasource_permissions

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetAllPermissionsReader is a Reader for the GetAllPermissions structure.
type GetAllPermissionsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetAllPermissionsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetAllPermissionsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewGetAllPermissionsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetAllPermissionsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetAllPermissionsNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetAllPermissionsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /datasources/{datasourceId}/permissions] getAllPermissions", response, response.Code())
	}
}

// NewGetAllPermissionsOK creates a GetAllPermissionsOK with default headers values
func NewGetAllPermissionsOK() *GetAllPermissionsOK {
	return &GetAllPermissionsOK{}
}

/*
GetAllPermissionsOK describes a response with status code 200, with default header values.

(empty)
*/
type GetAllPermissionsOK struct {
	Payload *models.DataSourcePermissionsDTO
}

// IsSuccess returns true when this get all permissions Ok response has a 2xx status code
func (o *GetAllPermissionsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get all permissions Ok response has a 3xx status code
func (o *GetAllPermissionsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get all permissions Ok response has a 4xx status code
func (o *GetAllPermissionsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get all permissions Ok response has a 5xx status code
func (o *GetAllPermissionsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get all permissions Ok response a status code equal to that given
func (o *GetAllPermissionsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get all permissions Ok response
func (o *GetAllPermissionsOK) Code() int {
	return 200
}

func (o *GetAllPermissionsOK) Error() string {
	return fmt.Sprintf("[GET /datasources/{datasourceId}/permissions][%d] getAllPermissionsOk  %+v", 200, o.Payload)
}

func (o *GetAllPermissionsOK) String() string {
	return fmt.Sprintf("[GET /datasources/{datasourceId}/permissions][%d] getAllPermissionsOk  %+v", 200, o.Payload)
}

func (o *GetAllPermissionsOK) GetPayload() *models.DataSourcePermissionsDTO {
	return o.Payload
}

func (o *GetAllPermissionsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataSourcePermissionsDTO)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAllPermissionsUnauthorized creates a GetAllPermissionsUnauthorized with default headers values
func NewGetAllPermissionsUnauthorized() *GetAllPermissionsUnauthorized {
	return &GetAllPermissionsUnauthorized{}
}

/*
GetAllPermissionsUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetAllPermissionsUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get all permissions unauthorized response has a 2xx status code
func (o *GetAllPermissionsUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get all permissions unauthorized response has a 3xx status code
func (o *GetAllPermissionsUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get all permissions unauthorized response has a 4xx status code
func (o *GetAllPermissionsUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get all permissions unauthorized response has a 5xx status code
func (o *GetAllPermissionsUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get all permissions unauthorized response a status code equal to that given
func (o *GetAllPermissionsUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get all permissions unauthorized response
func (o *GetAllPermissionsUnauthorized) Code() int {
	return 401
}

func (o *GetAllPermissionsUnauthorized) Error() string {
	return fmt.Sprintf("[GET /datasources/{datasourceId}/permissions][%d] getAllPermissionsUnauthorized  %+v", 401, o.Payload)
}

func (o *GetAllPermissionsUnauthorized) String() string {
	return fmt.Sprintf("[GET /datasources/{datasourceId}/permissions][%d] getAllPermissionsUnauthorized  %+v", 401, o.Payload)
}

func (o *GetAllPermissionsUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetAllPermissionsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAllPermissionsForbidden creates a GetAllPermissionsForbidden with default headers values
func NewGetAllPermissionsForbidden() *GetAllPermissionsForbidden {
	return &GetAllPermissionsForbidden{}
}

/*
GetAllPermissionsForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetAllPermissionsForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get all permissions forbidden response has a 2xx status code
func (o *GetAllPermissionsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get all permissions forbidden response has a 3xx status code
func (o *GetAllPermissionsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get all permissions forbidden response has a 4xx status code
func (o *GetAllPermissionsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get all permissions forbidden response has a 5xx status code
func (o *GetAllPermissionsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get all permissions forbidden response a status code equal to that given
func (o *GetAllPermissionsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get all permissions forbidden response
func (o *GetAllPermissionsForbidden) Code() int {
	return 403
}

func (o *GetAllPermissionsForbidden) Error() string {
	return fmt.Sprintf("[GET /datasources/{datasourceId}/permissions][%d] getAllPermissionsForbidden  %+v", 403, o.Payload)
}

func (o *GetAllPermissionsForbidden) String() string {
	return fmt.Sprintf("[GET /datasources/{datasourceId}/permissions][%d] getAllPermissionsForbidden  %+v", 403, o.Payload)
}

func (o *GetAllPermissionsForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetAllPermissionsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAllPermissionsNotFound creates a GetAllPermissionsNotFound with default headers values
func NewGetAllPermissionsNotFound() *GetAllPermissionsNotFound {
	return &GetAllPermissionsNotFound{}
}

/*
GetAllPermissionsNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type GetAllPermissionsNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get all permissions not found response has a 2xx status code
func (o *GetAllPermissionsNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get all permissions not found response has a 3xx status code
func (o *GetAllPermissionsNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get all permissions not found response has a 4xx status code
func (o *GetAllPermissionsNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get all permissions not found response has a 5xx status code
func (o *GetAllPermissionsNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get all permissions not found response a status code equal to that given
func (o *GetAllPermissionsNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get all permissions not found response
func (o *GetAllPermissionsNotFound) Code() int {
	return 404
}

func (o *GetAllPermissionsNotFound) Error() string {
	return fmt.Sprintf("[GET /datasources/{datasourceId}/permissions][%d] getAllPermissionsNotFound  %+v", 404, o.Payload)
}

func (o *GetAllPermissionsNotFound) String() string {
	return fmt.Sprintf("[GET /datasources/{datasourceId}/permissions][%d] getAllPermissionsNotFound  %+v", 404, o.Payload)
}

func (o *GetAllPermissionsNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetAllPermissionsNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAllPermissionsInternalServerError creates a GetAllPermissionsInternalServerError with default headers values
func NewGetAllPermissionsInternalServerError() *GetAllPermissionsInternalServerError {
	return &GetAllPermissionsInternalServerError{}
}

/*
GetAllPermissionsInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetAllPermissionsInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get all permissions internal server error response has a 2xx status code
func (o *GetAllPermissionsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get all permissions internal server error response has a 3xx status code
func (o *GetAllPermissionsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get all permissions internal server error response has a 4xx status code
func (o *GetAllPermissionsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get all permissions internal server error response has a 5xx status code
func (o *GetAllPermissionsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get all permissions internal server error response a status code equal to that given
func (o *GetAllPermissionsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get all permissions internal server error response
func (o *GetAllPermissionsInternalServerError) Code() int {
	return 500
}

func (o *GetAllPermissionsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /datasources/{datasourceId}/permissions][%d] getAllPermissionsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetAllPermissionsInternalServerError) String() string {
	return fmt.Sprintf("[GET /datasources/{datasourceId}/permissions][%d] getAllPermissionsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetAllPermissionsInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetAllPermissionsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
