// Code generated by go-swagger; DO NOT EDIT.

package dashboards

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// TrimDashboardReader is a Reader for the TrimDashboard structure.
type TrimDashboardReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *TrimDashboardReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewTrimDashboardOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewTrimDashboardUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewTrimDashboardInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /dashboards/trim] trimDashboard", response, response.Code())
	}
}

// NewTrimDashboardOK creates a TrimDashboardOK with default headers values
func NewTrimDashboardOK() *TrimDashboardOK {
	return &TrimDashboardOK{}
}

/*
TrimDashboardOK describes a response with status code 200, with default header values.

(empty)
*/
type TrimDashboardOK struct {
	Payload *models.TrimDashboardFullWithMeta
}

// IsSuccess returns true when this trim dashboard Ok response has a 2xx status code
func (o *TrimDashboardOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this trim dashboard Ok response has a 3xx status code
func (o *TrimDashboardOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this trim dashboard Ok response has a 4xx status code
func (o *TrimDashboardOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this trim dashboard Ok response has a 5xx status code
func (o *TrimDashboardOK) IsServerError() bool {
	return false
}

// IsCode returns true when this trim dashboard Ok response a status code equal to that given
func (o *TrimDashboardOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the trim dashboard Ok response
func (o *TrimDashboardOK) Code() int {
	return 200
}

func (o *TrimDashboardOK) Error() string {
	return fmt.Sprintf("[POST /dashboards/trim][%d] trimDashboardOk  %+v", 200, o.Payload)
}

func (o *TrimDashboardOK) String() string {
	return fmt.Sprintf("[POST /dashboards/trim][%d] trimDashboardOk  %+v", 200, o.Payload)
}

func (o *TrimDashboardOK) GetPayload() *models.TrimDashboardFullWithMeta {
	return o.Payload
}

func (o *TrimDashboardOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.TrimDashboardFullWithMeta)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTrimDashboardUnauthorized creates a TrimDashboardUnauthorized with default headers values
func NewTrimDashboardUnauthorized() *TrimDashboardUnauthorized {
	return &TrimDashboardUnauthorized{}
}

/*
TrimDashboardUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type TrimDashboardUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this trim dashboard unauthorized response has a 2xx status code
func (o *TrimDashboardUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this trim dashboard unauthorized response has a 3xx status code
func (o *TrimDashboardUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this trim dashboard unauthorized response has a 4xx status code
func (o *TrimDashboardUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this trim dashboard unauthorized response has a 5xx status code
func (o *TrimDashboardUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this trim dashboard unauthorized response a status code equal to that given
func (o *TrimDashboardUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the trim dashboard unauthorized response
func (o *TrimDashboardUnauthorized) Code() int {
	return 401
}

func (o *TrimDashboardUnauthorized) Error() string {
	return fmt.Sprintf("[POST /dashboards/trim][%d] trimDashboardUnauthorized  %+v", 401, o.Payload)
}

func (o *TrimDashboardUnauthorized) String() string {
	return fmt.Sprintf("[POST /dashboards/trim][%d] trimDashboardUnauthorized  %+v", 401, o.Payload)
}

func (o *TrimDashboardUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *TrimDashboardUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTrimDashboardInternalServerError creates a TrimDashboardInternalServerError with default headers values
func NewTrimDashboardInternalServerError() *TrimDashboardInternalServerError {
	return &TrimDashboardInternalServerError{}
}

/*
TrimDashboardInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type TrimDashboardInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this trim dashboard internal server error response has a 2xx status code
func (o *TrimDashboardInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this trim dashboard internal server error response has a 3xx status code
func (o *TrimDashboardInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this trim dashboard internal server error response has a 4xx status code
func (o *TrimDashboardInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this trim dashboard internal server error response has a 5xx status code
func (o *TrimDashboardInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this trim dashboard internal server error response a status code equal to that given
func (o *TrimDashboardInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the trim dashboard internal server error response
func (o *TrimDashboardInternalServerError) Code() int {
	return 500
}

func (o *TrimDashboardInternalServerError) Error() string {
	return fmt.Sprintf("[POST /dashboards/trim][%d] trimDashboardInternalServerError  %+v", 500, o.Payload)
}

func (o *TrimDashboardInternalServerError) String() string {
	return fmt.Sprintf("[POST /dashboards/trim][%d] trimDashboardInternalServerError  %+v", 500, o.Payload)
}

func (o *TrimDashboardInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *TrimDashboardInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
