// Code generated by go-swagger; DO NOT EDIT.

package admin_ldap

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetUserFromLDAPReader is a Reader for the GetUserFromLDAP structure.
type GetUserFromLDAPReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetUserFromLDAPReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetUserFromLDAPOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewGetUserFromLDAPUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetUserFromLDAPForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetUserFromLDAPInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /admin/ldap/{user_name}] getUserFromLDAP", response, response.Code())
	}
}

// NewGetUserFromLDAPOK creates a GetUserFromLDAPOK with default headers values
func NewGetUserFromLDAPOK() *GetUserFromLDAPOK {
	return &GetUserFromLDAPOK{}
}

/*
GetUserFromLDAPOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type GetUserFromLDAPOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this get user from Ldap Ok response has a 2xx status code
func (o *GetUserFromLDAPOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get user from Ldap Ok response has a 3xx status code
func (o *GetUserFromLDAPOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get user from Ldap Ok response has a 4xx status code
func (o *GetUserFromLDAPOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get user from Ldap Ok response has a 5xx status code
func (o *GetUserFromLDAPOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get user from Ldap Ok response a status code equal to that given
func (o *GetUserFromLDAPOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get user from Ldap Ok response
func (o *GetUserFromLDAPOK) Code() int {
	return 200
}

func (o *GetUserFromLDAPOK) Error() string {
	return fmt.Sprintf("[GET /admin/ldap/{user_name}][%d] getUserFromLdapOk  %+v", 200, o.Payload)
}

func (o *GetUserFromLDAPOK) String() string {
	return fmt.Sprintf("[GET /admin/ldap/{user_name}][%d] getUserFromLdapOk  %+v", 200, o.Payload)
}

func (o *GetUserFromLDAPOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *GetUserFromLDAPOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetUserFromLDAPUnauthorized creates a GetUserFromLDAPUnauthorized with default headers values
func NewGetUserFromLDAPUnauthorized() *GetUserFromLDAPUnauthorized {
	return &GetUserFromLDAPUnauthorized{}
}

/*
GetUserFromLDAPUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetUserFromLDAPUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get user from Ldap unauthorized response has a 2xx status code
func (o *GetUserFromLDAPUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get user from Ldap unauthorized response has a 3xx status code
func (o *GetUserFromLDAPUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get user from Ldap unauthorized response has a 4xx status code
func (o *GetUserFromLDAPUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get user from Ldap unauthorized response has a 5xx status code
func (o *GetUserFromLDAPUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get user from Ldap unauthorized response a status code equal to that given
func (o *GetUserFromLDAPUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get user from Ldap unauthorized response
func (o *GetUserFromLDAPUnauthorized) Code() int {
	return 401
}

func (o *GetUserFromLDAPUnauthorized) Error() string {
	return fmt.Sprintf("[GET /admin/ldap/{user_name}][%d] getUserFromLdapUnauthorized  %+v", 401, o.Payload)
}

func (o *GetUserFromLDAPUnauthorized) String() string {
	return fmt.Sprintf("[GET /admin/ldap/{user_name}][%d] getUserFromLdapUnauthorized  %+v", 401, o.Payload)
}

func (o *GetUserFromLDAPUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetUserFromLDAPUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetUserFromLDAPForbidden creates a GetUserFromLDAPForbidden with default headers values
func NewGetUserFromLDAPForbidden() *GetUserFromLDAPForbidden {
	return &GetUserFromLDAPForbidden{}
}

/*
GetUserFromLDAPForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetUserFromLDAPForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get user from Ldap forbidden response has a 2xx status code
func (o *GetUserFromLDAPForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get user from Ldap forbidden response has a 3xx status code
func (o *GetUserFromLDAPForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get user from Ldap forbidden response has a 4xx status code
func (o *GetUserFromLDAPForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get user from Ldap forbidden response has a 5xx status code
func (o *GetUserFromLDAPForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get user from Ldap forbidden response a status code equal to that given
func (o *GetUserFromLDAPForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get user from Ldap forbidden response
func (o *GetUserFromLDAPForbidden) Code() int {
	return 403
}

func (o *GetUserFromLDAPForbidden) Error() string {
	return fmt.Sprintf("[GET /admin/ldap/{user_name}][%d] getUserFromLdapForbidden  %+v", 403, o.Payload)
}

func (o *GetUserFromLDAPForbidden) String() string {
	return fmt.Sprintf("[GET /admin/ldap/{user_name}][%d] getUserFromLdapForbidden  %+v", 403, o.Payload)
}

func (o *GetUserFromLDAPForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetUserFromLDAPForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetUserFromLDAPInternalServerError creates a GetUserFromLDAPInternalServerError with default headers values
func NewGetUserFromLDAPInternalServerError() *GetUserFromLDAPInternalServerError {
	return &GetUserFromLDAPInternalServerError{}
}

/*
GetUserFromLDAPInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetUserFromLDAPInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get user from Ldap internal server error response has a 2xx status code
func (o *GetUserFromLDAPInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get user from Ldap internal server error response has a 3xx status code
func (o *GetUserFromLDAPInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get user from Ldap internal server error response has a 4xx status code
func (o *GetUserFromLDAPInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get user from Ldap internal server error response has a 5xx status code
func (o *GetUserFromLDAPInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get user from Ldap internal server error response a status code equal to that given
func (o *GetUserFromLDAPInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get user from Ldap internal server error response
func (o *GetUserFromLDAPInternalServerError) Code() int {
	return 500
}

func (o *GetUserFromLDAPInternalServerError) Error() string {
	return fmt.Sprintf("[GET /admin/ldap/{user_name}][%d] getUserFromLdapInternalServerError  %+v", 500, o.Payload)
}

func (o *GetUserFromLDAPInternalServerError) String() string {
	return fmt.Sprintf("[GET /admin/ldap/{user_name}][%d] getUserFromLdapInternalServerError  %+v", 500, o.Payload)
}

func (o *GetUserFromLDAPInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetUserFromLDAPInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
