// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"encoding/json"
	"fmt"
)

type ThreatSource string

const (
	ThreatSourceUnknown    ThreatSource = ""
	ThreatSourceCensys     ThreatSource = "censys"
	ThreatSourceRecog      ThreatSource = "recog"
	ThreatSourceWappalyzer ThreatSource = "wappalyzer"
	ThreatSourceThirdParty ThreatSource = "third_party"
)

func (e ThreatSource) ToPointer() *ThreatSource {
	return &e
}
func (e *ThreatSource) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "censys":
		fallthrough
	case "recog":
		fallthrough
	case "wappalyzer":
		fallthrough
	case "third_party":
		*e = ThreatSource(v)
		return nil
	default:
		return fmt.Errorf("invalid value for ThreatSource: %v", v)
	}
}

type Threat struct {
	Actors     []ThreatActor  `json:"actors,omitempty"`
	Confidence *float64       `json:"confidence,omitempty"`
	Details    *ThreatDetails `json:"details,omitempty"`
	Evidence   []Evidence     `json:"evidence,omitempty"`
	ID         *string        `json:"id,omitempty"`
	Malware    *ThreatMalware `json:"malware,omitempty"`
	Name       *string        `json:"name,omitempty"`
	Source     *ThreatSource  `json:"source,omitempty"`
	Tactic     []string       `json:"tactic,omitempty"`
	Type       []string       `json:"type,omitempty"`
}

func (o *Threat) GetActors() []ThreatActor {
	if o == nil {
		return nil
	}
	return o.Actors
}

func (o *Threat) GetConfidence() *float64 {
	if o == nil {
		return nil
	}
	return o.Confidence
}

func (o *Threat) GetDetails() *ThreatDetails {
	if o == nil {
		return nil
	}
	return o.Details
}

func (o *Threat) GetEvidence() []Evidence {
	if o == nil {
		return nil
	}
	return o.Evidence
}

func (o *Threat) GetID() *string {
	if o == nil {
		return nil
	}
	return o.ID
}

func (o *Threat) GetMalware() *ThreatMalware {
	if o == nil {
		return nil
	}
	return o.Malware
}

func (o *Threat) GetName() *string {
	if o == nil {
		return nil
	}
	return o.Name
}

func (o *Threat) GetSource() *ThreatSource {
	if o == nil {
		return nil
	}
	return o.Source
}

func (o *Threat) GetTactic() []string {
	if o == nil {
		return nil
	}
	return o.Tactic
}

func (o *Threat) GetType() []string {
	if o == nil {
		return nil
	}
	return o.Type
}
