// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

type SSHKexInitMessage struct {
	// A list of ssh cipher algorithm identifiers, named according to section 6 of https://www.ietf.org/rfc/rfc4251.txt; see https://www.iana.org/assignments/ssh-parameters/ssh-parameters.xhtml#ssh-parameters-16 for standard values.
	ClientToServerCiphers []string `json:"client_to_server_ciphers,omitempty"`
	// A list of ssh compression algorithm identifiers, named according to section 6 of https://www.ietf.org/rfc/rfc4251.txt; see https://www.iana.org/assignments/ssh-parameters/ssh-parameters.xhtml#ssh-parameters-20 for standard values.
	ClientToServerCompression []string `json:"client_to_server_compression,omitempty"`
	// A name-list of language tags in order of preference. As Defined in https://www.ietf.org/rfc/rfc3066.txt.
	ClientToServerLanguages []string `json:"client_to_server_languages,omitempty"`
	// A list of ssh MAC algorithm identifiers, named according to section 6 of https://www.ietf.org/rfc/rfc4251.txt; see https://www.iana.org/assignments/ssh-parameters/ssh-parameters.xhtml#ssh-parameters-18 for standard values.
	ClientToServerMacs []string `json:"client_to_server_macs,omitempty"`
	FirstKexFollows    *bool    `json:"first_kex_follows,omitempty"`
	// Asymmetric key algorithms for the host key supported by the client.
	HostKeyAlgorithms []string `json:"host_key_algorithms,omitempty"`
	// Key exchange algorithms used in the handshake.
	KexAlgorithms []string `json:"kex_algorithms,omitempty"`
	// A list of ssh cipher algorithm identifiers, named according to section 6 of https://www.ietf.org/rfc/rfc4251.txt; see https://www.iana.org/assignments/ssh-parameters/ssh-parameters.xhtml#ssh-parameters-16 for standard values.
	ServerToClientCiphers []string `json:"server_to_client_ciphers,omitempty"`
	// A list of ssh compression algorithm identifiers, named according to section 6 of https://www.ietf.org/rfc/rfc4251.txt; see https://www.iana.org/assignments/ssh-parameters/ssh-parameters.xhtml#ssh-parameters-20 for standard values.
	ServerToClientCompression []string `json:"server_to_client_compression,omitempty"`
	// A name-list of language tags in order of preference. As Defined in https://www.ietf.org/rfc/rfc3066.txt.
	ServerToClientLanguages []string `json:"server_to_client_languages,omitempty"`
	// A list of ssh MAC algorithm identifiers, named according to section 6 of https://www.ietf.org/rfc/rfc4251.txt; see https://www.iana.org/assignments/ssh-parameters/ssh-parameters.xhtml#ssh-parameters-18 for standard values.
	ServerToClientMacs []string `json:"server_to_client_macs,omitempty"`
}

func (o *SSHKexInitMessage) GetClientToServerCiphers() []string {
	if o == nil {
		return nil
	}
	return o.ClientToServerCiphers
}

func (o *SSHKexInitMessage) GetClientToServerCompression() []string {
	if o == nil {
		return nil
	}
	return o.ClientToServerCompression
}

func (o *SSHKexInitMessage) GetClientToServerLanguages() []string {
	if o == nil {
		return nil
	}
	return o.ClientToServerLanguages
}

func (o *SSHKexInitMessage) GetClientToServerMacs() []string {
	if o == nil {
		return nil
	}
	return o.ClientToServerMacs
}

func (o *SSHKexInitMessage) GetFirstKexFollows() *bool {
	if o == nil {
		return nil
	}
	return o.FirstKexFollows
}

func (o *SSHKexInitMessage) GetHostKeyAlgorithms() []string {
	if o == nil {
		return nil
	}
	return o.HostKeyAlgorithms
}

func (o *SSHKexInitMessage) GetKexAlgorithms() []string {
	if o == nil {
		return nil
	}
	return o.KexAlgorithms
}

func (o *SSHKexInitMessage) GetServerToClientCiphers() []string {
	if o == nil {
		return nil
	}
	return o.ServerToClientCiphers
}

func (o *SSHKexInitMessage) GetServerToClientCompression() []string {
	if o == nil {
		return nil
	}
	return o.ServerToClientCompression
}

func (o *SSHKexInitMessage) GetServerToClientLanguages() []string {
	if o == nil {
		return nil
	}
	return o.ServerToClientLanguages
}

func (o *SSHKexInitMessage) GetServerToClientMacs() []string {
	if o == nil {
		return nil
	}
	return o.ServerToClientMacs
}
