// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// Gives a detailed description of the result of an action on each entry in the
// request.
type BatchResultErrorEntry struct {

	// An error code representing why the action failed on this entry.
	//
	// This member is required.
	Code *string

	// The Id of an entry in a batch request.
	//
	// This member is required.
	Id *string

	// Specifies whether the error happened due to the caller of the batch API action.
	//
	// This member is required.
	SenderFault bool

	// A message explaining why the action failed on this entry.
	Message *string

	noSmithyDocumentSerde
}

// Encloses a receipt handle and an entry id for each message in
// ChangeMessageVisibilityBatch. All of the following list parameters must be
// prefixed with ChangeMessageVisibilityBatchRequestEntry.n, where n is an integer
// value starting with 1. For example, a parameter list for this action might look
// like this:
// &ChangeMessageVisibilityBatchRequestEntry.1.Id=change_visibility_msg_2
//
// &ChangeMessageVisibilityBatchRequestEntry.1.ReceiptHandle=your_receipt_handle
//
//
// &ChangeMessageVisibilityBatchRequestEntry.1.VisibilityTimeout=45
type ChangeMessageVisibilityBatchRequestEntry struct {

	// An identifier for this particular receipt handle used to communicate the result.
	// The Ids of a batch request need to be unique within a request. This identifier
	// can have up to 80 characters. The following characters are accepted:
	// alphanumeric characters, hyphens(-), and underscores (_).
	//
	// This member is required.
	Id *string

	// A receipt handle.
	//
	// This member is required.
	ReceiptHandle *string

	// The new value (in seconds) for the message's visibility timeout.
	VisibilityTimeout int32

	noSmithyDocumentSerde
}

// Encloses the Id of an entry in ChangeMessageVisibilityBatch.
type ChangeMessageVisibilityBatchResultEntry struct {

	// Represents a message whose visibility timeout has been changed successfully.
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

// Encloses a receipt handle and an identifier for it.
type DeleteMessageBatchRequestEntry struct {

	// An identifier for this particular receipt handle. This is used to communicate
	// the result. The Ids of a batch request need to be unique within a request. This
	// identifier can have up to 80 characters. The following characters are accepted:
	// alphanumeric characters, hyphens(-), and underscores (_).
	//
	// This member is required.
	Id *string

	// A receipt handle.
	//
	// This member is required.
	ReceiptHandle *string

	noSmithyDocumentSerde
}

// Encloses the Id of an entry in DeleteMessageBatch.
type DeleteMessageBatchResultEntry struct {

	// Represents a successfully deleted message.
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

// An Amazon SQS message.
type Message struct {

	// A map of the attributes requested in ReceiveMessage to their respective values.
	// Supported attributes:
	//
	// * ApproximateReceiveCount
	//
	// *
	// ApproximateFirstReceiveTimestamp
	//
	// * MessageDeduplicationId
	//
	// * MessageGroupId
	//
	// *
	// SenderId
	//
	// * SentTimestamp
	//
	// * SequenceNumber
	//
	// ApproximateFirstReceiveTimestamp
	// and SentTimestamp are each returned as an integer representing the epoch time
	// (http://en.wikipedia.org/wiki/Unix_time) in milliseconds.
	Attributes map[string]string

	// The message's contents (not URL-encoded).
	Body *string

	// An MD5 digest of the non-URL-encoded message body string.
	MD5OfBody *string

	// An MD5 digest of the non-URL-encoded message attribute string. You can use this
	// attribute to verify that Amazon SQS received the message correctly. Amazon SQS
	// URL-decodes the message before creating the MD5 digest. For information about
	// MD5, see RFC1321 (https://www.ietf.org/rfc/rfc1321.txt).
	MD5OfMessageAttributes *string

	// Each message attribute consists of a Name, Type, and Value. For more
	// information, see Amazon SQS message attributes
	// (https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes)
	// in the Amazon SQS Developer Guide.
	MessageAttributes map[string]MessageAttributeValue

	// A unique identifier for the message. A MessageIdis considered unique across all
	// Amazon Web Services accounts for an extended period of time.
	MessageId *string

	// An identifier associated with the act of receiving the message. A new receipt
	// handle is returned every time you receive a message. When deleting a message,
	// you provide the last received receipt handle to delete the message.
	ReceiptHandle *string

	noSmithyDocumentSerde
}

// The user-specified message attribute value. For string data types, the Value
// attribute has the same restrictions on the content as the message body. For more
// information, see SendMessage.Name, type, value and the message body must not be
// empty or null. All parts of the message attribute, including Name, Type, and
// Value, are part of the message size restriction (256 KB or 262,144 bytes).
type MessageAttributeValue struct {

	// Amazon SQS supports the following logical data types: String, Number, and
	// Binary. For the Number data type, you must use StringValue. You can also append
	// custom labels. For more information, see Amazon SQS Message Attributes
	// (https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes)
	// in the Amazon SQS Developer Guide.
	//
	// This member is required.
	DataType *string

	// Not implemented. Reserved for future use.
	BinaryListValues [][]byte

	// Binary type attributes can store any binary data, such as compressed data,
	// encrypted data, or images.
	BinaryValue []byte

	// Not implemented. Reserved for future use.
	StringListValues []string

	// Strings are Unicode with UTF-8 binary encoding. For a list of code values, see
	// ASCII Printable Characters
	// (http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters).
	StringValue *string

	noSmithyDocumentSerde
}

// The user-specified message system attribute value. For string data types, the
// Value attribute has the same restrictions on the content as the message body.
// For more information, see SendMessage.Name, type, value and the message body
// must not be empty or null.
type MessageSystemAttributeValue struct {

	// Amazon SQS supports the following logical data types: String, Number, and
	// Binary. For the Number data type, you must use StringValue. You can also append
	// custom labels. For more information, see Amazon SQS Message Attributes
	// (https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes)
	// in the Amazon SQS Developer Guide.
	//
	// This member is required.
	DataType *string

	// Not implemented. Reserved for future use.
	BinaryListValues [][]byte

	// Binary type attributes can store any binary data, such as compressed data,
	// encrypted data, or images.
	BinaryValue []byte

	// Not implemented. Reserved for future use.
	StringListValues []string

	// Strings are Unicode with UTF-8 binary encoding. For a list of code values, see
	// ASCII Printable Characters
	// (http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters).
	StringValue *string

	noSmithyDocumentSerde
}

// Contains the details of a single Amazon SQS message along with an Id.
type SendMessageBatchRequestEntry struct {

	// An identifier for a message in this batch used to communicate the result. The
	// Ids of a batch request need to be unique within a request. This identifier can
	// have up to 80 characters. The following characters are accepted: alphanumeric
	// characters, hyphens(-), and underscores (_).
	//
	// This member is required.
	Id *string

	// The body of the message.
	//
	// This member is required.
	MessageBody *string

	// The length of time, in seconds, for which a specific message is delayed. Valid
	// values: 0 to 900. Maximum: 15 minutes. Messages with a positive DelaySeconds
	// value become available for processing after the delay period is finished. If you
	// don't specify a value, the default value for the queue is applied. When you set
	// FifoQueue, you can't set DelaySeconds per message. You can set this parameter
	// only on a queue level.
	DelaySeconds int32

	// Each message attribute consists of a Name, Type, and Value. For more
	// information, see Amazon SQS message attributes
	// (https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes)
	// in the Amazon SQS Developer Guide.
	MessageAttributes map[string]MessageAttributeValue

	// This parameter applies only to FIFO (first-in-first-out) queues. The token used
	// for deduplication of messages within a 5-minute minimum deduplication interval.
	// If a message with a particular MessageDeduplicationId is sent successfully,
	// subsequent messages with the same MessageDeduplicationId are accepted
	// successfully but aren't delivered. For more information, see  Exactly-once
	// processing
	// (https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html)
	// in the Amazon SQS Developer Guide.
	//
	// * Every message must have a unique
	// MessageDeduplicationId,
	//
	// * You may provide a MessageDeduplicationId
	// explicitly.
	//
	// * If you aren't able to provide a MessageDeduplicationId and you
	// enable ContentBasedDeduplication for your queue, Amazon SQS uses a SHA-256 hash
	// to generate the MessageDeduplicationId using the body of the message (but not
	// the attributes of the message).
	//
	// * If you don't provide a MessageDeduplicationId
	// and the queue doesn't have ContentBasedDeduplication set, the action fails with
	// an error.
	//
	// * If the queue has ContentBasedDeduplication set, your
	// MessageDeduplicationId overrides the generated one.
	//
	// * When
	// ContentBasedDeduplication is in effect, messages with identical content sent
	// within the deduplication interval are treated as duplicates and only one copy of
	// the message is delivered.
	//
	// * If you send one message with
	// ContentBasedDeduplication enabled and then another message with a
	// MessageDeduplicationId that is the same as the one generated for the first
	// MessageDeduplicationId, the two messages are treated as duplicates and only one
	// copy of the message is delivered.
	//
	// The MessageDeduplicationId is available to
	// the consumer of the message (this can be useful for troubleshooting delivery
	// issues). If a message is sent successfully but the acknowledgement is lost and
	// the message is resent with the same MessageDeduplicationId after the
	// deduplication interval, Amazon SQS can't detect duplicate messages. Amazon SQS
	// continues to keep track of the message deduplication ID even after the message
	// is received and deleted. The length of MessageDeduplicationId is 128 characters.
	// MessageDeduplicationId can contain alphanumeric characters (a-z, A-Z, 0-9) and
	// punctuation (!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~). For best practices of using
	// MessageDeduplicationId, see Using the MessageDeduplicationId Property
	// (https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagededuplicationid-property.html)
	// in the Amazon SQS Developer Guide.
	MessageDeduplicationId *string

	// This parameter applies only to FIFO (first-in-first-out) queues. The tag that
	// specifies that a message belongs to a specific message group. Messages that
	// belong to the same message group are processed in a FIFO manner (however,
	// messages in different message groups might be processed out of order). To
	// interleave multiple ordered streams within a single queue, use MessageGroupId
	// values (for example, session data for multiple users). In this scenario,
	// multiple consumers can process the queue, but the session data of each user is
	// processed in a FIFO fashion.
	//
	// * You must associate a non-empty MessageGroupId
	// with a message. If you don't provide a MessageGroupId, the action fails.
	//
	// *
	// ReceiveMessage might return messages with multiple MessageGroupId values. For
	// each MessageGroupId, the messages are sorted by time sent. The caller can't
	// specify a MessageGroupId.
	//
	// The length of MessageGroupId is 128 characters. Valid
	// values: alphanumeric characters and punctuation
	// (!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~). For best practices of using MessageGroupId,
	// see Using the MessageGroupId Property
	// (https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagegroupid-property.html)
	// in the Amazon SQS Developer Guide. MessageGroupId is required for FIFO queues.
	// You can't use it for Standard queues.
	MessageGroupId *string

	// The message system attribute to send Each message system attribute consists of a
	// Name, Type, and Value.
	//
	// * Currently, the only supported message system attribute
	// is AWSTraceHeader. Its type must be String and its value must be a correctly
	// formatted X-Ray trace header string.
	//
	// * The size of a message system attribute
	// doesn't count towards the total size of a message.
	MessageSystemAttributes map[string]MessageSystemAttributeValue

	noSmithyDocumentSerde
}

// Encloses a MessageId for a successfully-enqueued message in a SendMessageBatch.
type SendMessageBatchResultEntry struct {

	// An identifier for the message in this batch.
	//
	// This member is required.
	Id *string

	// An MD5 digest of the non-URL-encoded message body string. You can use this
	// attribute to verify that Amazon SQS received the message correctly. Amazon SQS
	// URL-decodes the message before creating the MD5 digest. For information about
	// MD5, see RFC1321 (https://www.ietf.org/rfc/rfc1321.txt).
	//
	// This member is required.
	MD5OfMessageBody *string

	// An identifier for the message.
	//
	// This member is required.
	MessageId *string

	// An MD5 digest of the non-URL-encoded message attribute string. You can use this
	// attribute to verify that Amazon SQS received the message correctly. Amazon SQS
	// URL-decodes the message before creating the MD5 digest. For information about
	// MD5, see RFC1321 (https://www.ietf.org/rfc/rfc1321.txt).
	MD5OfMessageAttributes *string

	// An MD5 digest of the non-URL-encoded message system attribute string. You can
	// use this attribute to verify that Amazon SQS received the message correctly.
	// Amazon SQS URL-decodes the message before creating the MD5 digest. For
	// information about MD5, see RFC1321 (https://www.ietf.org/rfc/rfc1321.txt).
	MD5OfMessageSystemAttributes *string

	// This parameter applies only to FIFO (first-in-first-out) queues. The large,
	// non-consecutive number that Amazon SQS assigns to each message. The length of
	// SequenceNumber is 128 bits. As SequenceNumber continues to increase for a
	// particular MessageGroupId.
	SequenceNumber *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
