package windowsesu

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// OsType enumerates the values for os type.
type OsType string

const (
	// Windows7 ...
	Windows7 OsType = "Windows7"
	// WindowsServer2008 ...
	WindowsServer2008 OsType = "WindowsServer2008"
	// WindowsServer2008R2 ...
	WindowsServer2008R2 OsType = "WindowsServer2008R2"
)

// PossibleOsTypeValues returns an array of possible values for the OsType const type.
func PossibleOsTypeValues() []OsType {
	return []OsType{Windows7, WindowsServer2008, WindowsServer2008R2}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Accepted ...
	Accepted ProvisioningState = "Accepted"
	// Canceled ...
	Canceled ProvisioningState = "Canceled"
	// Failed ...
	Failed ProvisioningState = "Failed"
	// Provisioning ...
	Provisioning ProvisioningState = "Provisioning"
	// Succeeded ...
	Succeeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Accepted, Canceled, Failed, Provisioning, Succeeded}
}

// SupportType enumerates the values for support type.
type SupportType string

const (
	// PremiumAssurance ...
	PremiumAssurance SupportType = "PremiumAssurance"
	// SupplementalServicing ...
	SupplementalServicing SupportType = "SupplementalServicing"
)

// PossibleSupportTypeValues returns an array of possible values for the SupportType const type.
func PossibleSupportTypeValues() []SupportType {
	return []SupportType{PremiumAssurance, SupplementalServicing}
}
