package subscriptions

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ResourceNameStatus enumerates the values for resource name status.
type ResourceNameStatus string

const (
	// Allowed ...
	Allowed ResourceNameStatus = "Allowed"
	// Reserved ...
	Reserved ResourceNameStatus = "Reserved"
)

// PossibleResourceNameStatusValues returns an array of possible values for the ResourceNameStatus const type.
func PossibleResourceNameStatusValues() []ResourceNameStatus {
	return []ResourceNameStatus{Allowed, Reserved}
}

// SpendingLimit enumerates the values for spending limit.
type SpendingLimit string

const (
	// CurrentPeriodOff ...
	CurrentPeriodOff SpendingLimit = "CurrentPeriodOff"
	// Off ...
	Off SpendingLimit = "Off"
	// On ...
	On SpendingLimit = "On"
)

// PossibleSpendingLimitValues returns an array of possible values for the SpendingLimit const type.
func PossibleSpendingLimitValues() []SpendingLimit {
	return []SpendingLimit{CurrentPeriodOff, Off, On}
}

// State enumerates the values for state.
type State string

const (
	// Deleted ...
	Deleted State = "Deleted"
	// Disabled ...
	Disabled State = "Disabled"
	// Enabled ...
	Enabled State = "Enabled"
	// PastDue ...
	PastDue State = "PastDue"
	// Warned ...
	Warned State = "Warned"
)

// PossibleStateValues returns an array of possible values for the State const type.
func PossibleStateValues() []State {
	return []State{Deleted, Disabled, Enabled, PastDue, Warned}
}

// TenantCategory enumerates the values for tenant category.
type TenantCategory string

const (
	// Home ...
	Home TenantCategory = "Home"
	// ManagedBy ...
	ManagedBy TenantCategory = "ManagedBy"
	// ProjectedBy ...
	ProjectedBy TenantCategory = "ProjectedBy"
)

// PossibleTenantCategoryValues returns an array of possible values for the TenantCategory const type.
func PossibleTenantCategoryValues() []TenantCategory {
	return []TenantCategory{Home, ManagedBy, ProjectedBy}
}
