// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package windowsiot

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/windowsiot/mgmt/2019-06-01/windowsiot"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type ServiceNameUnavailabilityReason = original.ServiceNameUnavailabilityReason

const (
	AlreadyExists ServiceNameUnavailabilityReason = original.AlreadyExists
	Invalid       ServiceNameUnavailabilityReason = original.Invalid
)

type BaseClient = original.BaseClient
type DeviceService = original.DeviceService
type DeviceServiceCheckNameAvailabilityParameters = original.DeviceServiceCheckNameAvailabilityParameters
type DeviceServiceDescriptionListResult = original.DeviceServiceDescriptionListResult
type DeviceServiceDescriptionListResultIterator = original.DeviceServiceDescriptionListResultIterator
type DeviceServiceDescriptionListResultPage = original.DeviceServiceDescriptionListResultPage
type DeviceServiceNameAvailabilityInfo = original.DeviceServiceNameAvailabilityInfo
type DeviceServiceProperties = original.DeviceServiceProperties
type ErrorDetails = original.ErrorDetails
type OperationDisplayInfo = original.OperationDisplayInfo
type OperationEntity = original.OperationEntity
type OperationListResult = original.OperationListResult
type OperationListResultIterator = original.OperationListResultIterator
type OperationListResultPage = original.OperationListResultPage
type OperationsClient = original.OperationsClient
type ProxyResource = original.ProxyResource
type Resource = original.Resource
type ServicesClient = original.ServicesClient
type TrackedResource = original.TrackedResource

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewDeviceServiceDescriptionListResultIterator(page DeviceServiceDescriptionListResultPage) DeviceServiceDescriptionListResultIterator {
	return original.NewDeviceServiceDescriptionListResultIterator(page)
}
func NewDeviceServiceDescriptionListResultPage(cur DeviceServiceDescriptionListResult, getNextPage func(context.Context, DeviceServiceDescriptionListResult) (DeviceServiceDescriptionListResult, error)) DeviceServiceDescriptionListResultPage {
	return original.NewDeviceServiceDescriptionListResultPage(cur, getNextPage)
}
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return original.NewOperationListResultIterator(page)
}
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return original.NewOperationListResultPage(cur, getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewServicesClient(subscriptionID string) ServicesClient {
	return original.NewServicesClient(subscriptionID)
}
func NewServicesClientWithBaseURI(baseURI string, subscriptionID string) ServicesClient {
	return original.NewServicesClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleServiceNameUnavailabilityReasonValues() []ServiceNameUnavailabilityReason {
	return original.PossibleServiceNameUnavailabilityReasonValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
