/*
 *  $Id: a_graf_shrinkbox.c,v 1.5 2004/10/04 18:51:33 a_bercegeay Exp $
 */

#include "gem_aesP.h"

/** displays an animated box shrinking from
 *  one rectangle to another.
 *
 *  @param fx x-coordinate of the rectangle to shrink to.
 *  @param fy y-coordinate of the rectangle to shrink to.
 *  @param fw width of the rectangle to shrink to.
 *  @param fh height of the rectangle to shrink to.
 *  @param sx x-coordinate of the rectangle to shrink from
 *  @param sy y-coordinate of the rectangle to shrink from
 *  @param sw width of the rectangle to shrink from
 *  @param sh height of the rectangle to shrink from
 *  @param global_aes global AES array
 *
 *  @return 0 if an error occured or non-zero otherwise.
 *
 *  @since All AES versions.
 *
 *  @sa mt_form_dial(), mt_graf_growbox()

 *  It should be used to provide the
 *  user with a visual 'clue' to an action. It is the
 *  complement function to mt_graf_growbox().
 *
 *  @note There is currently no defined method of handling an error
 *        generated by this function.
 *
 */

short
mt_graf_shrinkbox(short fx, short fy, short fw, short fh,
				  short sx, short sy, short sw, short sh, short *global_aes)
{
	AES_PARAMS(74,8,1,0,0);

	aes_intin[0] = fx;
	aes_intin[1] = fy;
	aes_intin[2] = fw;
	aes_intin[3] = fh;
	aes_intin[4] = sx;
	aes_intin[5] = sy;
	aes_intin[6] = sw;
	aes_intin[7] = sh;

	AES_TRAP(aes_params);

	return aes_intout[0];
}
