/*
 *  $Id: a_graf_mouse.c,v 1.6 2004/09/29 19:18:38 a_bercegeay Exp $
 */

#include "gem_aesP.h"

/** alters the appearance of the mouse form and can be used
 *  to hide and display the mouse pointer from the screen.
 *
 *  @param shape specifies the new form of the mouse pointer, or
 *         specifies an action regarding this form (save, restore,
 *         hide...). See the table hereafter for details.
 *  @param shape_addr a pointer to a ::MFORM structure. If 
 *         \a shape is different than #USER_DEF, \a shape_addr
 *         should be NULL
 *  @param global_aes global AES array
 *
 *  @return 0 if an error occurred or non-zero otherwise.
 *
 *  @since All AES versions. mt_appl_getinfo() with #AES_FORM gives
 *         the availability of #M_SAVE, #M_RESTORE and #M_PREVIOUS modes
 *
 *  @sa vsc_form()
 *
 *  The table hereafter summaries the values that \a shape can take.
 *  <table>
 *  <tr><td> shape <td> value <td> meaning
 *  <tr><td> #ARROW <td> 0 <td>  Change the current mouse cursor shape
 *  <tr><td> #TEXT_CRSR <td> 1 <td>  Change the current mouse cursor shape
 *  <tr><td> #BUSY_BEE <td> 2 <td>  Change the current mouse cursor shape
 *  <tr><td> #POINT_HAND <td> 3 <td>  Change the current mouse cursor shape
 *  <tr><td> #FLAT_HAND <td> 4 <td>  Change the current mouse cursor shape
 *  <tr><td> #THIN_CROSS <td> 5 <td>  Change the current mouse cursor shape
 *  <tr><td> #THICK_CROSS <td> 6 <td>  Change the current mouse cursor shape
 *  <tr><td> #OUTLN_CROSS <td> 7 <td>  Change the current mouse cursor shape
 *  <tr><td> #USER_DEF <td> 255 <td>  Change the current mouse cursor shape
 *  <tr><td> #M_OFF <td> 256 <td>  Remove the mouse cursor from the screen
 *  <tr><td> #M_ON <td> 257 <td>  Display the cursor
 *  <tr><td> #M_SAVE <td> 258 <td>  Save the current mouse form in an AES
 *                                provided buffer. 
 *  <tr><td> #M_RESTORE <td> 259 <td>  Restore the most recently saved mouse form
 *  <tr><td> #M_PREVIOUS <td> 260 <td>  Restore the mouse form to its last shape
 *  </table>
 *
 *	@note As of AES 4.0 and beyond,
 *		  the AES may not allow a mouse
 *		  form to change to benefit another application. If it is
 *		  absolutely necessary for the application to display its
 *		  mouse form, logically OR the \a shape parameter with #M_FORCE
 *		  (0x8000) and make the call.
 *		  This will force the AES to change to your mouse form.
 *		  It should, however, be done within the scope
 *		  of a mt_wind_update() sequence.
 *  @note There is currently no defined method of handling an error
 *        generated by this function.
 *
 */

short
mt_graf_mouse (short shape, const MFORM *shape_addr, short *global_aes)
{
	AES_PARAMS(78,1,1,1,0);

	aes_intin[0] = shape;
	aes_addrin[0] = (long)shape_addr;

	AES_TRAP(aes_params);

	return aes_intout[0];
}
