/*
 *  $Id: a_graf_mbox.c,v 1.5 2004/09/29 19:18:38 a_bercegeay Exp $
 */

#include "gem_aesP.h"

/** animates a moving box between two points on the screen.
 *
 *  @param  w initial width of the box to draw
 *  @param  h initial height of the box to draw.
 *  @param sx starting x-coordinates of the box
 *  @param sy starting y-coordinates of the box.
 *  @param dx ending x-coordinates of the box
 *  @param dy ending y-coordinates of the box
 *  @param global_aes global AES array
 *
 *  @return 0 if an error occured or non-zero otherwise.
 *
 *  @since All AES versions.
 *
 *  @sa mt_graf_slidebox()
 *
 *  It is used to give the user a visual 'clue' to
 *  an action undertaken by the application.
 *
 *  @note There is currently no defined method of handling an error
 *        generated by this function.
 *
 */

short
mt_graf_mbox(short w, short h, short sx, short sy, short dx, short dy, short *global_aes)
{
	AES_PARAMS(72,6,1,0,0);

	aes_intin[0] = w;
	aes_intin[1] = h;
	aes_intin[2] = sx;
	aes_intin[3] = sy;
	aes_intin[4] = dx;
	aes_intin[5] = dy;

	AES_TRAP(aes_params);

	return aes_intout[0];
}
