/*
 * Gearsystem - Sega Master System / Game Gear Emulator
 * Copyright (C) 2013  Ignacio Sanchez

 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see http://www.gnu.org/licenses/ 
 * 
 */

#ifndef OPCODEFDCB_NAMES_H
#define	OPCODEFDCB_NAMES_H

static stOPCodeInfo kOPCodeFDCBNames[256] = {
    { "RLC (IY%+d),B [UNDOC]", 4, 1 },
    { "RLC (IY%+d),C [UNDOC]", 4, 1 },
    { "RLC (IY%+d),D [UNDOC]", 4, 1 },
    { "RLC (IY%+d),E [UNDOC]", 4, 1 },
    { "RLC (IY%+d),H [UNDOC]", 4, 1 },
    { "RLC (IY%+d),L [UNDOC]", 4, 1 },
    { "RLC (IY%+d)", 4, 1 },
    { "RLC (IY%+d),A [UNDOC]", 4, 1 },
    { "RRC (IY%+d),B [UNDOC]", 4, 1 },
    { "RRC (IY%+d),C [UNDOC]", 4, 1 },
    { "RRC (IY%+d),D [UNDOC]", 4, 1 },
    { "RRC (IY%+d),E [UNDOC]", 4, 1 },
    { "RRC (IY%+d),H [UNDOC]", 4, 1 },
    { "RRC (IY%+d),L [UNDOC]", 4, 1 },
    { "RRC (IY%+d)", 4, 1 },
    { "RRC (IY%+d),A [UNDOC]", 4, 1 },

    { "RL (IY%+d),B [UNDOC]", 4, 1 },
    { "RL (IY%+d),C [UNDOC]", 4, 1 },
    { "RL (IY%+d),D [UNDOC]", 4, 1 },
    { "RL (IY%+d),E [UNDOC]", 4, 1 },
    { "RL (IY%+d),H [UNDOC]", 4, 1 },
    { "RL (IY%+d),L [UNDOC]", 4, 1 },
    { "RL (IY%+d)", 4, 1 },
    { "RL (IY%+d),A [UNDOC]", 4, 1 },
    { "RR (IY%+d),B [UNDOC]", 4, 1 },
    { "RR (IY%+d),C [UNDOC]", 4, 1 },
    { "RR (IY%+d),D [UNDOC]", 4, 1 },
    { "RR (IY%+d),E [UNDOC]", 4, 1 },
    { "RR (IY%+d),H [UNDOC]", 4, 1 },
    { "RR (IY%+d),L [UNDOC]", 4, 1 },
    { "RR (IY%+d)", 4, 1 },
    { "RR (IY%+d),A [UNDOC]", 4, 1 },

    { "SLA (IY%+d),B [UNDOC]", 4, 1 },
    { "SLA (IY%+d),C [UNDOC]", 4, 1 },
    { "SLA (IY%+d),D [UNDOC]", 4, 1 },
    { "SLA (IY%+d),E [UNDOC]", 4, 1 },
    { "SLA (IY%+d),H [UNDOC]", 4, 1 },
    { "SLA (IY%+d),L [UNDOC]", 4, 1 },
    { "SLA (IY%+d)", 4, 1 },
    { "SLA (IY%+d),A [UNDOC]", 4, 1 },
    { "SRA (IY%+d),B [UNDOC]", 4, 1 },
    { "SRA (IY%+d),C [UNDOC]", 4, 1 },
    { "SRA (IY%+d),D [UNDOC]", 4, 1 },
    { "SRA (IY%+d),E [UNDOC]", 4, 1 },
    { "SRA (IY%+d),H [UNDOC]", 4, 1 },
    { "SRA (IY%+d),L [UNDOC]", 4, 1 },
    { "SRA (IY%+d)", 4, 1 },
    { "SRA (IY%+d),A [UNDOC]", 4, 1 },

    { "SLL (IY%+d),B [UNDOC]", 4, 1 },
    { "SLL (IY%+d),C [UNDOC]", 4, 1 },
    { "SLL (IY%+d),D [UNDOC]", 4, 1 },
    { "SLL (IY%+d),E [UNDOC]", 4, 1 },
    { "SLL (IY%+d),H [UNDOC]", 4, 1 },
    { "SLL (IY%+d),L [UNDOC]", 4, 1 },
    { "SLL (IY%+d) [UNDOC]", 4, 1 },
    { "SLL (IY%+d),A [UNDOC]", 4, 1 },
    { "SRL (IY%+d),B [UNDOC]", 4, 1 },
    { "SRL (IY%+d),C [UNDOC]", 4, 1 },
    { "SRL (IY%+d),D [UNDOC]", 4, 1 },
    { "SRL (IY%+d),E [UNDOC]", 4, 1 },
    { "SRL (IY%+d),H [UNDOC]", 4, 1 },
    { "SRL (IY%+d),L [UNDOC]", 4, 1 },
    { "SRL (IY%+d)", 4, 1 },
    { "SRL (IY%+d),A [UNDOC]", 4, 1 },

    { "BIT 0,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 0,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 0,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 0,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 0,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 0,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 0,(IY%+d)", 4, 1 },
    { "BIT 0,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 1,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 1,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 1,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 1,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 1,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 1,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 1,(IY%+d)", 4, 1 },
    { "BIT 1,(IY%+d) [UNDOC]", 4, 1 },

    { "BIT 2,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 2,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 2,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 2,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 2,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 2,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 2,(IY%+d)", 4, 1 },
    { "BIT 2,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 3,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 3,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 3,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 3,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 3,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 3,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 3,(IY%+d)", 4, 1 },
    { "BIT 3,(IY%+d) [UNDOC]", 4, 1 },

    { "BIT 4,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 4,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 4,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 4,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 4,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 4,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 4,(IY%+d)", 4, 1 },
    { "BIT 4,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 5,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 5,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 5,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 5,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 5,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 5,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 5,(IY%+d)", 4, 1 },
    { "BIT 5,(IY%+d) [UNDOC]", 4, 1 },

    { "BIT 6,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 6,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 6,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 6,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 6,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 6,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 6,(IY%+d)", 4, 1 },
    { "BIT 6,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 7,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 7,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 7,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 7,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 7,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 7,(IY%+d) [UNDOC]", 4, 1 },
    { "BIT 7,(IY%+d)", 4, 1 },
    { "BIT 7,(IY%+d) [UNDOC]", 4, 1 },

    { "RES 0,(IY%+d),B [UNDOC]", 4, 1 },
    { "RES 0,(IY%+d),C [UNDOC]", 4, 1 },
    { "RES 0,(IY%+d),D [UNDOC]", 4, 1 },
    { "RES 0,(IY%+d),E [UNDOC]", 4, 1 },
    { "RES 0,(IY%+d),H [UNDOC]", 4, 1 },
    { "RES 0,(IY%+d),L [UNDOC]", 4, 1 },
    { "RES 0,(IY%+d)", 4, 1 },
    { "RES 0,(IY%+d),A [UNDOC]", 4, 1 },
    { "RES 1,(IY%+d),B [UNDOC]", 4, 1 },
    { "RES 1,(IY%+d),C [UNDOC]", 4, 1 },
    { "RES 1,(IY%+d),D [UNDOC]", 4, 1 },
    { "RES 1,(IY%+d),E [UNDOC]", 4, 1 },
    { "RES 1,(IY%+d),H [UNDOC]", 4, 1 },
    { "RES 1,(IY%+d),L [UNDOC]", 4, 1 },
    { "RES 1,(IY%+d)", 4, 1 },
    { "RES 1,(IY%+d),A [UNDOC]", 4, 1 },

    { "RES 2,(IY%+d),B [UNDOC]", 4, 1 },
    { "RES 2,(IY%+d),C [UNDOC]", 4, 1 },
    { "RES 2,(IY%+d),D [UNDOC]", 4, 1 },
    { "RES 2,(IY%+d),E [UNDOC]", 4, 1 },
    { "RES 2,(IY%+d),H [UNDOC]", 4, 1 },
    { "RES 2,(IY%+d),L [UNDOC]", 4, 1 },
    { "RES 2,(IY%+d)", 4, 1 },
    { "RES 2,(IY%+d),A [UNDOC]", 4, 1 },
    { "RES 3,(IY%+d),B [UNDOC]", 4, 1 },
    { "RES 3,(IY%+d),C [UNDOC]", 4, 1 },
    { "RES 3,(IY%+d),D [UNDOC]", 4, 1 },
    { "RES 3,(IY%+d),E [UNDOC]", 4, 1 },
    { "RES 3,(IY%+d),H [UNDOC]", 4, 1 },
    { "RES 3,(IY%+d),L [UNDOC]", 4, 1 },
    { "RES 3,(IY%+d)", 4, 1 },
    { "RES 3,(IY%+d),A [UNDOC]", 4, 1 },

    { "RES 4,(IY%+d),B [UNDOC]", 4, 1 },
    { "RES 4,(IY%+d),C [UNDOC]", 4, 1 },
    { "RES 4,(IY%+d),D [UNDOC]", 4, 1 },
    { "RES 4,(IY%+d),E [UNDOC]", 4, 1 },
    { "RES 4,(IY%+d),H [UNDOC]", 4, 1 },
    { "RES 4,(IY%+d),L [UNDOC]", 4, 1 },
    { "RES 4,(IY%+d)", 4, 1 },
    { "RES 4,(IY%+d),A [UNDOC]", 4, 1 },
    { "RES 5,(IY%+d),B [UNDOC]", 4, 1 },
    { "RES 5,(IY%+d),C [UNDOC]", 4, 1 },
    { "RES 5,(IY%+d),D [UNDOC]", 4, 1 },
    { "RES 5,(IY%+d),E [UNDOC]", 4, 1 },
    { "RES 5,(IY%+d),H [UNDOC]", 4, 1 },
    { "RES 5,(IY%+d),L [UNDOC]", 4, 1 },
    { "RES 5,(IY%+d)", 4, 1 },
    { "RES 5,(IY%+d),A [UNDOC]", 4, 1 },

    { "RES 6,(IY%+d),B [UNDOC]", 4, 1 },
    { "RES 6,(IY%+d),C [UNDOC]", 4, 1 },
    { "RES 6,(IY%+d),D [UNDOC]", 4, 1 },
    { "RES 6,(IY%+d),E [UNDOC]", 4, 1 },
    { "RES 6,(IY%+d),H [UNDOC]", 4, 1 },
    { "RES 6,(IY%+d),L [UNDOC]", 4, 1 },
    { "RES 6,(IY%+d)", 4, 1 },
    { "RES 6,(IY%+d),A [UNDOC]", 4, 1 },
    { "RES 7,(IY%+d),B [UNDOC]", 4, 1 },
    { "RES 7,(IY%+d),C [UNDOC]", 4, 1 },
    { "RES 7,(IY%+d),D [UNDOC]", 4, 1 },
    { "RES 7,(IY%+d),E [UNDOC]", 4, 1 },
    { "RES 7,(IY%+d),H [UNDOC]", 4, 1 },
    { "RES 7,(IY%+d),L [UNDOC]", 4, 1 },
    { "RES 7,(IY%+d)", 4, 1 },
    { "RES 7,(IY%+d),A [UNDOC]", 4, 1 },

    { "SET 0,(IY%+d),B [UNDOC]", 4, 1 },
    { "SET 0,(IY%+d),C [UNDOC]", 4, 1 },
    { "SET 0,(IY%+d),D [UNDOC]", 4, 1 },
    { "SET 0,(IY%+d),E [UNDOC]", 4, 1 },
    { "SET 0,(IY%+d),H [UNDOC]", 4, 1 },
    { "SET 0,(IY%+d),L [UNDOC]", 4, 1 },
    { "SET 0,(IY%+d)", 4, 1 },
    { "SET 0,(IY%+d),A [UNDOC]", 4, 1 },
    { "SET 1,(IY%+d),B [UNDOC]", 4, 1 },
    { "SET 1,(IY%+d),C [UNDOC]", 4, 1 },
    { "SET 1,(IY%+d),D [UNDOC]", 4, 1 },
    { "SET 1,(IY%+d),E [UNDOC]", 4, 1 },
    { "SET 1,(IY%+d),H [UNDOC]", 4, 1 },
    { "SET 1,(IY%+d),L [UNDOC]", 4, 1 },
    { "SET 1,(IY%+d)", 4, 1 },
    { "SET 1,(IY%+d),A [UNDOC]", 4, 1 },

    { "SET 2,(IY%+d),B [UNDOC]", 4, 1 },
    { "SET 2,(IY%+d),C [UNDOC]", 4, 1 },
    { "SET 2,(IY%+d),D [UNDOC]", 4, 1 },
    { "SET 2,(IY%+d),E [UNDOC]", 4, 1 },
    { "SET 2,(IY%+d),H [UNDOC]", 4, 1 },
    { "SET 2,(IY%+d),L [UNDOC]", 4, 1 },
    { "SET 2,(IY%+d)", 4, 1 },
    { "SET 2,(IY%+d),A [UNDOC]", 4, 1 },
    { "SET 3,(IY%+d),B [UNDOC]", 4, 1 },
    { "SET 3,(IY%+d),C [UNDOC]", 4, 1 },
    { "SET 3,(IY%+d),D [UNDOC]", 4, 1 },
    { "SET 3,(IY%+d),E [UNDOC]", 4, 1 },
    { "SET 3,(IY%+d),H [UNDOC]", 4, 1 },
    { "SET 3,(IY%+d),L [UNDOC]", 4, 1 },
    { "SET 3,(IY%+d)", 4, 1 },
    { "SET 3,(IY%+d),A [UNDOC]", 4, 1 },

    { "SET 4,(IY%+d),B [UNDOC]", 4, 1 },
    { "SET 4,(IY%+d),C [UNDOC]", 4, 1 },
    { "SET 4,(IY%+d),D [UNDOC]", 4, 1 },
    { "SET 4,(IY%+d),E [UNDOC]", 4, 1 },
    { "SET 4,(IY%+d),H [UNDOC]", 4, 1 },
    { "SET 4,(IY%+d),L [UNDOC]", 4, 1 },
    { "SET 4,(IY%+d)", 4, 1 },
    { "SET 4,(IY%+d),A [UNDOC]", 4, 1 },
    { "SET 5,(IY%+d),B [UNDOC]", 4, 1 },
    { "SET 5,(IY%+d),C [UNDOC]", 4, 1 },
    { "SET 5,(IY%+d),D [UNDOC]", 4, 1 },
    { "SET 5,(IY%+d),E [UNDOC]", 4, 1 },
    { "SET 5,(IY%+d),H [UNDOC]", 4, 1 },
    { "SET 5,(IY%+d),L [UNDOC]", 4, 1 },
    { "SET 5,(IY%+d)", 4, 1 },
    { "SET 5,(IY%+d),A [UNDOC]", 4, 1 },

    { "SET 6,(IY%+d),B [UNDOC]", 4, 1 },
    { "SET 6,(IY%+d),C [UNDOC]", 4, 1 },
    { "SET 6,(IY%+d),D [UNDOC]", 4, 1 },
    { "SET 6,(IY%+d),E [UNDOC]", 4, 1 },
    { "SET 6,(IY%+d),H [UNDOC]", 4, 1 },
    { "SET 6,(IY%+d),L [UNDOC]", 4, 1 },
    { "SET 6,(IY%+d)", 4, 1 },
    { "SET 6,(IY%+d),A [UNDOC]", 4, 1 },
    { "SET 7,(IY%+d),B [UNDOC]", 4, 1 },
    { "SET 7,(IY%+d),C [UNDOC]", 4, 1 },
    { "SET 7,(IY%+d),D [UNDOC]", 4, 1 },
    { "SET 7,(IY%+d),E [UNDOC]", 4, 1 },
    { "SET 7,(IY%+d),H [UNDOC]", 4, 1 },
    { "SET 7,(IY%+d),L [UNDOC]", 4, 1 },
    { "SET 7,(IY%+d)", 4, 1 },
    { "SET 7,(IY%+d),A [UNDOC]", 4, 1 }
};

#endif	/* OPCODEFDCB_NAMES_H */

