/*
 * Gearsystem - Sega Master System / Game Gear Emulator
 * Copyright (C) 2013  Ignacio Sanchez

 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see http://www.gnu.org/licenses/ 
 * 
 */

#ifndef OPCODE_TIMING_H
#define	OPCODE_TIMING_H

const u8 kOPCodeTStates[256] =
{
/*          0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F */
/* 0x00 */  4,10, 7, 6, 4, 4, 7, 4, 4,11, 7, 6, 4, 4, 7, 4,
/* 0x10 */  8,10, 7, 6, 4, 4, 7, 4,12,11, 7, 6, 4, 4, 7, 4,
/* 0x20 */  7,10,16, 6, 4, 4, 7, 4, 7,11,16, 6, 4, 4, 7, 4,
/* 0x30 */  7,10,13, 6,11,11,10, 4, 7,11,13, 6, 4, 4, 7, 4,
/* 0x40 */  4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4,
/* 0x50 */  4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4,
/* 0x60 */  4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4,
/* 0x70 */  7, 7, 7, 7, 7, 7, 4, 7, 4, 4, 4, 4, 4, 4, 7, 4,
/* 0x80 */  4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4,
/* 0x90 */  4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4,
/* 0xA0 */  4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4,
/* 0xB0 */  4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4,
/* 0xC0 */  5,10,10,10,10,11, 7,11, 5,10,10, 0,10,17, 7,11,
/* 0xD0 */  5,10,10,11,10,11, 7,11, 5, 4,10,11,10, 0, 7,11,
/* 0xE0 */  5,10,10,19,10,11, 7,11, 5, 4,10, 4,10, 0, 7,11,
/* 0xF0 */  5,10,10, 4,10,11, 7,11, 5, 6,10, 4,10, 0, 7,11
};

const u8 kOPCodeTStatesBranched[256] =
{
/*          0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F */
/* 0x00 */  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
/* 0x10 */  5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
/* 0x20 */  5, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0,
/* 0x30 */  5, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0,
/* 0x40 */  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
/* 0x50 */  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
/* 0x60 */  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
/* 0x70 */  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
/* 0x80 */  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
/* 0x90 */  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
/* 0xA0 */  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
/* 0xB0 */  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
/* 0xC0 */  6, 0, 0, 0, 7, 0, 0, 0, 6, 0, 0, 0, 7, 0, 0, 0,
/* 0xD0 */  6, 0, 0, 0, 7, 0, 0, 0, 6, 0, 0, 0, 7, 0, 0, 0,
/* 0xE0 */  6, 0, 0, 0, 7, 0, 0, 0, 6, 0, 0, 0, 7, 0, 0, 0,
/* 0xF0 */  6, 0, 0, 0, 7, 0, 0, 0, 6, 0, 0, 0, 7, 0, 0, 0
};

const u8 kOPCodeCBTStates[256] =
{
/*          0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F */
/* 0x00 */  8, 8, 8, 8, 8, 8,15, 8, 8, 8, 8, 8, 8, 8,15, 8,
/* 0x10 */  8, 8, 8, 8, 8, 8,15, 8, 8, 8, 8, 8, 8, 8,15, 8,
/* 0x20 */  8, 8, 8, 8, 8, 8,15, 8, 8, 8, 8, 8, 8, 8,15, 8,
/* 0x30 */  8, 8, 8, 8, 8, 8,15, 8, 8, 8, 8, 8, 8, 8,15, 8,
/* 0x40 */  8, 8, 8, 8, 8, 8,12, 8, 8, 8, 8, 8, 8, 8,12, 8,
/* 0x50 */  8, 8, 8, 8, 8, 8,12, 8, 8, 8, 8, 8, 8, 8,12, 8,
/* 0x60 */  8, 8, 8, 8, 8, 8,12, 8, 8, 8, 8, 8, 8, 8,12, 8,
/* 0x70 */  8, 8, 8, 8, 8, 8,12, 8, 8, 8, 8, 8, 8, 8,12, 8,
/* 0x80 */  8, 8, 8, 8, 8, 8,15, 8, 8, 8, 8, 8, 8, 8,15, 8,
/* 0x90 */  8, 8, 8, 8, 8, 8,15, 8, 8, 8, 8, 8, 8, 8,15, 8,
/* 0xA0 */  8, 8, 8, 8, 8, 8,15, 8, 8, 8, 8, 8, 8, 8,15, 8,
/* 0xB0 */  8, 8, 8, 8, 8, 8,15, 8, 8, 8, 8, 8, 8, 8,15, 8,
/* 0xC0 */  8, 8, 8, 8, 8, 8,15, 8, 8, 8, 8, 8, 8, 8,15, 8,
/* 0xD0 */  8, 8, 8, 8, 8, 8,15, 8, 8, 8, 8, 8, 8, 8,15, 8,
/* 0xE0 */  8, 8, 8, 8, 8, 8,15, 8, 8, 8, 8, 8, 8, 8,15, 8,
/* 0xF0 */  8, 8, 8, 8, 8, 8,15, 8, 8, 8, 8, 8, 8, 8,15, 8 
};

const u8 kOPCodeEDTStates[256] = 
{
/*          0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F */
/* 0x00 */  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
/* 0x10 */  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
/* 0x20 */  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
/* 0x30 */  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
/* 0x40 */ 12,12,15,20, 8,14, 8, 9,12,12,15,20, 8,14, 8, 9,
/* 0x50 */ 12,12,15,20, 8,14, 8, 9,12,12,15,20, 8,14, 8, 9,
/* 0x60 */ 12,12,15,20, 8,14, 8,18,12,12,15,20, 8,14, 8,18,
/* 0x70 */ 12,12,15,20, 8,14, 8, 8,12,12,15,20, 8,14, 8, 8,
/* 0x80 */  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
/* 0x90 */  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
/* 0xA0 */ 16,16,16,16, 8, 8, 8, 8,16,16,16,16, 8, 8, 8, 8,
/* 0xB0 */ 16,16,16,16, 8, 8, 8, 8,16,16,16,16, 8, 8, 8, 8,
/* 0xC0 */  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
/* 0xD0 */  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
/* 0xE0 */  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
/* 0xF0 */  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8
};

const u8 kOPCodeXYTStates[256] = 
{
/*          0   1    2    3    4    5    6    7    8    9    A    B    C    D    E    F   */                  
/* 0x00 */  4+4,10+4, 7+4, 6+4, 4+4, 4+4, 7+4, 4+4, 4+4,11+4, 7+4, 6+4, 4+4, 4+4, 7+4, 4+4,
/* 0x10 */  8+4,10+4, 7+4, 6+4, 4+4, 4+4, 7+4, 4+4,12+4,11+4, 7+4, 6+4, 4+4, 4+4, 7+4, 4+4,
/* 0x20 */  7+4,10+4,16+4, 6+4, 4+4, 4+4, 7+4, 4+4, 7+4,11+4,16+4, 6+4, 4+4, 4+4, 7+4, 4+4,
/* 0x30 */  7+4,10+4,13+4, 6+4, 23 , 23 , 19 , 4+4, 7+4,11+4,13+4, 6+4, 4+4, 4+4, 7+4, 4+4,
/* 0x40 */  4+4, 4+4, 4+4, 4+4, 4+4, 4+4, 19 , 4+4, 4+4, 4+4, 4+4, 4+4, 4+4, 4+4,19  , 4+4,
/* 0x50 */  4+4, 4+4, 4+4, 4+4, 4+4, 4+4, 19 , 4+4, 4+4, 4+4, 4+4, 4+4, 4+4, 4+4,19  , 4+4,
/* 0x60 */  4+4, 4+4, 4+4, 4+4, 4+4, 4+4, 19 , 4+4, 4+4, 4+4, 4+4, 4+4, 4+4, 4+4,19  , 4+4,
/* 0x70 */  19 , 19 , 19 , 19 , 19 , 19 , 4+4, 19 , 4+4, 4+4, 4+4, 4+4, 4+4, 4+4,19  , 4+4,
/* 0x80 */  4+4, 4+4, 4+4, 4+4, 4+4, 4+4,19  , 4+4, 4+4, 4+4, 4+4, 4+4, 4+4, 4+4,19  , 4+4,
/* 0x90 */  4+4, 4+4, 4+4, 4+4, 4+4, 4+4,19  , 4+4, 4+4, 4+4, 4+4, 4+4, 4+4, 4+4,19  , 4+4,
/* 0xA0 */  4+4, 4+4, 4+4, 4+4, 4+4, 4+4,19  , 4+4, 4+4, 4+4, 4+4, 4+4, 4+4, 4+4,19  , 4+4,
/* 0xB0 */  4+4, 4+4, 4+4, 4+4, 4+4, 4+4,19  , 4+4, 4+4, 4+4, 4+4, 4+4, 4+4, 4+4,19  , 4+4,
/* 0xC0 */  5+4,10+4,10+4,10+4,10+4,11+4, 7+4,11+4, 5+4,10+4,10+4, 0  ,10+4,17+4, 7+4,11+4,
/* 0xD0 */  5+4,10+4,10+4,11+4,10+4,11+4, 7+4,11+4, 5+4, 4+4,10+4,11+4,10+4, 4  , 7+4,11+4,
/* 0xE0 */  5+4,10+4,10+4,19+4,10+4,11+4, 7+4,11+4, 5+4, 4+4,10+4, 4+4,10+4, 4  , 7+4,11+4,
/* 0xF0 */  5+4,10+4,10+4, 4+4,10+4,11+4, 7+4,11+4, 5+4, 6+4,10+4, 4+4,10+4, 4  , 7+4,11+4 
};

const u8 kOPCodeXYCBTStates[256] = 
{
/*          0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F */
/* 0x00 */  23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
/* 0x10 */  23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
/* 0x20 */  23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
/* 0x30 */  23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
/* 0x40 */  20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,
/* 0x50 */  20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,
/* 0x60 */  20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,
/* 0x70 */  20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,
/* 0x80 */  23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
/* 0x90 */  23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
/* 0xA0 */  23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
/* 0xB0 */  23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
/* 0xC0 */  23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
/* 0xD0 */  23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
/* 0xE0 */  23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
/* 0xF0 */  23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23
};

#endif	/* OPCODE_TIMING_H */

