/*
 * Gearsystem - Sega Master System / Game Gear Emulator
 * Copyright (C) 2013  Ignacio Sanchez

 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see http://www.gnu.org/licenses/ 
 * 
 */

#ifndef OPCODE_DAA_H
#define	OPCODE_DAA_H

const u16 kOPCodeDAATable[0x800] ={
    (0x00 << 8) + FLAG_ZERO + FLAG_PARITY,
    (0x01 << 8),
    (0x02 << 8),
    (0x03 << 8) + FLAG_PARITY,
    (0x04 << 8),
    (0x05 << 8) + FLAG_PARITY,
    (0x06 << 8) + FLAG_PARITY,
    (0x07 << 8),
    (0x08 << 8) + FLAG_X,
    (0x09 << 8) + FLAG_X + FLAG_PARITY,
    (0x10 << 8) + FLAG_HALF,
    (0x11 << 8) + FLAG_HALF + FLAG_PARITY,
    (0x12 << 8) + FLAG_HALF + FLAG_PARITY,
    (0x13 << 8) + FLAG_HALF,
    (0x14 << 8) + FLAG_HALF + FLAG_PARITY,
    (0x15 << 8) + FLAG_HALF,
    (0x10 << 8),
    (0x11 << 8) + FLAG_PARITY,
    (0x12 << 8) + FLAG_PARITY,
    (0x13 << 8),
    (0x14 << 8) + FLAG_PARITY,
    (0x15 << 8),
    (0x16 << 8),
    (0x17 << 8) + FLAG_PARITY,
    (0x18 << 8) + FLAG_X + FLAG_PARITY,
    (0x19 << 8) + FLAG_X,
    (0x20 << 8) + FLAG_Y + FLAG_HALF,
    (0x21 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY,
    (0x22 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY,
    (0x23 << 8) + FLAG_Y + FLAG_HALF,
    (0x24 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY,
    (0x25 << 8) + FLAG_Y + FLAG_HALF,
    (0x20 << 8) + FLAG_Y,
    (0x21 << 8) + FLAG_Y + FLAG_PARITY,
    (0x22 << 8) + FLAG_Y + FLAG_PARITY,
    (0x23 << 8) + FLAG_Y,
    (0x24 << 8) + FLAG_Y + FLAG_PARITY,
    (0x25 << 8) + FLAG_Y,
    (0x26 << 8) + FLAG_Y,
    (0x27 << 8) + FLAG_Y + FLAG_PARITY,
    (0x28 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY,
    (0x29 << 8) + FLAG_Y + FLAG_X,
    (0x30 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY,
    (0x31 << 8) + FLAG_Y + FLAG_HALF,
    (0x32 << 8) + FLAG_Y + FLAG_HALF,
    (0x33 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY,
    (0x34 << 8) + FLAG_Y + FLAG_HALF,
    (0x35 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY,
    (0x30 << 8) + FLAG_Y + FLAG_PARITY,
    (0x31 << 8) + FLAG_Y,
    (0x32 << 8) + FLAG_Y,
    (0x33 << 8) + FLAG_Y + FLAG_PARITY,
    (0x34 << 8) + FLAG_Y,
    (0x35 << 8) + FLAG_Y + FLAG_PARITY,
    (0x36 << 8) + FLAG_Y + FLAG_PARITY,
    (0x37 << 8) + FLAG_Y,
    (0x38 << 8) + FLAG_Y + FLAG_X,
    (0x39 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY,
    (0x40 << 8) + FLAG_HALF,
    (0x41 << 8) + FLAG_HALF + FLAG_PARITY,
    (0x42 << 8) + FLAG_HALF + FLAG_PARITY,
    (0x43 << 8) + FLAG_HALF,
    (0x44 << 8) + FLAG_HALF + FLAG_PARITY,
    (0x45 << 8) + FLAG_HALF,
    (0x40 << 8),
    (0x41 << 8) + FLAG_PARITY,
    (0x42 << 8) + FLAG_PARITY,
    (0x43 << 8),
    (0x44 << 8) + FLAG_PARITY,
    (0x45 << 8),
    (0x46 << 8),
    (0x47 << 8) + FLAG_PARITY,
    (0x48 << 8) + FLAG_X + FLAG_PARITY,
    (0x49 << 8) + FLAG_X,
    (0x50 << 8) + FLAG_HALF + FLAG_PARITY,
    (0x51 << 8) + FLAG_HALF,
    (0x52 << 8) + FLAG_HALF,
    (0x53 << 8) + FLAG_HALF + FLAG_PARITY,
    (0x54 << 8) + FLAG_HALF,
    (0x55 << 8) + FLAG_HALF + FLAG_PARITY,
    (0x50 << 8) + FLAG_PARITY,
    (0x51 << 8),
    (0x52 << 8),
    (0x53 << 8) + FLAG_PARITY,
    (0x54 << 8),
    (0x55 << 8) + FLAG_PARITY,
    (0x56 << 8) + FLAG_PARITY,
    (0x57 << 8),
    (0x58 << 8) + FLAG_X,
    (0x59 << 8) + FLAG_X + FLAG_PARITY,
    (0x60 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY,
    (0x61 << 8) + FLAG_Y + FLAG_HALF,
    (0x62 << 8) + FLAG_Y + FLAG_HALF,
    (0x63 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY,
    (0x64 << 8) + FLAG_Y + FLAG_HALF,
    (0x65 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY,
    (0x60 << 8) + FLAG_Y + FLAG_PARITY,
    (0x61 << 8) + FLAG_Y,
    (0x62 << 8) + FLAG_Y,
    (0x63 << 8) + FLAG_Y + FLAG_PARITY,
    (0x64 << 8) + FLAG_Y,
    (0x65 << 8) + FLAG_Y + FLAG_PARITY,
    (0x66 << 8) + FLAG_Y + FLAG_PARITY,
    (0x67 << 8) + FLAG_Y,
    (0x68 << 8) + FLAG_Y + FLAG_X,
    (0x69 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY,
    (0x70 << 8) + FLAG_Y + FLAG_HALF,
    (0x71 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY,
    (0x72 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY,
    (0x73 << 8) + FLAG_Y + FLAG_HALF,
    (0x74 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY,
    (0x75 << 8) + FLAG_Y + FLAG_HALF,
    (0x70 << 8) + FLAG_Y,
    (0x71 << 8) + FLAG_Y + FLAG_PARITY,
    (0x72 << 8) + FLAG_Y + FLAG_PARITY,
    (0x73 << 8) + FLAG_Y,
    (0x74 << 8) + FLAG_Y + FLAG_PARITY,
    (0x75 << 8) + FLAG_Y,
    (0x76 << 8) + FLAG_Y,
    (0x77 << 8) + FLAG_Y + FLAG_PARITY,
    (0x78 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY,
    (0x79 << 8) + FLAG_Y + FLAG_X,
    (0x80 << 8) + FLAG_SIGN + FLAG_HALF,
    (0x81 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY,
    (0x82 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY,
    (0x83 << 8) + FLAG_SIGN + FLAG_HALF,
    (0x84 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY,
    (0x85 << 8) + FLAG_SIGN + FLAG_HALF,
    (0x80 << 8) + FLAG_SIGN,
    (0x81 << 8) + FLAG_SIGN + FLAG_PARITY,
    (0x82 << 8) + FLAG_SIGN + FLAG_PARITY,
    (0x83 << 8) + FLAG_SIGN,
    (0x84 << 8) + FLAG_SIGN + FLAG_PARITY,
    (0x85 << 8) + FLAG_SIGN,
    (0x86 << 8) + FLAG_SIGN,
    (0x87 << 8) + FLAG_SIGN + FLAG_PARITY,
    (0x88 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY,
    (0x89 << 8) + FLAG_SIGN + FLAG_X,
    (0x90 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY,
    (0x91 << 8) + FLAG_SIGN + FLAG_HALF,
    (0x92 << 8) + FLAG_SIGN + FLAG_HALF,
    (0x93 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY,
    (0x94 << 8) + FLAG_SIGN + FLAG_HALF,
    (0x95 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY,
    (0x90 << 8) + FLAG_SIGN + FLAG_PARITY,
    (0x91 << 8) + FLAG_SIGN,
    (0x92 << 8) + FLAG_SIGN,
    (0x93 << 8) + FLAG_SIGN + FLAG_PARITY,
    (0x94 << 8) + FLAG_SIGN,
    (0x95 << 8) + FLAG_SIGN + FLAG_PARITY,
    (0x96 << 8) + FLAG_SIGN + FLAG_PARITY,
    (0x97 << 8) + FLAG_SIGN,
    (0x98 << 8) + FLAG_SIGN + FLAG_X,
    (0x99 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY,
    (0x00 << 8) + FLAG_ZERO + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x01 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x02 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x03 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x04 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x05 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x00 << 8) + FLAG_ZERO + FLAG_PARITY + FLAG_CARRY,
    (0x01 << 8) + FLAG_CARRY,
    (0x02 << 8) + FLAG_CARRY,
    (0x03 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x04 << 8) + FLAG_CARRY,
    (0x05 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x06 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x07 << 8) + FLAG_CARRY,
    (0x08 << 8) + FLAG_X + FLAG_CARRY,
    (0x09 << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x10 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x11 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x12 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x13 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x14 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x15 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x10 << 8) + FLAG_CARRY,
    (0x11 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x12 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x13 << 8) + FLAG_CARRY,
    (0x14 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x15 << 8) + FLAG_CARRY,
    (0x16 << 8) + FLAG_CARRY,
    (0x17 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x18 << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x19 << 8) + FLAG_X + FLAG_CARRY,
    (0x20 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x21 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x22 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x23 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x24 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x25 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x20 << 8) + FLAG_Y + FLAG_CARRY,
    (0x21 << 8) + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0x22 << 8) + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0x23 << 8) + FLAG_Y + FLAG_CARRY,
    (0x24 << 8) + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0x25 << 8) + FLAG_Y + FLAG_CARRY,
    (0x26 << 8) + FLAG_Y + FLAG_CARRY,
    (0x27 << 8) + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0x28 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x29 << 8) + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0x30 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x31 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x32 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x33 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x34 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x35 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x30 << 8) + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0x31 << 8) + FLAG_Y + FLAG_CARRY,
    (0x32 << 8) + FLAG_Y + FLAG_CARRY,
    (0x33 << 8) + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0x34 << 8) + FLAG_Y + FLAG_CARRY,
    (0x35 << 8) + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0x36 << 8) + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0x37 << 8) + FLAG_Y + FLAG_CARRY,
    (0x38 << 8) + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0x39 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x40 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x41 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x42 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x43 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x44 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x45 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x40 << 8) + FLAG_CARRY,
    (0x41 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x42 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x43 << 8) + FLAG_CARRY,
    (0x44 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x45 << 8) + FLAG_CARRY,
    (0x46 << 8) + FLAG_CARRY,
    (0x47 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x48 << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x49 << 8) + FLAG_X + FLAG_CARRY,
    (0x50 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x51 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x52 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x53 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x54 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x55 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x50 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x51 << 8) + FLAG_CARRY,
    (0x52 << 8) + FLAG_CARRY,
    (0x53 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x54 << 8) + FLAG_CARRY,
    (0x55 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x56 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x57 << 8) + FLAG_CARRY,
    (0x58 << 8) + FLAG_X + FLAG_CARRY,
    (0x59 << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x60 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x61 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x62 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x63 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x64 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x65 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x60 << 8) + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0x61 << 8) + FLAG_Y + FLAG_CARRY,
    (0x62 << 8) + FLAG_Y + FLAG_CARRY,
    (0x63 << 8) + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0x64 << 8) + FLAG_Y + FLAG_CARRY,
    (0x65 << 8) + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0x66 << 8) + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0x67 << 8) + FLAG_Y + FLAG_CARRY,
    (0x68 << 8) + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0x69 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x70 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x71 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x72 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x73 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x74 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x75 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x70 << 8) + FLAG_Y + FLAG_CARRY,
    (0x71 << 8) + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0x72 << 8) + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0x73 << 8) + FLAG_Y + FLAG_CARRY,
    (0x74 << 8) + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0x75 << 8) + FLAG_Y + FLAG_CARRY,
    (0x76 << 8) + FLAG_Y + FLAG_CARRY,
    (0x77 << 8) + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0x78 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x79 << 8) + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0x80 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_CARRY,
    (0x81 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x82 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x83 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_CARRY,
    (0x84 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x85 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_CARRY,
    (0x80 << 8) + FLAG_SIGN + FLAG_CARRY,
    (0x81 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_CARRY,
    (0x82 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_CARRY,
    (0x83 << 8) + FLAG_SIGN + FLAG_CARRY,
    (0x84 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_CARRY,
    (0x85 << 8) + FLAG_SIGN + FLAG_CARRY,
    (0x86 << 8) + FLAG_SIGN + FLAG_CARRY,
    (0x87 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_CARRY,
    (0x88 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x89 << 8) + FLAG_SIGN + FLAG_X + FLAG_CARRY,
    (0x90 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x91 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_CARRY,
    (0x92 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_CARRY,
    (0x93 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x94 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_CARRY,
    (0x95 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x90 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_CARRY,
    (0x91 << 8) + FLAG_SIGN + FLAG_CARRY,
    (0x92 << 8) + FLAG_SIGN + FLAG_CARRY,
    (0x93 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_CARRY,
    (0x94 << 8) + FLAG_SIGN + FLAG_CARRY,
    (0x95 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_CARRY,
    (0x96 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_CARRY,
    (0x97 << 8) + FLAG_SIGN + FLAG_CARRY,
    (0x98 << 8) + FLAG_SIGN + FLAG_X + FLAG_CARRY,
    (0x99 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0xA0 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xA1 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0xA2 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0xA3 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xA4 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0xA5 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xA0 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0xA1 << 8) + FLAG_SIGN + FLAG_Y + FLAG_CARRY,
    (0xA2 << 8) + FLAG_SIGN + FLAG_Y + FLAG_CARRY,
    (0xA3 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0xA4 << 8) + FLAG_SIGN + FLAG_Y + FLAG_CARRY,
    (0xA5 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0xA6 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0xA7 << 8) + FLAG_SIGN + FLAG_Y + FLAG_CARRY,
    (0xA8 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0xA9 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0xB0 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0xB1 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xB2 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xB3 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0xB4 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xB5 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0xB0 << 8) + FLAG_SIGN + FLAG_Y + FLAG_CARRY,
    (0xB1 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0xB2 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0xB3 << 8) + FLAG_SIGN + FLAG_Y + FLAG_CARRY,
    (0xB4 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0xB5 << 8) + FLAG_SIGN + FLAG_Y + FLAG_CARRY,
    (0xB6 << 8) + FLAG_SIGN + FLAG_Y + FLAG_CARRY,
    (0xB7 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0xB8 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0xB9 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0xC0 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xC1 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_CARRY,
    (0xC2 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_CARRY,
    (0xC3 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xC4 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_CARRY,
    (0xC5 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xC0 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_CARRY,
    (0xC1 << 8) + FLAG_SIGN + FLAG_CARRY,
    (0xC2 << 8) + FLAG_SIGN + FLAG_CARRY,
    (0xC3 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_CARRY,
    (0xC4 << 8) + FLAG_SIGN + FLAG_CARRY,
    (0xC5 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_CARRY,
    (0xC6 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_CARRY,
    (0xC7 << 8) + FLAG_SIGN + FLAG_CARRY,
    (0xC8 << 8) + FLAG_SIGN + FLAG_X + FLAG_CARRY,
    (0xC9 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0xD0 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_CARRY,
    (0xD1 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xD2 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xD3 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_CARRY,
    (0xD4 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xD5 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_CARRY,
    (0xD0 << 8) + FLAG_SIGN + FLAG_CARRY,
    (0xD1 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_CARRY,
    (0xD2 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_CARRY,
    (0xD3 << 8) + FLAG_SIGN + FLAG_CARRY,
    (0xD4 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_CARRY,
    (0xD5 << 8) + FLAG_SIGN + FLAG_CARRY,
    (0xD6 << 8) + FLAG_SIGN + FLAG_CARRY,
    (0xD7 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_CARRY,
    (0xD8 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0xD9 << 8) + FLAG_SIGN + FLAG_X + FLAG_CARRY,
    (0xE0 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0xE1 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xE2 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xE3 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0xE4 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xE5 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0xE0 << 8) + FLAG_SIGN + FLAG_Y + FLAG_CARRY,
    (0xE1 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0xE2 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0xE3 << 8) + FLAG_SIGN + FLAG_Y + FLAG_CARRY,
    (0xE4 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0xE5 << 8) + FLAG_SIGN + FLAG_Y + FLAG_CARRY,
    (0xE6 << 8) + FLAG_SIGN + FLAG_Y + FLAG_CARRY,
    (0xE7 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0xE8 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0xE9 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0xF0 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xF1 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0xF2 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0xF3 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xF4 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0xF5 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xF0 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0xF1 << 8) + FLAG_SIGN + FLAG_Y + FLAG_CARRY,
    (0xF2 << 8) + FLAG_SIGN + FLAG_Y + FLAG_CARRY,
    (0xF3 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0xF4 << 8) + FLAG_SIGN + FLAG_Y + FLAG_CARRY,
    (0xF5 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0xF6 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0xF7 << 8) + FLAG_SIGN + FLAG_Y + FLAG_CARRY,
    (0xF8 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0xF9 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x00 << 8) + FLAG_ZERO + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x01 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x02 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x03 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x04 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x05 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x00 << 8) + FLAG_ZERO + FLAG_PARITY + FLAG_CARRY,
    (0x01 << 8) + FLAG_CARRY,
    (0x02 << 8) + FLAG_CARRY,
    (0x03 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x04 << 8) + FLAG_CARRY,
    (0x05 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x06 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x07 << 8) + FLAG_CARRY,
    (0x08 << 8) + FLAG_X + FLAG_CARRY,
    (0x09 << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x10 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x11 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x12 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x13 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x14 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x15 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x10 << 8) + FLAG_CARRY,
    (0x11 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x12 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x13 << 8) + FLAG_CARRY,
    (0x14 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x15 << 8) + FLAG_CARRY,
    (0x16 << 8) + FLAG_CARRY,
    (0x17 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x18 << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x19 << 8) + FLAG_X + FLAG_CARRY,
    (0x20 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x21 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x22 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x23 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x24 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x25 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x20 << 8) + FLAG_Y + FLAG_CARRY,
    (0x21 << 8) + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0x22 << 8) + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0x23 << 8) + FLAG_Y + FLAG_CARRY,
    (0x24 << 8) + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0x25 << 8) + FLAG_Y + FLAG_CARRY,
    (0x26 << 8) + FLAG_Y + FLAG_CARRY,
    (0x27 << 8) + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0x28 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x29 << 8) + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0x30 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x31 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x32 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x33 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x34 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x35 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x30 << 8) + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0x31 << 8) + FLAG_Y + FLAG_CARRY,
    (0x32 << 8) + FLAG_Y + FLAG_CARRY,
    (0x33 << 8) + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0x34 << 8) + FLAG_Y + FLAG_CARRY,
    (0x35 << 8) + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0x36 << 8) + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0x37 << 8) + FLAG_Y + FLAG_CARRY,
    (0x38 << 8) + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0x39 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x40 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x41 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x42 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x43 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x44 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x45 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x40 << 8) + FLAG_CARRY,
    (0x41 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x42 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x43 << 8) + FLAG_CARRY,
    (0x44 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x45 << 8) + FLAG_CARRY,
    (0x46 << 8) + FLAG_CARRY,
    (0x47 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x48 << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x49 << 8) + FLAG_X + FLAG_CARRY,
    (0x50 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x51 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x52 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x53 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x54 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x55 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x50 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x51 << 8) + FLAG_CARRY,
    (0x52 << 8) + FLAG_CARRY,
    (0x53 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x54 << 8) + FLAG_CARRY,
    (0x55 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x56 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x57 << 8) + FLAG_CARRY,
    (0x58 << 8) + FLAG_X + FLAG_CARRY,
    (0x59 << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x60 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x61 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x62 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x63 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x64 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x65 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x06 << 8) + FLAG_PARITY,
    (0x07 << 8),
    (0x08 << 8) + FLAG_X,
    (0x09 << 8) + FLAG_X + FLAG_PARITY,
    (0x0A << 8) + FLAG_X + FLAG_PARITY,
    (0x0B << 8) + FLAG_X,
    (0x0C << 8) + FLAG_X + FLAG_PARITY,
    (0x0D << 8) + FLAG_X,
    (0x0E << 8) + FLAG_X,
    (0x0F << 8) + FLAG_X + FLAG_PARITY,
    (0x10 << 8) + FLAG_HALF,
    (0x11 << 8) + FLAG_HALF + FLAG_PARITY,
    (0x12 << 8) + FLAG_HALF + FLAG_PARITY,
    (0x13 << 8) + FLAG_HALF,
    (0x14 << 8) + FLAG_HALF + FLAG_PARITY,
    (0x15 << 8) + FLAG_HALF,
    (0x16 << 8),
    (0x17 << 8) + FLAG_PARITY,
    (0x18 << 8) + FLAG_X + FLAG_PARITY,
    (0x19 << 8) + FLAG_X,
    (0x1A << 8) + FLAG_X,
    (0x1B << 8) + FLAG_X + FLAG_PARITY,
    (0x1C << 8) + FLAG_X,
    (0x1D << 8) + FLAG_X + FLAG_PARITY,
    (0x1E << 8) + FLAG_X + FLAG_PARITY,
    (0x1F << 8) + FLAG_X,
    (0x20 << 8) + FLAG_Y + FLAG_HALF,
    (0x21 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY,
    (0x22 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY,
    (0x23 << 8) + FLAG_Y + FLAG_HALF,
    (0x24 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY,
    (0x25 << 8) + FLAG_Y + FLAG_HALF,
    (0x26 << 8) + FLAG_Y,
    (0x27 << 8) + FLAG_Y + FLAG_PARITY,
    (0x28 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY,
    (0x29 << 8) + FLAG_Y + FLAG_X,
    (0x2A << 8) + FLAG_Y + FLAG_X,
    (0x2B << 8) + FLAG_Y + FLAG_X + FLAG_PARITY,
    (0x2C << 8) + FLAG_Y + FLAG_X,
    (0x2D << 8) + FLAG_Y + FLAG_X + FLAG_PARITY,
    (0x2E << 8) + FLAG_Y + FLAG_X + FLAG_PARITY,
    (0x2F << 8) + FLAG_Y + FLAG_X,
    (0x30 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY,
    (0x31 << 8) + FLAG_Y + FLAG_HALF,
    (0x32 << 8) + FLAG_Y + FLAG_HALF,
    (0x33 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY,
    (0x34 << 8) + FLAG_Y + FLAG_HALF,
    (0x35 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY,
    (0x36 << 8) + FLAG_Y + FLAG_PARITY,
    (0x37 << 8) + FLAG_Y,
    (0x38 << 8) + FLAG_Y + FLAG_X,
    (0x39 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY,
    (0x3A << 8) + FLAG_Y + FLAG_X + FLAG_PARITY,
    (0x3B << 8) + FLAG_Y + FLAG_X,
    (0x3C << 8) + FLAG_Y + FLAG_X + FLAG_PARITY,
    (0x3D << 8) + FLAG_Y + FLAG_X,
    (0x3E << 8) + FLAG_Y + FLAG_X,
    (0x3F << 8) + FLAG_Y + FLAG_X + FLAG_PARITY,
    (0x40 << 8) + FLAG_HALF,
    (0x41 << 8) + FLAG_HALF + FLAG_PARITY,
    (0x42 << 8) + FLAG_HALF + FLAG_PARITY,
    (0x43 << 8) + FLAG_HALF,
    (0x44 << 8) + FLAG_HALF + FLAG_PARITY,
    (0x45 << 8) + FLAG_HALF,
    (0x46 << 8),
    (0x47 << 8) + FLAG_PARITY,
    (0x48 << 8) + FLAG_X + FLAG_PARITY,
    (0x49 << 8) + FLAG_X,
    (0x4A << 8) + FLAG_X,
    (0x4B << 8) + FLAG_X + FLAG_PARITY,
    (0x4C << 8) + FLAG_X,
    (0x4D << 8) + FLAG_X + FLAG_PARITY,
    (0x4E << 8) + FLAG_X + FLAG_PARITY,
    (0x4F << 8) + FLAG_X,
    (0x50 << 8) + FLAG_HALF + FLAG_PARITY,
    (0x51 << 8) + FLAG_HALF,
    (0x52 << 8) + FLAG_HALF,
    (0x53 << 8) + FLAG_HALF + FLAG_PARITY,
    (0x54 << 8) + FLAG_HALF,
    (0x55 << 8) + FLAG_HALF + FLAG_PARITY,
    (0x56 << 8) + FLAG_PARITY,
    (0x57 << 8),
    (0x58 << 8) + FLAG_X,
    (0x59 << 8) + FLAG_X + FLAG_PARITY,
    (0x5A << 8) + FLAG_X + FLAG_PARITY,
    (0x5B << 8) + FLAG_X,
    (0x5C << 8) + FLAG_X + FLAG_PARITY,
    (0x5D << 8) + FLAG_X,
    (0x5E << 8) + FLAG_X,
    (0x5F << 8) + FLAG_X + FLAG_PARITY,
    (0x60 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY,
    (0x61 << 8) + FLAG_Y + FLAG_HALF,
    (0x62 << 8) + FLAG_Y + FLAG_HALF,
    (0x63 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY,
    (0x64 << 8) + FLAG_Y + FLAG_HALF,
    (0x65 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY,
    (0x66 << 8) + FLAG_Y + FLAG_PARITY,
    (0x67 << 8) + FLAG_Y,
    (0x68 << 8) + FLAG_Y + FLAG_X,
    (0x69 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY,
    (0x6A << 8) + FLAG_Y + FLAG_X + FLAG_PARITY,
    (0x6B << 8) + FLAG_Y + FLAG_X,
    (0x6C << 8) + FLAG_Y + FLAG_X + FLAG_PARITY,
    (0x6D << 8) + FLAG_Y + FLAG_X,
    (0x6E << 8) + FLAG_Y + FLAG_X,
    (0x6F << 8) + FLAG_Y + FLAG_X + FLAG_PARITY,
    (0x70 << 8) + FLAG_Y + FLAG_HALF,
    (0x71 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY,
    (0x72 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY,
    (0x73 << 8) + FLAG_Y + FLAG_HALF,
    (0x74 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY,
    (0x75 << 8) + FLAG_Y + FLAG_HALF,
    (0x76 << 8) + FLAG_Y,
    (0x77 << 8) + FLAG_Y + FLAG_PARITY,
    (0x78 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY,
    (0x79 << 8) + FLAG_Y + FLAG_X,
    (0x7A << 8) + FLAG_Y + FLAG_X,
    (0x7B << 8) + FLAG_Y + FLAG_X + FLAG_PARITY,
    (0x7C << 8) + FLAG_Y + FLAG_X,
    (0x7D << 8) + FLAG_Y + FLAG_X + FLAG_PARITY,
    (0x7E << 8) + FLAG_Y + FLAG_X + FLAG_PARITY,
    (0x7F << 8) + FLAG_Y + FLAG_X,
    (0x80 << 8) + FLAG_SIGN + FLAG_HALF,
    (0x81 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY,
    (0x82 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY,
    (0x83 << 8) + FLAG_SIGN + FLAG_HALF,
    (0x84 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY,
    (0x85 << 8) + FLAG_SIGN + FLAG_HALF,
    (0x86 << 8) + FLAG_SIGN,
    (0x87 << 8) + FLAG_SIGN + FLAG_PARITY,
    (0x88 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY,
    (0x89 << 8) + FLAG_SIGN + FLAG_X,
    (0x8A << 8) + FLAG_SIGN + FLAG_X,
    (0x8B << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY,
    (0x8C << 8) + FLAG_SIGN + FLAG_X,
    (0x8D << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY,
    (0x8E << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY,
    (0x8F << 8) + FLAG_SIGN + FLAG_X,
    (0x90 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY,
    (0x91 << 8) + FLAG_SIGN + FLAG_HALF,
    (0x92 << 8) + FLAG_SIGN + FLAG_HALF,
    (0x93 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY,
    (0x94 << 8) + FLAG_SIGN + FLAG_HALF,
    (0x95 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY,
    (0x96 << 8) + FLAG_SIGN + FLAG_PARITY,
    (0x97 << 8) + FLAG_SIGN,
    (0x98 << 8) + FLAG_SIGN + FLAG_X,
    (0x99 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY,
    (0x9A << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY,
    (0x9B << 8) + FLAG_SIGN + FLAG_X,
    (0x9C << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY,
    (0x9D << 8) + FLAG_SIGN + FLAG_X,
    (0x9E << 8) + FLAG_SIGN + FLAG_X,
    (0x9F << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY,
    (0x00 << 8) + FLAG_ZERO + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x01 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x02 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x03 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x04 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x05 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x06 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x07 << 8) + FLAG_CARRY,
    (0x08 << 8) + FLAG_X + FLAG_CARRY,
    (0x09 << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x0A << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x0B << 8) + FLAG_X + FLAG_CARRY,
    (0x0C << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x0D << 8) + FLAG_X + FLAG_CARRY,
    (0x0E << 8) + FLAG_X + FLAG_CARRY,
    (0x0F << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x10 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x11 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x12 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x13 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x14 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x15 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x16 << 8) + FLAG_CARRY,
    (0x17 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x18 << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x19 << 8) + FLAG_X + FLAG_CARRY,
    (0x1A << 8) + FLAG_X + FLAG_CARRY,
    (0x1B << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x1C << 8) + FLAG_X + FLAG_CARRY,
    (0x1D << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x1E << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x1F << 8) + FLAG_X + FLAG_CARRY,
    (0x20 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x21 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x22 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x23 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x24 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x25 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x26 << 8) + FLAG_Y + FLAG_CARRY,
    (0x27 << 8) + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0x28 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x29 << 8) + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0x2A << 8) + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0x2B << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x2C << 8) + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0x2D << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x2E << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x2F << 8) + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0x30 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x31 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x32 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x33 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x34 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x35 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x36 << 8) + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0x37 << 8) + FLAG_Y + FLAG_CARRY,
    (0x38 << 8) + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0x39 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x3A << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x3B << 8) + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0x3C << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x3D << 8) + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0x3E << 8) + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0x3F << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x40 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x41 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x42 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x43 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x44 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x45 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x46 << 8) + FLAG_CARRY,
    (0x47 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x48 << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x49 << 8) + FLAG_X + FLAG_CARRY,
    (0x4A << 8) + FLAG_X + FLAG_CARRY,
    (0x4B << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x4C << 8) + FLAG_X + FLAG_CARRY,
    (0x4D << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x4E << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x4F << 8) + FLAG_X + FLAG_CARRY,
    (0x50 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x51 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x52 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x53 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x54 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x55 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x56 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x57 << 8) + FLAG_CARRY,
    (0x58 << 8) + FLAG_X + FLAG_CARRY,
    (0x59 << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x5A << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x5B << 8) + FLAG_X + FLAG_CARRY,
    (0x5C << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x5D << 8) + FLAG_X + FLAG_CARRY,
    (0x5E << 8) + FLAG_X + FLAG_CARRY,
    (0x5F << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x60 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x61 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x62 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x63 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x64 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x65 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x66 << 8) + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0x67 << 8) + FLAG_Y + FLAG_CARRY,
    (0x68 << 8) + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0x69 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x6A << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x6B << 8) + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0x6C << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x6D << 8) + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0x6E << 8) + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0x6F << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x70 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x71 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x72 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x73 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x74 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x75 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x76 << 8) + FLAG_Y + FLAG_CARRY,
    (0x77 << 8) + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0x78 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x79 << 8) + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0x7A << 8) + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0x7B << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x7C << 8) + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0x7D << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x7E << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x7F << 8) + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0x80 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_CARRY,
    (0x81 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x82 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x83 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_CARRY,
    (0x84 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x85 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_CARRY,
    (0x86 << 8) + FLAG_SIGN + FLAG_CARRY,
    (0x87 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_CARRY,
    (0x88 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x89 << 8) + FLAG_SIGN + FLAG_X + FLAG_CARRY,
    (0x8A << 8) + FLAG_SIGN + FLAG_X + FLAG_CARRY,
    (0x8B << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x8C << 8) + FLAG_SIGN + FLAG_X + FLAG_CARRY,
    (0x8D << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x8E << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x8F << 8) + FLAG_SIGN + FLAG_X + FLAG_CARRY,
    (0x90 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x91 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_CARRY,
    (0x92 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_CARRY,
    (0x93 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x94 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_CARRY,
    (0x95 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x96 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_CARRY,
    (0x97 << 8) + FLAG_SIGN + FLAG_CARRY,
    (0x98 << 8) + FLAG_SIGN + FLAG_X + FLAG_CARRY,
    (0x99 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x9A << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x9B << 8) + FLAG_SIGN + FLAG_X + FLAG_CARRY,
    (0x9C << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x9D << 8) + FLAG_SIGN + FLAG_X + FLAG_CARRY,
    (0x9E << 8) + FLAG_SIGN + FLAG_X + FLAG_CARRY,
    (0x9F << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0xA0 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xA1 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0xA2 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0xA3 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xA4 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0xA5 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xA6 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0xA7 << 8) + FLAG_SIGN + FLAG_Y + FLAG_CARRY,
    (0xA8 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0xA9 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0xAA << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0xAB << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0xAC << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0xAD << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0xAE << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0xAF << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0xB0 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0xB1 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xB2 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xB3 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0xB4 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xB5 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0xB6 << 8) + FLAG_SIGN + FLAG_Y + FLAG_CARRY,
    (0xB7 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0xB8 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0xB9 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0xBA << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0xBB << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0xBC << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0xBD << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0xBE << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0xBF << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0xC0 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xC1 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_CARRY,
    (0xC2 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_CARRY,
    (0xC3 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xC4 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_CARRY,
    (0xC5 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xC6 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_CARRY,
    (0xC7 << 8) + FLAG_SIGN + FLAG_CARRY,
    (0xC8 << 8) + FLAG_SIGN + FLAG_X + FLAG_CARRY,
    (0xC9 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0xCA << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0xCB << 8) + FLAG_SIGN + FLAG_X + FLAG_CARRY,
    (0xCC << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0xCD << 8) + FLAG_SIGN + FLAG_X + FLAG_CARRY,
    (0xCE << 8) + FLAG_SIGN + FLAG_X + FLAG_CARRY,
    (0xCF << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0xD0 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_CARRY,
    (0xD1 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xD2 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xD3 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_CARRY,
    (0xD4 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xD5 << 8) + FLAG_SIGN + FLAG_HALF + FLAG_CARRY,
    (0xD6 << 8) + FLAG_SIGN + FLAG_CARRY,
    (0xD7 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_CARRY,
    (0xD8 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0xD9 << 8) + FLAG_SIGN + FLAG_X + FLAG_CARRY,
    (0xDA << 8) + FLAG_SIGN + FLAG_X + FLAG_CARRY,
    (0xDB << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0xDC << 8) + FLAG_SIGN + FLAG_X + FLAG_CARRY,
    (0xDD << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0xDE << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0xDF << 8) + FLAG_SIGN + FLAG_X + FLAG_CARRY,
    (0xE0 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0xE1 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xE2 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xE3 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0xE4 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xE5 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0xE6 << 8) + FLAG_SIGN + FLAG_Y + FLAG_CARRY,
    (0xE7 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0xE8 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0xE9 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0xEA << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0xEB << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0xEC << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0xED << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0xEE << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0xEF << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0xF0 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xF1 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0xF2 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0xF3 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xF4 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0xF5 << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0xF6 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0xF7 << 8) + FLAG_SIGN + FLAG_Y + FLAG_CARRY,
    (0xF8 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0xF9 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0xFA << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0xFB << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0xFC << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0xFD << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0xFE << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0xFF << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x00 << 8) + FLAG_ZERO + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x01 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x02 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x03 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x04 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x05 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x06 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x07 << 8) + FLAG_CARRY,
    (0x08 << 8) + FLAG_X + FLAG_CARRY,
    (0x09 << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x0A << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x0B << 8) + FLAG_X + FLAG_CARRY,
    (0x0C << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x0D << 8) + FLAG_X + FLAG_CARRY,
    (0x0E << 8) + FLAG_X + FLAG_CARRY,
    (0x0F << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x10 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x11 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x12 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x13 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x14 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x15 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x16 << 8) + FLAG_CARRY,
    (0x17 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x18 << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x19 << 8) + FLAG_X + FLAG_CARRY,
    (0x1A << 8) + FLAG_X + FLAG_CARRY,
    (0x1B << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x1C << 8) + FLAG_X + FLAG_CARRY,
    (0x1D << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x1E << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x1F << 8) + FLAG_X + FLAG_CARRY,
    (0x20 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x21 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x22 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x23 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x24 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x25 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x26 << 8) + FLAG_Y + FLAG_CARRY,
    (0x27 << 8) + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0x28 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x29 << 8) + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0x2A << 8) + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0x2B << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x2C << 8) + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0x2D << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x2E << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x2F << 8) + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0x30 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x31 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x32 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x33 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x34 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x35 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x36 << 8) + FLAG_Y + FLAG_PARITY + FLAG_CARRY,
    (0x37 << 8) + FLAG_Y + FLAG_CARRY,
    (0x38 << 8) + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0x39 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x3A << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x3B << 8) + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0x3C << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x3D << 8) + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0x3E << 8) + FLAG_Y + FLAG_X + FLAG_CARRY,
    (0x3F << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x40 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x41 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x42 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x43 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x44 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x45 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x46 << 8) + FLAG_CARRY,
    (0x47 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x48 << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x49 << 8) + FLAG_X + FLAG_CARRY,
    (0x4A << 8) + FLAG_X + FLAG_CARRY,
    (0x4B << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x4C << 8) + FLAG_X + FLAG_CARRY,
    (0x4D << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x4E << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x4F << 8) + FLAG_X + FLAG_CARRY,
    (0x50 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x51 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x52 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x53 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x54 << 8) + FLAG_HALF + FLAG_CARRY,
    (0x55 << 8) + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x56 << 8) + FLAG_PARITY + FLAG_CARRY,
    (0x57 << 8) + FLAG_CARRY,
    (0x58 << 8) + FLAG_X + FLAG_CARRY,
    (0x59 << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x5A << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x5B << 8) + FLAG_X + FLAG_CARRY,
    (0x5C << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x5D << 8) + FLAG_X + FLAG_CARRY,
    (0x5E << 8) + FLAG_X + FLAG_CARRY,
    (0x5F << 8) + FLAG_X + FLAG_PARITY + FLAG_CARRY,
    (0x60 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x61 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x62 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x63 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x64 << 8) + FLAG_Y + FLAG_HALF + FLAG_CARRY,
    (0x65 << 8) + FLAG_Y + FLAG_HALF + FLAG_PARITY + FLAG_CARRY,
    (0x00 << 8) + FLAG_ZERO + FLAG_PARITY + FLAG_NEGATIVE,
    (0x01 << 8) + FLAG_NEGATIVE,
    (0x02 << 8) + FLAG_NEGATIVE,
    (0x03 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x04 << 8) + FLAG_NEGATIVE,
    (0x05 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x06 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x07 << 8) + FLAG_NEGATIVE,
    (0x08 << 8) + FLAG_X + FLAG_NEGATIVE,
    (0x09 << 8) + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x04 << 8) + FLAG_NEGATIVE,
    (0x05 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x06 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x07 << 8) + FLAG_NEGATIVE,
    (0x08 << 8) + FLAG_X + FLAG_NEGATIVE,
    (0x09 << 8) + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x10 << 8) + FLAG_NEGATIVE,
    (0x11 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x12 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x13 << 8) + FLAG_NEGATIVE,
    (0x14 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x15 << 8) + FLAG_NEGATIVE,
    (0x16 << 8) + FLAG_NEGATIVE,
    (0x17 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x18 << 8) + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x19 << 8) + FLAG_X + FLAG_NEGATIVE,
    (0x14 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x15 << 8) + FLAG_NEGATIVE,
    (0x16 << 8) + FLAG_NEGATIVE,
    (0x17 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x18 << 8) + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x19 << 8) + FLAG_X + FLAG_NEGATIVE,
    (0x20 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x21 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x22 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x23 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x24 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x25 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x26 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x27 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x28 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x29 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE,
    (0x24 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x25 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x26 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x27 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x28 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x29 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE,
    (0x30 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x31 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x32 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x33 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x34 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x35 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x36 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x37 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x38 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE,
    (0x39 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x34 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x35 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x36 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x37 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x38 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE,
    (0x39 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x40 << 8) + FLAG_NEGATIVE,
    (0x41 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x42 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x43 << 8) + FLAG_NEGATIVE,
    (0x44 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x45 << 8) + FLAG_NEGATIVE,
    (0x46 << 8) + FLAG_NEGATIVE,
    (0x47 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x48 << 8) + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x49 << 8) + FLAG_X + FLAG_NEGATIVE,
    (0x44 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x45 << 8) + FLAG_NEGATIVE,
    (0x46 << 8) + FLAG_NEGATIVE,
    (0x47 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x48 << 8) + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x49 << 8) + FLAG_X + FLAG_NEGATIVE,
    (0x50 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x51 << 8) + FLAG_NEGATIVE,
    (0x52 << 8) + FLAG_NEGATIVE,
    (0x53 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x54 << 8) + FLAG_NEGATIVE,
    (0x55 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x56 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x57 << 8) + FLAG_NEGATIVE,
    (0x58 << 8) + FLAG_X + FLAG_NEGATIVE,
    (0x59 << 8) + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x54 << 8) + FLAG_NEGATIVE,
    (0x55 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x56 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x57 << 8) + FLAG_NEGATIVE,
    (0x58 << 8) + FLAG_X + FLAG_NEGATIVE,
    (0x59 << 8) + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x60 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x61 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x62 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x63 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x64 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x65 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x66 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x67 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x68 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE,
    (0x69 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x64 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x65 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x66 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x67 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x68 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE,
    (0x69 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x70 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x71 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x72 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x73 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x74 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x75 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x76 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x77 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x78 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x79 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE,
    (0x74 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x75 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x76 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x77 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x78 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x79 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE,
    (0x80 << 8) + FLAG_SIGN + FLAG_NEGATIVE,
    (0x81 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE,
    (0x82 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE,
    (0x83 << 8) + FLAG_SIGN + FLAG_NEGATIVE,
    (0x84 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE,
    (0x85 << 8) + FLAG_SIGN + FLAG_NEGATIVE,
    (0x86 << 8) + FLAG_SIGN + FLAG_NEGATIVE,
    (0x87 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE,
    (0x88 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x89 << 8) + FLAG_SIGN + FLAG_X + FLAG_NEGATIVE,
    (0x84 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE,
    (0x85 << 8) + FLAG_SIGN + FLAG_NEGATIVE,
    (0x86 << 8) + FLAG_SIGN + FLAG_NEGATIVE,
    (0x87 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE,
    (0x88 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x89 << 8) + FLAG_SIGN + FLAG_X + FLAG_NEGATIVE,
    (0x90 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE,
    (0x91 << 8) + FLAG_SIGN + FLAG_NEGATIVE,
    (0x92 << 8) + FLAG_SIGN + FLAG_NEGATIVE,
    (0x93 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE,
    (0x94 << 8) + FLAG_SIGN + FLAG_NEGATIVE,
    (0x95 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE,
    (0x96 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE,
    (0x97 << 8) + FLAG_SIGN + FLAG_NEGATIVE,
    (0x98 << 8) + FLAG_SIGN + FLAG_X + FLAG_NEGATIVE,
    (0x99 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x34 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x35 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x36 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x37 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x38 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x39 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x40 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x41 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x42 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x43 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x44 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x45 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x46 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x47 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x48 << 8) + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x49 << 8) + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x44 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x45 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x46 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x47 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x48 << 8) + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x49 << 8) + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x50 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x51 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x52 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x53 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x54 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x55 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x56 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x57 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x58 << 8) + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x59 << 8) + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x54 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x55 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x56 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x57 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x58 << 8) + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x59 << 8) + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x60 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x61 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x62 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x63 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x64 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x65 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x66 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x67 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x68 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x69 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x64 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x65 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x66 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x67 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x68 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x69 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x70 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x71 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x72 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x73 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x74 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x75 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x76 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x77 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x78 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x79 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x74 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x75 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x76 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x77 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x78 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x79 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x80 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x81 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x82 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x83 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x84 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x85 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x86 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x87 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x88 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x89 << 8) + FLAG_SIGN + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x84 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x85 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x86 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x87 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x88 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x89 << 8) + FLAG_SIGN + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x90 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x91 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x92 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x93 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x94 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x95 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x96 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x97 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x98 << 8) + FLAG_SIGN + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x99 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x94 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x95 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x96 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x97 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x98 << 8) + FLAG_SIGN + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x99 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xA0 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xA1 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xA2 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xA3 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xA4 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xA5 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xA6 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xA7 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xA8 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xA9 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xA4 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xA5 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xA6 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xA7 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xA8 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xA9 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xB0 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xB1 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xB2 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xB3 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xB4 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xB5 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xB6 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xB7 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xB8 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xB9 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xB4 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xB5 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xB6 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xB7 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xB8 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xB9 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xC0 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xC1 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0xC2 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0xC3 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xC4 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0xC5 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xC6 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xC7 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0xC8 << 8) + FLAG_SIGN + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xC9 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xC4 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0xC5 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xC6 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xC7 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0xC8 << 8) + FLAG_SIGN + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xC9 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xD0 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0xD1 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xD2 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xD3 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0xD4 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xD5 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0xD6 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0xD7 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xD8 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xD9 << 8) + FLAG_SIGN + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xD4 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xD5 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0xD6 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0xD7 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xD8 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xD9 << 8) + FLAG_SIGN + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xE0 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xE1 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xE2 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xE3 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xE4 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xE5 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xE6 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xE7 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xE8 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xE9 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xE4 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xE5 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xE6 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xE7 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xE8 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xE9 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xF0 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xF1 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xF2 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xF3 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xF4 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xF5 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xF6 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xF7 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xF8 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xF9 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xF4 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xF5 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xF6 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xF7 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xF8 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xF9 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x00 << 8) + FLAG_ZERO + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x01 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x02 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x03 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x04 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x05 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x06 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x07 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x08 << 8) + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x09 << 8) + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x04 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x05 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x06 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x07 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x08 << 8) + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x09 << 8) + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x10 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x11 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x12 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x13 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x14 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x15 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x16 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x17 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x18 << 8) + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x19 << 8) + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x14 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x15 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x16 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x17 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x18 << 8) + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x19 << 8) + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x20 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x21 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x22 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x23 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x24 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x25 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x26 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x27 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x28 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x29 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x24 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x25 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x26 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x27 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x28 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x29 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x30 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x31 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x32 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x33 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x34 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x35 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x36 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x37 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x38 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x39 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x34 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x35 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x36 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x37 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x38 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x39 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x40 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x41 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x42 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x43 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x44 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x45 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x46 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x47 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x48 << 8) + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x49 << 8) + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x44 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x45 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x46 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x47 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x48 << 8) + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x49 << 8) + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x50 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x51 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x52 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x53 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x54 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x55 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x56 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x57 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x58 << 8) + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x59 << 8) + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x54 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x55 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x56 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x57 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x58 << 8) + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x59 << 8) + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x60 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x61 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x62 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x63 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x64 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x65 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x66 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x67 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x68 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x69 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x64 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x65 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x66 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x67 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x68 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x69 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x70 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x71 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x72 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x73 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x74 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x75 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x76 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x77 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x78 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x79 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x74 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x75 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x76 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x77 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x78 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x79 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x80 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x81 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x82 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x83 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x84 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x85 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x86 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x87 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x88 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x89 << 8) + FLAG_SIGN + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x84 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x85 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x86 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x87 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x88 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x89 << 8) + FLAG_SIGN + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x90 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x91 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x92 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x93 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x94 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x95 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x96 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x97 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x98 << 8) + FLAG_SIGN + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x99 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x94 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x95 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x96 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x97 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x98 << 8) + FLAG_SIGN + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x99 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xFA << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0xFB << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE,
    (0xFC << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0xFD << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE,
    (0xFE << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE,
    (0xFF << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x00 << 8) + FLAG_ZERO + FLAG_PARITY + FLAG_NEGATIVE,
    (0x01 << 8) + FLAG_NEGATIVE,
    (0x02 << 8) + FLAG_NEGATIVE,
    (0x03 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x04 << 8) + FLAG_NEGATIVE,
    (0x05 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x06 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x07 << 8) + FLAG_NEGATIVE,
    (0x08 << 8) + FLAG_X + FLAG_NEGATIVE,
    (0x09 << 8) + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x0A << 8) + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x0B << 8) + FLAG_HALF + FLAG_X + FLAG_NEGATIVE,
    (0x0C << 8) + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x0D << 8) + FLAG_HALF + FLAG_X + FLAG_NEGATIVE,
    (0x0E << 8) + FLAG_HALF + FLAG_X + FLAG_NEGATIVE,
    (0x0F << 8) + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x10 << 8) + FLAG_NEGATIVE,
    (0x11 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x12 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x13 << 8) + FLAG_NEGATIVE,
    (0x14 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x15 << 8) + FLAG_NEGATIVE,
    (0x16 << 8) + FLAG_NEGATIVE,
    (0x17 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x18 << 8) + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x19 << 8) + FLAG_X + FLAG_NEGATIVE,
    (0x1A << 8) + FLAG_HALF + FLAG_X + FLAG_NEGATIVE,
    (0x1B << 8) + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x1C << 8) + FLAG_HALF + FLAG_X + FLAG_NEGATIVE,
    (0x1D << 8) + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x1E << 8) + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x1F << 8) + FLAG_HALF + FLAG_X + FLAG_NEGATIVE,
    (0x20 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x21 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x22 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x23 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x24 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x25 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x26 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x27 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x28 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x29 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE,
    (0x2A << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE,
    (0x2B << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x2C << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE,
    (0x2D << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x2E << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x2F << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE,
    (0x30 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x31 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x32 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x33 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x34 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x35 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x36 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x37 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x38 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE,
    (0x39 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x3A << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x3B << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE,
    (0x3C << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x3D << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE,
    (0x3E << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE,
    (0x3F << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x40 << 8) + FLAG_NEGATIVE,
    (0x41 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x42 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x43 << 8) + FLAG_NEGATIVE,
    (0x44 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x45 << 8) + FLAG_NEGATIVE,
    (0x46 << 8) + FLAG_NEGATIVE,
    (0x47 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x48 << 8) + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x49 << 8) + FLAG_X + FLAG_NEGATIVE,
    (0x4A << 8) + FLAG_HALF + FLAG_X + FLAG_NEGATIVE,
    (0x4B << 8) + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x4C << 8) + FLAG_HALF + FLAG_X + FLAG_NEGATIVE,
    (0x4D << 8) + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x4E << 8) + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x4F << 8) + FLAG_HALF + FLAG_X + FLAG_NEGATIVE,
    (0x50 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x51 << 8) + FLAG_NEGATIVE,
    (0x52 << 8) + FLAG_NEGATIVE,
    (0x53 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x54 << 8) + FLAG_NEGATIVE,
    (0x55 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x56 << 8) + FLAG_PARITY + FLAG_NEGATIVE,
    (0x57 << 8) + FLAG_NEGATIVE,
    (0x58 << 8) + FLAG_X + FLAG_NEGATIVE,
    (0x59 << 8) + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x5A << 8) + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x5B << 8) + FLAG_HALF + FLAG_X + FLAG_NEGATIVE,
    (0x5C << 8) + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x5D << 8) + FLAG_HALF + FLAG_X + FLAG_NEGATIVE,
    (0x5E << 8) + FLAG_HALF + FLAG_X + FLAG_NEGATIVE,
    (0x5F << 8) + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x60 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x61 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x62 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x63 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x64 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x65 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x66 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x67 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x68 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE,
    (0x69 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x6A << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x6B << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE,
    (0x6C << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x6D << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE,
    (0x6E << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE,
    (0x6F << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x70 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x71 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x72 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x73 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x74 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x75 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x76 << 8) + FLAG_Y + FLAG_NEGATIVE,
    (0x77 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE,
    (0x78 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x79 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE,
    (0x7A << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE,
    (0x7B << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x7C << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE,
    (0x7D << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x7E << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x7F << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE,
    (0x80 << 8) + FLAG_SIGN + FLAG_NEGATIVE,
    (0x81 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE,
    (0x82 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE,
    (0x83 << 8) + FLAG_SIGN + FLAG_NEGATIVE,
    (0x84 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE,
    (0x85 << 8) + FLAG_SIGN + FLAG_NEGATIVE,
    (0x86 << 8) + FLAG_SIGN + FLAG_NEGATIVE,
    (0x87 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE,
    (0x88 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x89 << 8) + FLAG_SIGN + FLAG_X + FLAG_NEGATIVE,
    (0x8A << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_NEGATIVE,
    (0x8B << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x8C << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_NEGATIVE,
    (0x8D << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x8E << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE,
    (0x8F << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_NEGATIVE,
    (0x90 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE,
    (0x91 << 8) + FLAG_SIGN + FLAG_NEGATIVE,
    (0x92 << 8) + FLAG_SIGN + FLAG_NEGATIVE,
    (0x93 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE,
    (0x34 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x35 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x36 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x37 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x38 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x39 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x3A << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x3B << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x3C << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x3D << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x3E << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x3F << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x40 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x41 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x42 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x43 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x44 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x45 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x46 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x47 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x48 << 8) + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x49 << 8) + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x4A << 8) + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x4B << 8) + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x4C << 8) + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x4D << 8) + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x4E << 8) + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x4F << 8) + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x50 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x51 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x52 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x53 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x54 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x55 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x56 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x57 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x58 << 8) + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x59 << 8) + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x5A << 8) + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x5B << 8) + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x5C << 8) + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x5D << 8) + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x5E << 8) + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x5F << 8) + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x60 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x61 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x62 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x63 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x64 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x65 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x66 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x67 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x68 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x69 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x6A << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x6B << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x6C << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x6D << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x6E << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x6F << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x70 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x71 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x72 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x73 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x74 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x75 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x76 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x77 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x78 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x79 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x7A << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x7B << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x7C << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x7D << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x7E << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x7F << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x80 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x81 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x82 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x83 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x84 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x85 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x86 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x87 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x88 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x89 << 8) + FLAG_SIGN + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x8A << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x8B << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x8C << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x8D << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x8E << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x8F << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x90 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x91 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x92 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x93 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x94 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x95 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x96 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x97 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x98 << 8) + FLAG_SIGN + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x99 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x9A << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x9B << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x9C << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x9D << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x9E << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x9F << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xA0 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xA1 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xA2 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xA3 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xA4 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xA5 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xA6 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xA7 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xA8 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xA9 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xAA << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xAB << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xAC << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xAD << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xAE << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xAF << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xB0 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xB1 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xB2 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xB3 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xB4 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xB5 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xB6 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xB7 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xB8 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xB9 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xBA << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xBB << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xBC << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xBD << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xBE << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xBF << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xC0 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xC1 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0xC2 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0xC3 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xC4 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0xC5 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xC6 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xC7 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0xC8 << 8) + FLAG_SIGN + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xC9 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xCA << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xCB << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xCC << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xCD << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xCE << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xCF << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xD0 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0xD1 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xD2 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xD3 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0xD4 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xD5 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0xD6 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0xD7 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xD8 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xD9 << 8) + FLAG_SIGN + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xDA << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xDB << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xDC << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xDD << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xDE << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xDF << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xE0 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xE1 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xE2 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xE3 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xE4 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xE5 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xE6 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xE7 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xE8 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xE9 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xEA << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xEB << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xEC << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xED << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xEE << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xEF << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xF0 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xF1 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xF2 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xF3 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xF4 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xF5 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xF6 << 8) + FLAG_SIGN + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xF7 << 8) + FLAG_SIGN + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0xF8 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xF9 << 8) + FLAG_SIGN + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xFA << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xFB << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xFC << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0xFD << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xFE << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0xFF << 8) + FLAG_SIGN + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x00 << 8) + FLAG_ZERO + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x01 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x02 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x03 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x04 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x05 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x06 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x07 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x08 << 8) + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x09 << 8) + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x0A << 8) + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x0B << 8) + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x0C << 8) + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x0D << 8) + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x0E << 8) + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x0F << 8) + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x10 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x11 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x12 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x13 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x14 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x15 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x16 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x17 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x18 << 8) + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x19 << 8) + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x1A << 8) + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x1B << 8) + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x1C << 8) + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x1D << 8) + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x1E << 8) + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x1F << 8) + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x20 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x21 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x22 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x23 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x24 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x25 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x26 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x27 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x28 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x29 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x2A << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x2B << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x2C << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x2D << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x2E << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x2F << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x30 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x31 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x32 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x33 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x34 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x35 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x36 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x37 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x38 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x39 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x3A << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x3B << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x3C << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x3D << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x3E << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x3F << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x40 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x41 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x42 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x43 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x44 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x45 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x46 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x47 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x48 << 8) + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x49 << 8) + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x4A << 8) + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x4B << 8) + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x4C << 8) + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x4D << 8) + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x4E << 8) + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x4F << 8) + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x50 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x51 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x52 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x53 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x54 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x55 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x56 << 8) + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x57 << 8) + FLAG_NEGATIVE + FLAG_CARRY,
    (0x58 << 8) + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x59 << 8) + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x5A << 8) + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x5B << 8) + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x5C << 8) + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x5D << 8) + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x5E << 8) + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x5F << 8) + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x60 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x61 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x62 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x63 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x64 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x65 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x66 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x67 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x68 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x69 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x6A << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x6B << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x6C << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x6D << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x6E << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x6F << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x70 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x71 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x72 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x73 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x74 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x75 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x76 << 8) + FLAG_Y + FLAG_NEGATIVE + FLAG_CARRY,
    (0x77 << 8) + FLAG_Y + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x78 << 8) + FLAG_Y + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x79 << 8) + FLAG_Y + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x7A << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x7B << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x7C << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x7D << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x7E << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x7F << 8) + FLAG_Y + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x80 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x81 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x82 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x83 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x84 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x85 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x86 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x87 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x88 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x89 << 8) + FLAG_SIGN + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x8A << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x8B << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x8C << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x8D << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x8E << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x8F << 8) + FLAG_SIGN + FLAG_HALF + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x90 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x91 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x92 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x93 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x94 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x95 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x96 << 8) + FLAG_SIGN + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY,
    (0x97 << 8) + FLAG_SIGN + FLAG_NEGATIVE + FLAG_CARRY,
    (0x98 << 8) + FLAG_SIGN + FLAG_X + FLAG_NEGATIVE + FLAG_CARRY,
    (0x99 << 8) + FLAG_SIGN + FLAG_X + FLAG_PARITY + FLAG_NEGATIVE + FLAG_CARRY
};


#endif	/* OPCODE_DAA_H */

