
/* Copyright (C) 2005-2008, Free Software Foundation, Inc.
   Contributed by David Miles

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

#include <windows.h>
#include "runtime.h"


/* dtime()-- dtime intrinsic subroutine */

#define dtime prefix(dtime)

void dtime(float *time, float *result) {       
FILETIME creation_time, exit_time, kernel_time, user_time;
static float last_user=0.0, last_sys=0.0;
float user, sys, r;

    GetProcessTimes(GetCurrentProcess(), &creation_time, &exit_time,
		    &kernel_time, &user_time);

    user = 429.4967296 * ((unsigned) user_time.dwHighDateTime)
	+ 1.0e-7 * ((unsigned) user_time.dwLowDateTime);

    sys = 429.4967296 * ((unsigned) kernel_time.dwHighDateTime)
	+ 1.0e-7 * ((unsigned) kernel_time.dwLowDateTime);

    time[0] = user - last_user;
    time[1] = sys  - last_sys;
    r = time[0] + time[1];

    last_user = user;
    last_sys = sys;

    if (result != NULL)
	result[0] = r;    
}


/* dtime_f()-- dtime function. */

#define dtime_f prefix(dtime_f)

float dtime_f(float *time) {
FILETIME creation_time, exit_time, kernel_time, user_time;
static float last_user=0.0, last_sys=0.0;
float t0, t1, r, user, sys;

    GetProcessTimes(GetCurrentProcess(), &creation_time, &exit_time,
		    &kernel_time, &user_time);

    user = 429.4967296 * ((unsigned) user_time.dwHighDateTime)
	+ 1.0e-7 * ((unsigned) user_time.dwLowDateTime);

    sys = 429.4967296 * ((unsigned) kernel_time.dwHighDateTime)
	+ 1.0e-7 * ((unsigned) kernel_time.dwLowDateTime);

    t0 = user - last_user;
    t1 = sys  - last_sys;

    r = t0 + t1;  
    last_user = user;
    last_sys  = sys;

    if (time != NULL) {  
	time[0] = t0;         
	time[1] = t1;  
    }          

    return r;          
} 
 
 
 
#define system_dtime external_prefix(dtime)
     
float system_dtime(float *t) {  
  
    return dtime_f(t);     
}    
