
/* Copyright (C) 2005-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/


#include <string.h>
#include "runtime.h"


/* iargc()-- Command line argument counting */

#define iargc prefix(iargc)

G95_DINT iargc(void) {

    return f__xargc - 1;
}


/* getarg()-- Command line argument value */

#define getarg_1 prefix(getarg_1)

void getarg_1(signed G95_INT1 *n, char *arg, G95_DINT arg_len) {
char *p=NULL;
int m;

    if (*n < 0 || *n >= f__xargc)
	m = 0;

    else {
	p = f__xargv[(int) *n];
	m = strlen(p);
    }

    copy_string(arg, arg_len, p, m);
}



#define getarg_2 prefix(getarg_2)

void getarg_2(G95_INT2 *n, char *arg, G95_DINT arg_len) {
char *p=NULL;
int m;

    if (*n < 0 || *n >= f__xargc)
	m = 0;
    else {
	p = f__xargv[*n];
	m = strlen(p);
    }

    copy_string(arg, arg_len, p, m);
}



#define getarg_4 prefix(getarg_4)

void getarg_4(G95_INT4 *n, char *arg, G95_DINT arg_len) {
char *p=NULL;
int m;

    if (*n < 0 || *n >= f__xargc)
	m = 0;

    else {
	p = f__xargv[*n];
	m = strlen(p);
    }

    copy_string(arg, arg_len, p, m);
}



#define getarg_8 prefix(getarg_8)

void getarg_8(G95_INT8 *n, char *arg, G95_DINT arg_len) {
char *p=NULL;
int m;

    if (*n < 0 || *n >= f__xargc)
	m = 0;

    else {
	p = f__xargv[*n];
	m = strlen(p);
    }

    copy_string(arg, arg_len, p, m);
}



#define external_getarg external_prefix(getarg)

void external_getarg(void *p, char *arg, G95_DINT arg_len) {

#if G95_DINT_MAX == 2147483647
    getarg_4(p, arg, arg_len);
#else
    getarg_8(p, arg, arg_len);
#endif
}


#define external_iargc external_prefix(iargc)

G95_DINT external_iargc(void) {

    return f__xargc - 1;
}

