
/* Copyright (C) 2005-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

#include <sys/time.h>
#include <sys/resource.h>
#include <unistd.h>

#include "runtime.h"


/* etime()-- etime intrinsic subroutine */

#define etime prefix(etime)

void etime(float *time, float *result) {
struct rusage ru;
float t0, t1, r;

    if (getrusage(RUSAGE_SELF, &ru) < 0) {
	t0 = -1.0;
	t1 = -1.0;
	r = -1.0;

    } else {
	t0 = ru.ru_utime.tv_sec + 1.0e-6 * ru.ru_utime.tv_usec;
	t1 = ru.ru_stime.tv_sec + 1.0e-6 * ru.ru_stime.tv_usec;
	r = t0 + t1;
    }

    time[0] = t0;
    time[1] = t1;

    if (result != NULL)
	result[0] = r;
}


/* etime_f()-- etime function. */

#define etime_f prefix(etime_f)

float etime_f(float *time) {
struct rusage ru;
float t0, t1, r;

    if (getrusage(RUSAGE_SELF, &ru) < 0) {
	t0 = -1.0;
	t1 = -1.0;
	r = -1.0;

    } else {
	t0 = ru.ru_utime.tv_sec + 1.0e-6 * ru.ru_utime.tv_usec;
	t1 = ru.ru_stime.tv_sec + 1.0e-6 * ru.ru_stime.tv_usec;
	r = t0 + t1;
    }

    if (time != NULL) {
	time[0] = t0;
	time[1] = t1;
    }

    return r;
}



#define system_etime external_prefix(etime)

float system_etime(float *) __attribute__((weak));

float system_etime(float *t) {

    return etime_f(t);
}
