
/* Copyright (C) 2005-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

#include <sys/time.h>
#include <unistd.h>
#include <time.h>

#include "runtime.h"


/* dump_num()-- Function to dump a decimal number with a fixed number
 * of digits into a buffer. */

static void dump_num(int n, int digits, char *buffer) {

    buffer += digits;

    while(digits > 0) {
	buffer--;
	*buffer = '0' + (n % 10);

	n = n / 10;
	digits--;
    }
}


/* date_and_time()-- DATE_AND_TIME intrinsic */

#define date_and_time prefix(date_and_time)

void date_and_time(char *date, char *time_arg, char *zone, 
		   g95_array_descriptor *values,
		   G95_DINT date_len, G95_DINT time_len, G95_DINT zone_len) {
char date0[8], time0[10], zone0[5];
struct tm *tm_now, t1, t2;
int gmt_offset, i, m;
struct timeval tv;
time_t now;
char *p;

    gettimeofday(&tv, NULL); 
    now = tv.tv_sec;

    /* Compute the offset from GMT.  There aren't many portable ways,
     * this one is crude but portable. */

    t1 = *localtime(&now);
    t2 = *gmtime(&now);

    gmt_offset = 525600*(t1.tm_year - t2.tm_year)
	+ 1440*(t1.tm_yday - t2.tm_yday) + 60*(t1.tm_hour - t2.tm_hour)
	+ (t1.tm_min - t2.tm_min);

    tm_now = localtime(&now);

    /* Date */

    m = (tm_now->tm_year+1900)*10000 +
	(tm_now->tm_mon+1)*100 + tm_now->tm_mday;
    dump_num(m, 8, date0);

    /* Time */

    m = tm_now->tm_hour*10000 + tm_now->tm_min*100 + tm_now->tm_sec;
    dump_num(m, 6, time0);

    time0[6] = '.';

    m = tv.tv_usec / 1000;   /* Microseconds to milliseconds */
    dump_num(m, 3, time0+7);

    /* Timezone. */

    if (gmt_offset < 0) {
	zone0[0] = '-';
	m = -gmt_offset;
    } else {
	zone0[0] = '+';
	m = gmt_offset;
    }

    m = 100*(m / 60) + (m % 60);
    dump_num(m, 4, zone0+1);

    /* Dump values */

    if (date     != NULL) copy_string(date, date_len, date0, 8);
    if (time_arg != NULL) copy_string(time_arg, time_len, time0, 10);
    if (zone     != NULL) copy_string(zone, zone_len, zone0, 5);

    if (values != NULL)
	for(i=1; i<=8; i++) {
	    switch(i) {
	    case 1:  m = tm_now->tm_year + 1900;  break;
	    case 2:  m = tm_now->tm_mon + 1;      break;
	    case 3:  m = tm_now->tm_mday;         break;
	    case 4:  m = gmt_offset;              break;
	    case 5:  m = tm_now->tm_hour;         break;
	    case 6:  m = tm_now->tm_min;          break;
	    case 7:  m = tm_now->tm_sec;          break;
	    case 8:  m = tv.tv_usec / 1000;       break;
	    }

	    p = values->offset + i*values->info[0].mult;
	    set_integer(m, p, values->element_size);
	}
}
