
/* Copyright (C) 2005-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

#include <unistd.h>
#include <errno.h>
#include "runtime.h"


#define sys_access prefix(access)

G95_INT4 sys_access(char *name, char *mode, int namelen, int modelen) {
int modetest, return_value;
char *buffer;

    if (modelen == 0) {
	errno = ENOENT;
	return -errno;
    }

    buffer = string_copy_in(name, namelen);
    if (buffer[0] == '\0') {
	errno = ENOENT;
	return -errno;
    }

    if (access(buffer, F_OK) < 0)
	return errno;

    modetest = 0;
    while(modelen--)
	switch(*mode++) {
	case 'x': case 'X':
	    modetest |= X_OK;
	    break;

	case 'w': case 'W':
	    modetest |= W_OK;
	    break;

	case 'r': case 'R':
	    modetest |= R_OK;
	    break;

	case ' ':
	    modetest |= F_OK;
	    break;
	}

    return_value = access(buffer, modetest);
    free_mem(buffer);

    return return_value;
}
