
/* Copyright (C) 2002-2008 Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/


#include "runtime.h"

/* rewind.c--  Implement the rewind statement */


void st_rewind(void) {
iounit_t *u;

    library_start();

    u = find_unit(ioparm->unit, ioparm->unit_kind);

    if (u != NULL) {
	if (u->flags.access == ACCESS_DIRECT) 
	    generate_error(ERROR_BAD_OPTION,
			   "Cannot REWIND a file opened for DIRECT access");
	else {
	    u->last_record = 1;
	    u->repos = 1;

	    if (sseek(u->s, 0) == FAILURE)
		generate_error(ERROR_OS, NULL);

	    u->endfile = NO_ENDFILE;
	    u->read_eof = 0;
	    u->read_bad = 0;
	    u->previous_noadvance = 0;
	    u->s->truncate = 1;
	}
    }

    library_end();
}
