
/* Copyright (C) 2005-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/


#include "runtime.h"


static int convert_time(FILETIME *t) {
SYSTEMTIME st_epoch;
FILETIME ft_epoch;
long long m, n;

    st_epoch.wYear = 1970;
    st_epoch.wMonth = 1;
    st_epoch.wDay = 1;
    st_epoch.wHour = 0;
    st_epoch.wMinute = 0;
    st_epoch.wSecond = 0;
    st_epoch.wMilliseconds = 1;

    SystemTimeToFileTime(&st_epoch, &ft_epoch);

    m = (((long long) t->dwHighDateTime) << 32) + t->dwLowDateTime;
    n = (((long long) ft_epoch.dwHighDateTime) << 32) + ft_epoch.dwLowDateTime;

    return (m-n) / 10000000;
}



static void do_fstat(HANDLE h, G95_DINT *sarray) {
FILETIME create_time, access_time, mod_time;

    sarray[0] = 0;
    sarray[1] = 0;
    sarray[2] = 0777;
    sarray[3] = 1;
    sarray[4] = 0;
    sarray[5] = 0;
    sarray[6] = 0;
    sarray[7] = fd_length(h);

    GetFileTime(h, &create_time, &access_time, &mod_time);

    sarray[8] = convert_time(&access_time);
    sarray[9] = convert_time(&mod_time);
    sarray[10] = convert_time(&create_time);
    sarray[11] = 0;
    sarray[12] = 0;
}



static int do_stat(char *filename, G95_DINT *sarray, G95_DINT file_len) {
char *buffer;
HANDLE h;

    buffer = string_copy_in(filename, file_len);

    h = CreateFile(buffer, GENERIC_READ, 0, NULL, OPEN_EXISTING,
		   FILE_ATTRIBUTE_NORMAL, NULL);

    free_mem(buffer);

    if (h == INVALID_HANDLE_VALUE)
	return -1;

    do_fstat(h, sarray);
    CloseHandle(h);

    return 0;
}



#define stat_f prefix(stat_f)

G95_DINT stat_f(char *file, G95_DINT *sarray, G95_DINT file_len) {

    return do_stat(file, sarray, file_len);
}



#define stat_s prefix(stat_s)

void stat_s(char *file, G95_DINT *sarray, G95_DINT *status, G95_DINT file_len){

    *status = do_stat(file, sarray, file_len);
}



#define lstat_f prefix(lstat_f)

G95_DINT lstat_f(char *file, G95_DINT *sarray, G95_DINT file_len) {

    return do_stat(file, sarray, file_len);
}



#define lstat_s prefix(lstat_s)

void lstat_s(char *file, G95_DINT *sarray, G95_DINT *status,
	     G95_DINT file_len) {

    *status = do_stat(file, sarray, file_len);
}



#define fstat_f prefix(fstat_f)

G95_DINT fstat_f(G95_DINT *unit, G95_DINT *sarray) {
int status;
iounit_t *u;

    u = find_unit(unit, sizeof(G95_DINT));

    if (u != NULL) {
	do_fstat(u->s->fd, sarray);
	status = 0;
    } else
	status = -1;

    return status;
}



#define fstat_s prefix(fstat_s)

void fstat_s(G95_DINT *unit, G95_DINT *sarray, G95_DINT *status) {
iounit_t *u;

    u = find_unit(unit, sizeof(G95_DINT));

    if (u == NULL) {
	do_fstat(u->s->fd, sarray);
	*status = 0;
    } else
	*status = -1;
}
