
/* Copyright (C) 2005-2008 Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

/* Provide single precision math functions if not present */

#include <math.h>
#include "runtime.h"


#if HAVE_SINF == 0
float sinf(float x) {

    return sin((double) x);
}
#endif


#if HAVE_COSF == 0
float cosf(float x) {

    return cos((double) x);
}
#endif


#if HAVE_TANF == 0
float tanf(float x) {

    return tan((double) x);
}
#endif


#if HAVE_ATANF == 0
float atanf(float x) {

    return atan((double) x);
}
#endif


#if HAVE_SQRTF == 0
float sqrtf(float x) {

    return sqrt((double) x);
}
#endif


#if HAVE_EXPF == 0
float expf(float x) {

    return exp((double) x);
}
#endif


#if HAVE_POWF == 0
float powf(float x, float y) {

    return pow((double) x, (double) y);
}
#endif
