
/* Copyright (C) 2003-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

/* abs.c -- Compute absolute values.  These are necessary when one of
 * the absolute value intrinsics is used as a dummy procedure. */

#ifdef SUBROUTINE

TYPE SUBROUTINE(TYPE *n) {
TYPE m;

    m = *n;
    if (m < 0)
	m = -m;

    return m;
}

#undef TYPE
#undef SUBROUTINE

#else

#include "runtime.h"

#define SUBROUTINE prefix(abs_i1)
#define TYPE signed G95_INT1
#include "abs.c"

#define SUBROUTINE prefix(abs_i2)
#define TYPE G95_INT2
#include "abs.c"

#define SUBROUTINE prefix(abs_i4)
#define TYPE G95_INT4
#include "abs.c"

#ifdef G95_INT8
#define SUBROUTINE prefix(abs_i8)
#define TYPE G95_INT8
#include "abs.c"
#endif

#ifdef G95_INT16
#define SUBROUTINE prefix(abs_i16)
#define TYPE G95_INT16
#include "abs.c"
#endif

#define SUBROUTINE prefix(abs_r4)
#define TYPE float
#include "abs.c"

#define SUBROUTINE prefix(abs_r8)
#define TYPE double
#include "abs.c"

#endif
