
/* Copyright (C) 2003-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

/* Implement the TRANSPOSE intrinsic. */

#include "runtime.h"
#include <string.h>


#define transpose prefix(transpose)

g95_array_descriptor *transpose(g95_array_descriptor *matrix) {
G95_AINT element_size, e1, e2, m[2];
g95_array_descriptor *dest;
char *p, *q;

    e1 = matrix->info[0].ubound - matrix->info[0].lbound + 1;
    if (e1 < 0)
	e1 = 0;

    e2 = matrix->info[1].ubound - matrix->info[1].lbound + 1;
    if (e2 < 0)
	e2 = 0;

    element_size = matrix->element_size;

    dest = temp_array(2, element_size, e2, e1);
    if (e1 == 0 || e2 == 0)
	return dest;

    m[0] = matrix->info[0].lbound;
    m[1] = matrix->info[1].lbound;

    for(;;) {
	q = matrix->offset +
	    matrix->info[0].mult*m[0] +
	    matrix->info[1].mult*m[1];

	e1 = m[1] - matrix->info[1].lbound + 1;
	e2 = m[0] - matrix->info[0].lbound + 1;

	p = dest->offset + dest->info[0].mult*e1 + dest->info[1].mult*e2;

	memcpy(p, q, element_size);

	if (bump_element(matrix, m))
	    break;
    }

    return dest;
}
