
/*
 * This is an rcmd() replacement originally by 
 * Chris Siebenmann <cks@utcc.utoronto.ca>.
 */
#include	"defs.h"

#ifndef lint
static char RCSid[] __attribute__((__unused__)) =
"$FreeRdist: rshrcmd.c,v 1.8 2012/07/11 17:20:21 christos Exp $";
#endif


#if	!defined(DIRECT_RCMD)

#include      <sys/types.h>
#include      <sys/socket.h>
#include      <sys/wait.h>
#include      <signal.h>
#include      <errno.h>
#include      <netdb.h>
#include      <stdio.h>

/*
 * This is a replacement rcmd() function that uses the rsh(1c)
 * program in place of a direct rcmd() function call so as to
 * avoid having to be root.
 */
int
rshrcmd(char  	**ahost, u_short port, char *luser, char *ruser, char *cmd,
    int *fd2p)
{
	int             cpid;
	struct addrinfo *res;
	int             sp[2];
	int		e;

	/* insure that we are indeed being used as we thought. */
	if (fd2p != 0)
		return -1;

	/* validate remote hostname. */
	if ((e = getaddrinfo(*ahost, NULL, NULL, &res)) != 0) {
		error("%s: %s", *ahost, gai_strerror(e));
		return -1;
	}

	/* get a socketpair we'll use for stdin and stdout. */
	if (getsocketpair(AF_UNIX, SOCK_STREAM, 0, sp) < 0) {
		error("socketpair(AF_UNIX, SOCK_STREAM, 0) failed: %s.", 
		      SYSERR);
		return -1;
	}

	cpid = fork();
	if (cpid < 0) {
		error("fork failed: %s.", SYSERR);
		return -1;      /* error. */
	}
	if (cpid == 0) {
		const char *rsh;

		/* child. we use sp[1] to be stdin/stdout, and close
		   sp[0]. */
		(void) close(sp[0]);
		if (dup2(sp[1], 0) < 0 || dup2(0,1) < 0 || dup2(0, 2) < 0) {
			error("dup2 failed: %s.", SYSERR);
			_exit(255);
		}
		/* fork again to lose parent. */
		cpid = fork();
		if (cpid < 0) {
			error("fork to lose parent failed: %s.", SYSERR);
			_exit(255);
		}
		if (cpid > 0)
			_exit(0);
		/* in grandchild here. */

		/*
		 * See if user wants to use a different rsh
		 */
		if ((rsh = getenv("RDIST_RSH")) == NULL)
			rsh = path_remsh;

		/*
		 * If we are rdist'ing to "localhost" as the same user
		 * as we are, then avoid running remote shell for efficiency.
		 */
		if (strcmp(*ahost, "localhost") == 0 &&
		    strcmp(luser, ruser) == 0) {
#if 0
			/* 
			 * Cannot have debug messages here, because we
			 * have not set up our file descriptors yet
			 */
			debugmsg(DM_MISC, "Remote shell command = '%s'\n",
				 _PATH_BSHELL);
#endif
			execlp(_PATH_BSHELL, xbasename(_PATH_BSHELL), "-c",
			       cmd, NULL);
			error("execlp %s failed: %s.", _PATH_BSHELL, SYSERR);
		} else {
#if 0
			/* 
			 * Cannot have debug messages here, because we
			 * have not set up our file descriptors yet
			 */
			debugmsg(DM_MISC, "Remote shell command = '%s'\n",
				 path_remsh);
#endif
			execlp(rsh, xbasename(rsh), 
			       *ahost, "-l", ruser, cmd, NULL);
			error("execlp %s failed: %s.", rsh, SYSERR);
		}
		_exit(255);
	}
	if (cpid > 0) {
		/* parent. close sp[1], return sp[0]. */
		(void) close(sp[1]);
		/* reap child. */
		(void) wait(0);
		return sp[0];
	}
	/*NOTREACHED*/
	return -1;
}

#endif	/* !DIRECT_RCMD */
