
/*------------------------------------------------------
 Maximum likelihood estimation 
 of migration rate  and effectice population size
 using a Metropolis-Hastings Monte Carlo algorithm                            
 -------------------------------------------------------                        
 W O R L D   R O U T I N E S 

 creates tree structures,
 reads tree [has to be done
 
 prints results,
 and finally helps to destroy itself.
                                                                                                               
 Peter Beerli 1996, Seattle
 beerli@genetics.washington.edu
 $Id: plot.c,v 1.2 2002/10/18 20:50:24 beerli Exp $

 modifed for use with recombine by Jon Yamato (1/8/97)
 modified for use with fluctuate by Mary Kuhner (3/26/97)
-------------------------------------------------------*/

#include "plot.h"

#include "fluctuate.h"

#ifdef DMALLOC_FUNC_CHECK
#include "/usr/local/include/dmalloc.h"
#endif

#define PLANESIZE 36
#define PLANEBIGTICKS 6
/* theta */
#define XPLANEBIGTICKVALUES {-4, -3, -2, -1, 0, 1}

#define XPLANETICKS {0.0001, 0.00014839817889675646, 0.0002202201949987376, \
   0.0003268027589410125, 0.00048496934285282005, 0.0007196856730011522, \
   0.0010680004325145755, 0.001584893192461114, 0.002351952635070959, \
   0.0034902548789595795, 0.005179474679231213, 0.007686246100397738, \
   0.01140624923851321, 0.01692666615037876, 0.025118864315095794, \
   0.0372759372031494, 0.05531681197617227, 0.08208914159638257, \
   0.12181879120101156, 0.1807768676963434, 0.2682695795279726, \
   0.39810717055349726, 0.5907837911587945, 0.8767123872968683, \
   1.3010252169108316, 1.9306977288832503, 2.865120269663781, \
   4.25178630338289, 6.309573444801933, 9.363292088239417, \
   13.894954943731374, 20.6198600950222, 30.59949687207196, \
   45.40909610972477, 67.38627168030948, 100.}
/*old  {0.001, 0.0013895, 0.0019307, 0.0026827, 0.00372759, \
                     0.00517947, 0.00719686, 0.01, 0.013895, 0.019307, \
                     0.026827, 0.0372759, 0.0517947, 0.0719686, 0.1, \
                     0.13895, 0.19307, 0.26827, 0.372759, 0.517947, \
                     0.719686, 1., 1.3895, 1.9307, 2.6827, 3.72759, \
                     5.17947, 7.19686, 10., 13.895, 19.307, 26.827, 37.2759, \
                     51.7947, 71.9686, 100.}*/

/* growth */
#define YPLANEBIGTICKVALUES {-10, -1, 1, 10, 100, 1000}
#define YPLANETICKS {-10.0, -7.19686, -5.17947, -3.72759, -2.6827, -1.9307, \
                    -1.3895, -1.0, -0.7, -0.5, -0.3, 0.3, 0.5, 0.7, \
                     1.0, 1.3895, 1.9307, 2.6827, 3.72759, \
                     5.17947, 7.19686, 10., 13.895, 19.307, 26.827, 37.2759, \
                     51.7947, 71.9686, 100., 138.95, 193.07, 268.27, \
                     372.759, 517.947, 719.686, 1000.0}
#define CONTOURLEVELS 8
#define CONTOURS_LOCUS {0.0,-1.38629/2., -5.99147/2., -9.21034/2.,\
                        0.0,-1.38629/2., -5.99147/2., -9.21034/2.}
#if 0
#define CONTOURS_LOCUS {0.0,-3.35670/2., -9.48773/2., -13.2767/2.,\
                        0.0,-3.35670/2., -9.48773/2., -13.2767/2.}
#define CONTOURS_LOCI  {0.0,-4.35146/2., -11.0705/2., -15.0863/2.,\
                        0.0,-4.35146/2., -11.0705/2., -15.0863/2.}
#endif

#define PAGEFEED fprintf(outfile,"\n\n\n\n");

extern long numloci, totchains;
extern FILE *outfile;

void plot_surface(long lowcus, char ***plane, long x)
{
   long i;
   long loci = numloci;

   fprintf(outfile, "\nLog-Likelihood surface\n");
   fprintf(outfile, "---------------------------------------\n\n");
   fprintf(outfile, "Legend:\n");
   fprintf(outfile, "   X = Maximum likelihood\n");
   fprintf(outfile, "   * = in approximative 50%% confidence limit\n");
   fprintf(outfile, "   + = in approximative 95%% confidence limit\n");
   fprintf(outfile, "   - = in approximative 99%% confidence limit\n");
   if (lowcus != -1) { /* single locus curve */
        fprintf(outfile,"\n\nLocus %li\n", lowcus + 1);
        fprintf(outfile,"y-axis = growth rate, x-axis = log base 10 of Theta\n");
	for (i = x+1; i >= 0; i--)
		 fprintf(outfile, "%45.45s\n", plane[lowcus][i]);
	fprintf(outfile, "%45.45s\n", plane[lowcus][x+2]);
	PAGEFEED;
   } else {
	fprintf(outfile, "\nOver all loci\n\n");
	lowcus = loci;
        fprintf(outfile,"x-axis = growth rate, y-axis = log base 10 of Theta\n");
	for (i = x+1; i >= 0; i--)
		fprintf(outfile, "%45.45s\n", plane[lowcus][i]);
	fprintf(outfile, "%45.45s\n", plane[lowcus][x+2]);
	PAGEFEED;
   }
} /* plot_surface */


void create_locus_plot(long lowcus, char **plane)
{
   long intervals = PLANESIZE;
   long i;
   double **pl;
   double contours[CONTOURLEVELS] = CONTOURS_LOCUS;

   pl = (double **) calloc(1, sizeof(double *) * intervals);
   for (i = 0; i < intervals; i++) {
	  pl[i] = (double *) calloc(1, sizeof(double) * 2 * intervals);
   }
   calc_locus_plane(lowcus,pl,contours);
   fill_plotplane(plane, pl, contours);
/*   print_mathematica(pl, intervals, intervals); */
   for (i = 0; i < intervals; i++) {
	  free(pl[i]);
   }
   free(pl);
}


/*private functions========================================== */
/* ---------------------------------------------------------
   creates memory for archive of timelists for each locus
   the "locus 0" is reserved for for the current locus, this
   fake locus is use to speed up the NR-estimation for all chains
   whereas the loci 1 .. n are used to save the results of the last
   chain for the combined estimate at the end of the program */

void create_plotplane(char**** plane)
{
   short locus, i;
   (*plane) = (char ***) calloc(1, sizeof(char **) * (numloci + 1));
   for (locus = 0; locus < numloci + 1; locus++) {
	  (*plane)[locus] = (char **) calloc(1, sizeof(char *)
						 * (PLANESIZE + 3));
	  for (i = 0; i < PLANESIZE + 3; i++) {
		 (*plane)[locus][i] = (char *) calloc(1, sizeof(char)
			 * (PLANESIZE + PLANESIZE + 20));
	  }
   }
}

void calc_locus_plane(long lowcus, double **pl, double contours[])
{
   long intervals = PLANESIZE;
   long lastchain = totchains - 1;
   long i, j;
   double max1 = -DBL_MAX;
   double max2 = -DBL_MAX;
   double xvalues[PLANESIZE] = XPLANETICKS;
   double yvalues[PLANESIZE] = YPLANETICKS;


   for (i = 0; i < intervals; i++) {
	  for (j = 0; j < intervals; j++) {
                 if (lowcus < 0) 
                   pl[i][j] = fluc_locus_llike(xvalues[i],yvalues[j]);
                 else pl[i][j] =
                   model_llike(xvalues[i],yvalues[j],lastchain,lowcus);
		 if (max1 < pl[i][j])
			max1 = pl[i][j];
	  }
   }
   contours[0] += max1;
   contours[1] += max1;
   contours[2] += max1;
   contours[3] += max1;
   contours[4] += max2;
   contours[5] += max2;
   contours[6] += max2;
   contours[7] += max2;
} /* calc_locus_plane */

void fill_plotplane(char **plane, double **pl, double contours[])
{
   long i, j, zz = 0;

   char line[100];
   long yval[PLANEBIGTICKS] = YPLANEBIGTICKVALUES;
   long intervals = PLANESIZE;
   for (i = 0; i < intervals; i++) {
	  if (i % 7)
		 line[i] = '-';
	  else
		 line[i] = '+';
   }
   line[i] = '\0';
   sprintf(plane[0], "     +%s+    +%s+   ", line, line);
   for (i = 0; i < intervals; i++) {
	  memset(plane[i + 1], ' ', sizeof(char) * (intervals + intervals + 20));
	  plane[i + 1][intervals + intervals + 19] = '\0';
	  if (!((i) % 7)) {
		 sprintf(plane[i + 1], "  %2.0li +", yval[zz++]);
		 if(yval[zz-1]==0)
		   plane[i+1][3]='0';
	  }
	  else
		 plane[i + 1][5] = '|';
	  for (j = 0; j < intervals; j++) {
		 if (pl[j][i] < contours[1]) {
			if (pl[j][i] < contours[2]) {
			   if (pl[j][i] < contours[3]) {
				  plane[i + 1][j + 6] = ' ';
			   }
			   else {
				  plane[i + 1][j + 6] = '-';
			   }
			}
			else {
			   plane[i + 1][j + 6] = '+';
			}
		 }
		 else {
			if (pl[j][i] < contours[0] - EPSILON)
			   plane[i + 1][j + 6] = '*';
			else {
			   plane[i + 1][j + 6] = 'X';
			}
		 }
	  }
	  if ((i) % 7) {
		 plane[i + 1][j + 6] = '|';
		 plane[i + 1][j + 11] = '|';
	  }
	  else {
		 plane[i + 1][j + 6] = '+';
		 plane[i + 1][j + 11] = '+';
	  }
   }
   sprintf(plane[intervals+1], "     +%s+    +%s+", line, line);
   sprintf(plane[intervals+2], "-3     -2     -1      0      1      2   ");
}

void print_mathematica(double **plane, long x, long y)
{
   long i, j;
   static long number = 1;
   FILE *mathfile;

   mathfile = fopen("mathfile","w+");

   fprintf(mathfile, "\n\nlocus%-li={{\n", number++);
   for (i = 0; i < x-1; i++) {
      fprintf(mathfile, "{");
      for (j = 0; j < y-1; j++) {
         fprintf(mathfile, "%20.20g,", plane[i][j]);
      }
      fprintf(mathfile, "%20.20g},\n", plane[i][j]);
   }
   fprintf(mathfile, "{");
   for (j = 0; j < y-1; j++) {
      fprintf(mathfile, "%20.20g,", plane[i][j]);
   }
   fprintf(mathfile, "%20.20g}},{\n", plane[i][j]);
   for (i = 0; i < x-1; i++) {
	 fprintf(mathfile, "{");
	 for (j = y; j < 2 * y-1; j++) {
		fprintf(mathfile, "%20.20g,", plane[i][j]);
	 }
	 fprintf(mathfile, "%20.20g},\n", plane[i][j]);
  }
  fprintf(mathfile, "{");
  for (j = y; j < 2 * y-1; j++) {
	 fprintf(mathfile, "%20.20g,", plane[i][j]);
  }
  fprintf(mathfile, "%20.20g}}}\n", plane[i][j]);

   fclose(mathfile);

} /* print_mathematica */

void free_plotplane(char ****plane)
{
  long i, j;

  for (i=0; i< numloci + 1; i++) {
    for (j=0; j< PLANESIZE + 3; j++) {
      free((*plane)[i][j]);
    }
    free((*plane)[i]);
  }
  free(*plane);
} /* free_plotplane */

void print_locusplot (long lowcus)
{
char ***plane;

create_plotplane(&plane);
if (lowcus!= -1)
   create_locus_plot(lowcus,plane[lowcus]);
else create_locus_plot(lowcus,plane[numloci]);
plot_surface(lowcus,plane,(long)PLANESIZE);
free_plotplane(&plane);

} /* plot_locus */
