#ifndef __EPRINTF_H__
#define __EPRINTF_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003, 2004 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/
/****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/

#include "mail.h"
#include "address.h"
#include "keymap.h"
#include "str.h"
#include "rstring.h"

/****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/

typedef struct {
        char *command;
        char *fname;
        char *mime_type;
        int   lineno;
        int   col;
        int   pos;
} eprintf_command_t;

/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/

extern void  eprintf_mail_str (const char *fmt, mail_t *mail, str_t *str);
extern char *eprintf_mail (const char *fmt, mail_t *mail);
extern void  eprintf_mail_desc (const char *fmt, str_t *str);
extern char *eprintf_command (const char *fmt, const eprintf_command_t *cmd);
extern void  eprintf_addr_str (const char *fmt, address_t *addr, str_t *str);
extern void  eprintf_addr_desc (const char *fmt, str_t *str);
extern char *eprintf_key (const char *fmt, struct _key *key, int meta);
extern void  eprintf_box_str (const char *fmt, const char *box, str_t *str);
extern void  eprintf_mime_str (const char *fmt, mime_t *mime, str_t *str);
extern char *eprintf_rstring (const char *fmt, rstring_t *values);

/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER eprintf.h
 *
 ****************************************************************************/
#endif
