/* eLectrix - a pdf viewer
 * Copyright (C) 2010, 2011 Martin Linder <mali2297@users.sf.net>
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program. If not, see <http://www.gnu.org/licenses/gpl-2.0.html>. 
 */
#pragma once
#ifndef __E6X_VIEW_H__
#define __E6X_VIEW_H__

#include <gtk/gtk.h>
#include "e6x-common.h"
#include "e6x-document.h"

#define E6X_TYPE_VIEW \
  (e6x_view_get_type ())
#define E6X_VIEW(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), E6X_TYPE_VIEW, E6xView))
#define E6X_VIEW_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_CAST ((obj), E6X_TYPE_VIEW,  E6xViewClass))
#define E6X_IS_VIEW(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), E6X_TYPE_VIEW))
#define E6X_IS_VIEW_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_TYPE ((obj), E6X_TYPE_VIEW))
#define E6X_VIEW_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), E6X_TYPE_VIEW, E6xViewClass))

typedef struct _E6xView E6xView;
typedef struct _E6xViewClass E6xViewClass;
typedef struct _E6xViewPrivate E6xViewPrivate;

struct _E6xView
{
  GtkWidget parent;
  E6xViewPrivate *priv;
  GtkAdjustment *hadj, *vadj;
  gboolean select_mode;
};

struct _E6xViewClass
{
  GtkWidgetClass parent_class;
  gboolean (*set_scroll_adjustments) (E6xView *view,
                                      GtkAdjustment *hadj,
                                      GtkAdjustment *vadj);
};

GType e6x_view_get_type ();
GtkWidget *e6x_view_new ();
void e6x_view_set_document (E6xView *view, 
                            E6xDocument *doc);
E6xDocument *e6x_view_get_document (E6xView *view);
void e6x_view_refresh (E6xView *view);
gboolean e6x_view_show_nth_match (E6xView *view,
                                  const gchar *string,
                                  guint match_no);
gboolean e6x_view_has_history (E6xView *view,
                               E6xDirection dir);
void e6x_view_walk_history (E6xView *view,
                            E6xDirection dir);
void e6x_view_set_select_mode (E6xView *view,
                               gboolean mode);
#endif /* __E6X_VIEW_H__ */
