/* eLectrix - a pdf viewer
 * Copyright (C) 2010 Martin Linder <mali2297@users.sf.net>
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program. If not, see <http://www.gnu.org/licenses/gpl-2.0.html>.
 */
#pragma once
#ifndef __E6X_SCALE_SELECTOR_H__
#define __E6X_SCALE_SELECTOR_H__

#include <gtk/gtk.h>
#include "e6x-document.h"

#define E6X_TYPE_SCALE_SELECTOR \
  (e6x_scale_selector_get_type ())
#define E6X_SCALE_SELECTOR(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), E6X_TYPE_SCALE_SELECTOR, E6xScaleSelector))
#define E6X_SCALE_SELECTOR_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_CAST ((obj), E6X_TYPE_SCALE_SELECTOR,  E6xScaleSelectorClass))
#define E6X_IS_SCALE_SELECTOR(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), E6X_TYPE_SCALE_SELECTOR))
#define E6X_IS_SCALE_SELECTOR_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_TYPE ((obj), E6X_TYPE_SCALE_SELECTOR))
#define E6X_SCALE_SELECTOR_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), E6X_TYPE_SCALE_SELECTOR, E6xScaleSelectorClass))

typedef struct _E6xScaleSelector E6xScaleSelector;
typedef struct _E6xScaleSelectorClass E6xScaleSelectorClass;
typedef struct _E6xScaleSelectorPrivate E6xScaleSelectorPrivate;

struct _E6xScaleSelector
{
  GtkHBox parent;
  E6xScaleSelectorPrivate *priv;
};

struct _E6xScaleSelectorClass
{
  GtkHBoxClass parent_class;
};

GType e6x_scale_selector_get_type ();
GtkWidget *e6x_scale_selector_new ();
void e6x_scale_selector_set_document (E6xScaleSelector *selector, 
                                      E6xDocument *doc);

#endif /* __E6X_SCALE_SELECTOR_H__ */
