/* eLectrix - a pdf viewer
 * Copyright (C) 2010, 2011 Martin Linder <mali2297@users.sf.net>
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program. If not, see <http://www.gnu.org/licenses/gpl-2.0.html>.
 */
#pragma once
#ifndef __E6X_DOCUMENT_H__
#define __E6X_DOCUMENT_H__

#include <gtk/gtk.h>
#include <cairo.h>

#define E6X_TYPE_DOCUMENT \
  (e6x_document_get_type ())
#define E6X_DOCUMENT(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), E6X_TYPE_DOCUMENT, E6xDocument))
#define E6X_DOCUMENT_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_CAST ((obj), E6X_TYPE_DOCUMENT,  E6xDocumentClass))
#define E6X_IS_DOCUMENT(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), E6X_TYPE_DOCUMENT))
#define E6X_IS_DOCUMENT_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_TYPE ((obj), E6X_TYPE_DOCUMENT))
#define E6X_DOCUMENT_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), E6X_TYPE_DOCUMENT, E6xDocumentClass))

typedef struct _E6xDocument E6xDocument;
typedef struct _E6xDocumentClass E6xDocumentClass;
typedef struct _E6xDocumentPrivate E6xDocumentPrivate;

struct _E6xDocument
{
  GObject parent;
  E6xDocumentPrivate *priv;
  
  /* Read only! */
  gchar *filename;
  gchar *passwd;
  gchar *title;
  gchar **info;
  GtkTreeModel *toc;
  GtkTreeModel *attlist;
  guint page_no;
  guint n_pages;
  gdouble scale;
  gint angle;
  gdouble fit_width;
  gdouble fit_height;
  gboolean color_inversion;
  gboolean show_toc;
};

struct _E6xDocumentClass
{
  GObjectClass parent_class;
  
  gboolean (*reload) (E6xDocument *doc,
                      GError **error);
  gboolean (*save_copy) (E6xDocument *doc,
                         const gchar *filename,
                         GError **error);
  void (*get_page_size) (E6xDocument *doc,
                         gdouble *width,
                         gdouble *height);  
  cairo_surface_t *(*render_page) (E6xDocument *doc);
  gchar *(*get_text) (E6xDocument *doc, 
                      GdkRectangle rect);
  guint (*get_n_matches) (E6xDocument *doc, 
                          guint page_no,
                          const gchar *string);
  GdkRectangle *(*get_nth_match) (E6xDocument *doc,
                                 guint page_no,
                                 const gchar *string,
                                 guint match_no);
  gboolean (*is_at_link) (E6xDocument *doc, 
                          GdkPoint pos);
  gboolean (*go_to_link) (E6xDocument *doc, 
                          GdkPoint pos);
  gchar *(*get_tip) (E6xDocument *doc, 
                     GdkPoint pos);
  gboolean (*go_to_bookmark) (E6xDocument *doc, 
                              GtkTreeIter *iter);
  gboolean (*save_att) (E6xDocument *doc, 
                        GtkTreeIter *iter,
                        const gchar *filename,
                        GError **error);
};

GType e6x_document_get_type ();
void e6x_document_set_page_no (E6xDocument *doc, 
                               guint no);
void e6x_document_set_scale (E6xDocument *doc, 
                             gdouble scale);
void e6x_document_set_angle (E6xDocument *doc, 
                             gint angle);
void e6x_document_set_fit (E6xDocument *doc, 
                           gdouble width,
                           gdouble height);
void e6x_document_set_color_inversion (E6xDocument *doc, 
                                       gboolean inversion);
void e6x_document_set_show_toc (E6xDocument *doc, 
                                gboolean show);
gboolean e6x_document_reload (E6xDocument *doc,
                              GError **error);
gboolean e6x_document_save_copy (E6xDocument *doc,
                                 const gchar *filename,
                                 GError **error);
void e6x_document_get_page_size (E6xDocument *doc,
                                 gdouble *width,
                                 gdouble *height);
cairo_surface_t *e6x_document_render_page (E6xDocument *doc);
gchar *e6x_document_get_text (E6xDocument *doc, 
                              GdkRectangle rect);
guint e6x_document_get_n_matches (E6xDocument *doc, 
                                  guint page_no,
                                  const gchar *string);
GdkRectangle *e6x_document_get_nth_match (E6xDocument *doc,
                                          guint page_no,
                                          const gchar *string,
                                          guint match_no);
gboolean e6x_document_is_at_link (E6xDocument *doc, 
                                  GdkPoint pos);
gboolean e6x_document_go_to_link (E6xDocument *doc, 
                                  GdkPoint pos);
gchar *e6x_document_get_tip (E6xDocument *doc, 
                             GdkPoint pos);
gboolean e6x_document_go_to_bookmark (E6xDocument *doc, 
                                      GtkTreeIter *iter);
gboolean e6x_document_save_att (E6xDocument *doc, 
                                GtkTreeIter *iter,
                                const gchar *filename,
                                GError **error);

enum
{
  E6X_TOC_COL_TITLE,
  E6X_TOC_COL_PAGENO,
  E6X_TOC_COL_POINTER,
  E6X_TOC_NCOLS
};

enum
{
  E6X_ATT_COL_NAME,
  E6X_ATT_COL_DESC,
  E6X_ATT_COL_CTIME,
  E6X_ATT_COL_MTIME,
  E6X_ATT_COL_SIZE,
  E6X_ATT_COL_POINTER,
  E6X_ATT_NCOLS
};

#endif /* __E6X_DOCUMENT_H__ */
