/**********************************************************************
 *
 * /proc interface
 *
 **********************************************************************/
#include <linux/config.h>

#ifdef CONFIG_PROC_FS

#include <linux/proc_fs.h>

#define __NO_VERSION__
#include <linux/module.h>

#include "cpia2.h"

#ifdef CPIA2_ENABLE_PROC

#define CPIA2_PROC_DIR "driver/cpia2"

static int cpia2_proc_read(char *page, char **start, off_t off,
			   int count, int *eof, void *data)
{
	return sprintf(page, "This hasn't been written yet.\n");
}

static int cpia2_proc_write(struct file *file, const char *buf,
			    unsigned long count, void *data)
{
	return -EINVAL;
}

void cpia2_proc_set_owner(struct camera_data *cam, int uid)
{
	if (cam->proc_entry)
		cam->proc_entry->uid = current->uid;
}

void cpia2_proc_create_cam(struct camera_data *cam)
{
	char name[80];
	struct proc_dir_entry *ent;

	if (!cam)
		return;

	sprintf(name, CPIA2_PROC_DIR "/video%d", cam->vdev.minor);

	ent = create_proc_entry(name, S_IFREG | S_IRUGO | S_IWUSR, 0);
	if (!ent)
		return;

	ent->data = cam;
	ent->read_proc = cpia2_proc_read;
	ent->write_proc = cpia2_proc_write;
	ent->size = 0;
	ent->owner = THIS_MODULE;
	cam->proc_entry = ent;
	cpia2_proc_set_owner(cam, 0);
}

void cpia2_proc_destroy_cam(struct camera_data *cam)
{
	char name[80];

	if (!cam || !cam->proc_entry)
		return;

	DBG("destroying /proc/driver/cpia/video%d\n", cam->vdev.minor);

	sprintf(name, CPIA2_PROC_DIR "/video%d", cam->vdev.minor);
	remove_proc_entry(name, 0);
	cam->proc_entry = NULL;
}

void cpia2_proc_create(void)
{
	struct proc_dir_entry *ent;

	ent = create_proc_entry(CPIA2_PROC_DIR, S_IFDIR, 0);

	if (ent) {
		ent->owner = THIS_MODULE;
	} else
		LOG("Unable to initialise /proc/" CPIA2_PROC_DIR "\n");
}

void cpia2_proc_destroy(void)
{
	remove_proc_entry(CPIA2_PROC_DIR, 0);
}

#endif				/* CPIA2_ENABLE_PROC */
#endif				/* CONFIG_PROC_FS */
