# ActivityStreams Tool

```
go get github.com/go-fed/activity
cd $GOPATH/github.com/go-fed/activity/astool
go build
./astool -h
```

## Overview

The code-generation tool for ActivityStreams and extensions.

This tool is simple: It accepts an RDF definition in OWL2 syntax of an
ActivityStreams vocabulary, and generates the Go code required to:

- Create native types and properties of this vocabulary.
- Handle the serialization and deserialization of JSON correctly, including
  the instances where non-functional properties could be an object (`{}`),
  an array of objects and/or IRIs (`[]`), or an IRI (`https://exmaple.com/id`).
- Manages the ActivityStreams inheritance properly of `extends` and `disjoint`,
  which is in the RDF-sense. It is not the same kind of inheritance as the
  Object Oriented sense of inheritance.
- Provides Resolvers and PredicatedResolvers to (conditionally) take arbitrary
  objects or data and resolve them into concrete types.

All of the above code is autogenerated, allowing:

- Application developers to rapidly use the needed ActivityStreams in their
  domain.
- Extension writers a quick way to iteratively prototype a new ActivityStreams
  extension, skipping boilerplate code writing in the process.
- Go-fed alternatives to fork the tool and generate their own implementations,
  or hook their own implementations into the dependency-injected Manager so they
  are used in existing applications seamlessly.

All code is generated in the current working directory that the tool is executed
in.

## Generating the ActivityStreams Vocabulary

Comprehensive help is available at:

```
astool -h
```

The ActivityStreams tool accepts one or more specifications for the
[Core And Extended ActivityStreams](https://www.w3.org/TR/activitystreams-vocabulary)
vocabulary as well as any derived vocabularies. For example, bundled with this
tool is `activitystreams.jsonld` which contains the OWL2 definition of the
ActivityStreams specification. To generate the code, in your `$GOPATH` do:

```
cd $GOPATH/github.com/go-fed/activity/astool
go generate
```

This will automatically generate a number of files containing the functions,
structs, and interfaces for use in your program. Alternatively, the
`go-fed/activity` library has all of these pregenerated for you.

## Generating An Extension

If you want to create an ActivityStreams Extensions, see the provided file
`example_custom_spec.jsonld` which contains a custom type and property which
leverage the original ActivityStreams specification.

Any new derived extension must be passed into the tool, as well as any
dependencies, in order of derivation:

```
mkdir tmp
cd tmp
astool -spec activitystreams.jsonld -spec example_custom_spec.jsonld
```

This automatically generates a number of files containing the functions,
structs, and interfaces for both of these vocabularies.

## Generating As A Module

The tool has untested, experimental support for generating code with a specific
prefix path to all package names:

```
mkdir tmp
cd tmp
astool -spec activitystreams.jsonld -path mymodule
```

## Known Limitations

This tool relies on built-in knowledge of several ontologies:

- OWL2
- RDF
- RDF Schema
- Schema.org
- XML Schema
- RFCs

It does not have complete knowledge of these schemas, so if an error is
encountered during the code generation process with a new extension, please
[file an issue](https://github.com/go-fed/activity/issues).

## Non-Standard Behaviors

ActivityPub has a requirement where properties in a base type are not inherited
by deriving types. This concept is one reason why the ActivityStreams vocabulary
cannot be mapped into a traditional object-oriented programming language. It
also means that we need an RDF/OWL/JSON-LD concept to encapsulate this detail.
Unfortunately, no standards body provides an RDF definition of this meaning, so
the `astool` uses the JSON-LD reserved notation `@wtf_without_property` to
trigger code generation that results in this behavior.

It is the hope of this author that the prefix `@wtf` would never be used by the
JSON-LD authors and would never have a chance to become a de-facto standard due
to the implied profanity. Furthermore, its use should be extremely limited.
Therefore, the use of this non-standard keyworld only for the `astool` and in
limited applications should never collide with anything else.

This notation is used in two places:

* [Intransitive Activity](https://www.w3.org/TR/activitystreams-vocabulary/#dfn-intransitiveactivity)
does not have the `object` property, so this is a spec-compliant use.
* `OrderedCollection` so that it does not have both `items` and `orderedItems`
properties. This is an opinion: `items` for `Collection` and `orderedItems` for
`OrderedCollection`.

## References

* [JSON-LD Specification](https://json-ld.org/spec/latest/json-ld/)
