pub mod list;
pub mod view;

use clap::Subcommand;

use super::GlobalArgs;

/// Notification subcommands
#[derive(Debug, Subcommand)]
pub enum NotificationArgs {
    List(list::ListNotificationArgs),
    View(view::ViewNotificationArgs),
}

impl NotificationArgs {
    pub async fn run(self, global_args: GlobalArgs) -> miette::Result<()> {
        match self {
            NotificationArgs::List(args) => args.run(global_args).await,
            NotificationArgs::View(args) => args.run(global_args).await,
        }
    }
}
