mod add;
mod list;
mod remove;
mod verify;

use clap::Subcommand;

use super::GlobalArgs;

/// Gpg key management
#[derive(Subcommand, Debug)]
pub enum GpgArgs {
    List(list::ListGpgArgs),
    Add(add::AddGpgArgs),
    Remove(remove::RemoveGpgArgs),
    Verify(verify::VerifyGpgArgs),
}

impl GpgArgs {
    pub async fn run(self, global_args: GlobalArgs) -> miette::Result<()> {
        match self {
            GpgArgs::List(args) => args.run(global_args).await,
            GpgArgs::Add(args) => args.run(global_args).await,
            GpgArgs::Remove(args) => args.run(global_args).await,
            GpgArgs::Verify(args) => args.run(global_args).await,
        }
    }
}

pub fn gpg_key_identifier(key: &forgejo_api::structs::GPGKey) -> String {
    format!(
        "{pubkey} {email}",
        pubkey = key.key_id.as_deref().unwrap_or("???"),
        email = key
            .emails
            .iter()
            .flatten()
            .filter_map(|mail| mail.email.as_deref())
            .next()
            .unwrap_or("???")
    )
}
