pub mod version;

use clap::Subcommand;

use super::GlobalArgs;

/// API subcommands
#[derive(Debug, Subcommand)]
pub enum ApiArgs {
    Version(version::ApiVersionArgs),
}

impl ApiArgs {
    pub async fn run(self, global_args: GlobalArgs) -> miette::Result<()> {
        match self {
            ApiArgs::Version(args) => args.run(global_args).await,
        }
    }
}
