{ inputs, ... }:
{
  perSystem =
    { system, ... }:
    let
      fnx = inputs.fenix.packages.${system};
    in
    {
      packages = {
        buildToolchain = fnx.combine [
          fnx.stable.cargo
          fnx.stable.rustc
        ];

        devToolchain = fnx.combine [
          fnx.stable.cargo
          fnx.stable.clippy
          fnx.stable.rust-analyzer
          fnx.stable.rust-src
          fnx.stable.rustc

          fnx.complete.rustfmt
        ];
      };

    };
}
