use clap::ValueEnum;
use serde::{Deserialize, Serialize};
use strum::{Display, EnumIter, EnumString, VariantArray};

#[derive(
    Debug,
    Clone,
    Copy,
    Serialize,
    Deserialize,
    ValueEnum,
    Display,
    EnumIter,
    EnumString,
    VariantArray,
)]
#[strum(serialize_all = "lowercase")]
#[serde(rename_all = "lowercase")]
pub enum ViewStateType {
    Closed,
    Open,
    All,
}

impl ViewStateType {
    pub fn available_for_choosing() -> [Self; 2] {
        use ViewStateType::*;
        [Closed, Open]
    }

    pub fn is_done(&self) -> bool {
        use ViewStateType::*;
        match self {
            Closed => true,
            Open => false,
            All => false,
        }
    }
}
