pub mod login;
pub mod logout;

use clap::Subcommand;

use super::GeneralArgs;

/// Authentication subcommands
#[derive(Subcommand, Debug)]
pub enum AuthArgs {
    Login(login::LoginArgs),
    Logout(logout::LogoutArgs),
}

impl AuthArgs {
    pub async fn run(self, general_args: GeneralArgs) -> anyhow::Result<()> {
        match self {
            AuthArgs::Login(args) => args.run(general_args).await,
            AuthArgs::Logout(args) => args.run(general_args).await,
        }
    }
}
