use crate::actions::GeneralArgs;
use crate::paths::token_path;
use crate::render::ui::confirm_with_prompt;
use crate::types::context::BergContext;

use clap::Parser;

/// Logout. Delete currently stored authentication token
#[derive(Parser, Debug)]
pub struct LogoutArgs {
    /// flag that skips the confirmation dialog if set
    #[arg(short, long)]
    pub skip_confirmation: bool,
}

impl LogoutArgs {
    pub async fn run(self, general_args: GeneralArgs) -> anyhow::Result<()> {
        let _ = general_args;
        let ctx = BergContext::new(self, general_args).await?;
        if !ctx.args.skip_confirmation
            && !confirm_with_prompt(
                "Logging out deletes your current token. Do you want to proceed?",
            )?
        {
            return Ok(());
        }

        let token_path = token_path()?;

        std::fs::remove_file(token_path)?;

        Ok(())
    }
}
